/***
*excpt.h - defines exception values, types and routines
*
*Purpose:
*   This file contains the definitions and prototypes for the compiler-
*   dependent intrinsics, support functions and keywords which implement
*   the structured exception handling extensions.
*
****/

/* $Copyright: 1993$ */

#ifndef __EXCPT_H
#define __EXCPT_H

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned char BYTE;
typedef unsigned long DWORD;
typedef void          *LPVOID;
typedef unsigned int  UINT;
typedef DWORD         *LPDWORD;
#define WINAPI

/* From WINNT.H */
#define EXCEPTION_CONTINUABLE        0      // Continuable exception
#define EXCEPTION_NONCONTINUABLE     0x1    // Noncontinuable exception

//
// Exception record definition.
//

typedef struct _EXCEPTION_RECORD {
    DWORD ExceptionCode;
    DWORD ExceptionFlags;
    struct _EXCEPTION_RECORD *ExceptionRecord;
    LPVOID ExceptionAddress;
    UINT NumberParameters;
    DWORD ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
} EXCEPTION_RECORD;

typedef EXCEPTION_RECORD *PEXCEPTION_RECORD;

//
// Typedef for pointer returned by exception_info()
//

struct  _CONTEXT;

typedef struct  _CONTEXT        *PCONTEXT;

typedef struct _EXCEPTION_POINTERS {
    PEXCEPTION_RECORD ExceptionRecord;
    PCONTEXT ContextRecord;
} EXCEPTION_POINTERS, *PEXCEPTION_POINTERS;

long
WINAPI
UnhandledExceptionFilter(PEXCEPTION_POINTERS ExceptionInfo);

typedef long (WINAPI *PTOP_LEVEL_EXCEPTION_FILTER)(
   PEXCEPTION_POINTERS ExceptionInfo
   );
typedef PTOP_LEVEL_EXCEPTION_FILTER LPTOP_LEVEL_EXCEPTION_FILTER;

LPTOP_LEVEL_EXCEPTION_FILTER
WINAPI
SetUnhandledExceptionFilter(
   LPTOP_LEVEL_EXCEPTION_FILTER lpTopLevelExceptionFilter
   );

/*
 * Exception disposition return values.
 */
typedef enum _EXCEPTION_DISPOSITION {
    ExceptionContinueExecution,
    ExceptionContinueSearch,
    ExceptionNestedException,
    ExceptionCollidedUnwind
} EXCEPTION_DISPOSITION;


/*
 * Borland C++
 */
#ifndef __cplusplus
#  define try                       __try
#  define finally                   __finally
#  define AbnormalTermination()     __abnormal_termination
#endif

#  define except                    __except
#  define GetExceptionCode()        __exception_code
#  define GetExceptionInformation() ((PEXCEPTION_POINTERS)__exception_info)

/*
 * Legal values for expression in except().
 */

#define EXCEPTION_EXECUTE_HANDLER        1
#define EXCEPTION_CONTINUE_SEARCH        0
#define EXCEPTION_CONTINUE_EXECUTION    -1

#ifdef __cplusplus
}
#endif

#endif  /* __EXCPT_H */
