// LRSet
// This object will find the linear regression parameters for a set of
// data.  This data may be added a node at a time or it may be taken from
// a file.  The data must be in correlated and thus in the form (Xi, Yi)


#include <stdio.h>
#include <stdlib.h>

#include "llist.h"


class DataPoint                   // Type of data being dealt with
{
  public:
  double x;                       // First point (not necissarily coord)
  double y;                       // Second point.
};

class LRSet : public LList        // Linear Regression Set devired from LList.
{                                 //   List hold data points to work with.
  public:

  LRSet(void);                    // Initializer.
  void AddList(LList *ReadList);  // Add to this list from another.
  void AddFile(char *filename);   // Add to this list from a file.
  void AddNode(double x, double y);  // Add a node to the list.

  void CalcLR(void);              // Calculate the linear regression

  double B1;                      // Output area for B1
  double B0;                      // Output area for B0
};