// LList Object
// Linked list object definition

#include "LList.h"


/***********  Use this main as an example **********
class DumbData
{
  public:
  char Data[10];
};

void main(void)
{
  clrscr();
  LList L;
  char input[10]="XYZ";
  DumbData *temp;
  printf("Go!\n");

  while (0!=strlen(input)){
    gets(input);
    L.Add(new DumbData,LL_ADD_AFTER);
    L.Next();
    temp=(DumbData*)L.Retrieve(LL_DATA);
    strcpy(temp->Data,input);
    printf("Original value= %s\n",temp->Data);
  }
  while (L.Retrieve(LL_PREV) != NULL){
    temp=(DumbData*)L.Retrieve(LL_DATA);
    printf("%s\n",temp->Data);
    L.Remove(LL_PREV);
//    L.Prev();
    if (kbhit()) exit(0);
  }
  L.Restart();
  L.Assign(new DumbData);
  temp=(DumbData*)L.Retrieve(LL_DATA);
  strcpy(temp->Data,"This is DumbData!");
  temp=(DumbData*)L.Retrieve(LL_DATA);
  printf("%s\n",temp->Data);
}

*/


LList::LList(void)
{
  LL_Head=NULL;
  LL_Cur=NULL;
  NumNodes=0;
  AtEnd=0;
}

LList::~LList(void)
{
  LL_Cur=LL_Head;
  if (LL_Head != NULL){
    while (LL_Cur->Next != NULL){
      Next();
    }
    while (LL_Cur->Prev != NULL){
      Remove(LL_PREV);
    }
    Remove(LL_HEAD);
  }
  if (NumNodes) printf("WARNING: Lost nodes\n");
}

void LList::Add(void *Data, int BorF)
{
  LLNode *noclue;

  LL_temp=new LLNode;
  ++NumNodes;
  LL_temp->Data = Data;

  if(LL_Cur != NULL){
    if (BorF==LL_ADD_AFTER){
      LL_temp->Next = LL_Cur->Next;
      LL_Cur->Next = LL_temp;
      LL_temp->Prev = LL_Cur;

      noclue = LL_temp->Next;
      if (noclue != NULL) {
	(*noclue).Prev=LL_temp;
      }
    }
    if (BorF==LL_ADD_BEFORE){
      LL_temp->Prev = LL_Cur->Prev;
      LL_Cur->Prev = LL_temp;
      LL_temp->Next = LL_Cur;

      noclue=LL_temp->Prev;
      if (noclue != NULL){
	(*noclue).Next=LL_temp;
      }
    }
  }
  else{
    LL_temp->Next=NULL;
    LL_temp->Prev=NULL;
    LL_Cur = LL_temp;
    LL_Head = LL_temp;
  }
}

void LList::Remove(int GoWhere)
{
  if (LL_Cur==NULL) return;
  --NumNodes;

  delete(LL_Cur->Data); // Need to confirm that this is deleting OK.
  LL_Cur->Data=NULL;    //   Sure would be cool if it was.

  if ((LL_Cur->Next) != NULL){
    (*(LL_Cur->Next)).Prev=LL_Cur->Prev;
  }
  if ((LL_Cur->Prev) != NULL){
    (*(LL_Cur->Prev)).Next=LL_Cur->Next;
  }

  if (DEBUG && LL_Cur->Data != NULL)
    printf("WARNING: Deleting node with non-NULL data pointer.\n");

  if (GoWhere==LL_HEAD){
    LL_temp=LL_Head;
  }
  if (GoWhere==LL_NEXT){
    LL_temp=LL_Cur->Next;
  }
  if (GoWhere==LL_PREV){
    LL_temp=LL_Cur->Prev;
  }
  delete LL_Cur;
  LL_Cur=LL_temp;
}

void LList::Assign(void *Data)
{
  if (LL_Cur==NULL && DEBUG){
    printf("WARNING: There has been an attempt to put data in a non-existant node.\n");
    return;
  }
  LL_Cur->Data = Data;
}

void *LList::Retrieve(int GetWhat)
{
  if (LL_Cur==NULL && DEBUG){
    printf("WARNING: There has been an attempt to get data from a non-existant node.\n");
    return(NULL);
  }
  if (GetWhat==LL_DATA){
    return(LL_Cur->Data);
  }
  // This two return the values of private variables.
  // They are intended only to be used in a NULL vs. NOT-NULL way.
  if (GetWhat==LL_NEXT){
    return(LL_Cur->Next);
  }
  if (GetWhat==LL_PREV){
    return(LL_Cur->Prev);
  }
  if (GetWhat==LL_NUM_NODES){
    return(&NumNodes);
  }
  return(0);
}

void LList::Next(void)
{
  AtEnd=0;
  if (LL_Cur->Next != NULL){
    LL_Cur = LL_Cur->Next;
  }
  else{
    AtEnd=1;
  }
}

void LList::Prev(void)
{
  AtEnd=0;
  if (LL_Cur->Prev != NULL){
    LL_Cur = LL_Cur->Prev;
  }
  else{
    AtEnd=1;
  }
}

void LList::Restart(void)
{
  AtEnd=0;
  LL_Cur = LL_Head;
}