// ASCII Table 1.1
// Copyright 1998 by D.J. van Enckevort
// This program and sourcecode is released as freeware
// You can use this code for your own programs
// If you use it, please keep a notice of this copyright

#define INCL_WIN
#define INCL_PM
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "ascii.h"

// declaration of the hab
HAB hab;

// Program main function
// Arguments:
// argc number of commandline arguments;
// argv commandline arguments
// Note argv[0] is the name of the program
// no return code
void main(int argc, char *argv[])
{
HMQ hmq;
HWND hwnd = NULLHANDLE;
QMSG qmsg;
char Path[CCHMAXPATH], *Program = NULL, FullName[CCHMAXPATH];
HINI Profile;

// Do the usual initialization
hab=WinInitialize(0);
hmq=WinCreateMsgQueue(hab, 0);

// Open ASCII.INI
strcpy(Path, argv[0]);
strlwr(Path);
Program=strstr(Path, "ascii.exe");
Program[0]=0;
strcpy(FullName, Path);
strcat(FullName, "ascii.ini");
Profile=PrfOpenProfile(hab, FullName);

// Load the main window from the executable resources
hwnd=WinLoadDlg(HWND_DESKTOP, HWND_DESKTOP, WinProc, (HMODULE)0, DLG_ASCII, &Profile);

// Start the message queue
while (WinGetMsg(hab, &qmsg, 0L, 0, 0))
  WinDispatchMsg(hab, &qmsg);

// Finish the program and exit
PrfCloseProfile(Profile);
WinDestroyWindow(hwnd);
WinDestroyMsgQueue(hmq);
WinTerminate(hab);
}

// Window procedure for the main window
// Is called by the system
MRESULT EXPENTRY WinProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
// Several variables
// Used in WM_COMMAND and WM_CONTROL (NotifyCode)
USHORT ControlID, NotifyCode;
// Used in WM_CONTROL to store text from value set
VSTEXT vsText;
// Used in WM_INITDLG
USHORT row, col;
// Used in WM_COMMAND
// Used for the Font Dialog
static FONTDLG fd;
HWND hwndFD;
HPS hps;
// Used for Copy & Clear
IPT Len;
// CurrentFont used for fontselection & fontset
// ch used in WM_INITDLG
char ch[2], temp[11];
static char CurrentFont[FACESIZE];
// Pointsize of the font
static int PointSize;
// static to remember the value of this variable between different calls
// Used in UM_RESIZE to size the controls
static SWP oldframe, initialframe;
SWP newframe;
// Pointer the the handle to the .INI file
static HINI *pProfile;
ULONG Size;
switch (msg)
   {
   case WM_INITDLG:
      // Initialize window
      // ch[0] contains the character to display in the cell of the value set
      // ch[1] is the termination zero of the string
      ch[0]=0;
      ch[1]=0;
      // Fill the value set with the ASCII table, from character 0 to 255
      // value sets start with row 1 and column 1
      // 16 rows * 16 cols = 256 cells
      for (row=1; row<=16; row++)
         {
         for (col=1; col<=16; col++)
            {
            // Set the contents of the cell
            WinSendMsg(WinWindowFromID(hwnd, SET_ASCII), VM_SETITEM, MPFROM2SHORT(row, col), MPFROMP((VOID *)ch));
            // Raise ch[0] with one, which in effect is the same as copying the next character to ch[0]
            ch[0]++;
            }
         }
      // Get the handle to the .INI file
      pProfile=(HINI*)PVOIDFROMMP(mp2);
      // Get the initial size of the window
      WinQueryWindowPos(hwnd, &initialframe);
      // also in oldframe for sizing
      oldframe.cx=initialframe.cx;
      oldframe.cy=initialframe.cy;
      // Read the size
      newframe.cx=PrfQueryProfileInt(*pProfile, "Size", "x", initialframe.cx);
      newframe.cy=PrfQueryProfileInt(*pProfile, "Size", "y", initialframe.cy);
      // Read the position
      newframe.x=PrfQueryProfileInt(*pProfile, "Position", "x", initialframe.x);
      newframe.y=PrfQueryProfileInt(*pProfile, "Position", "y", initialframe.y);
      WinSetWindowPos(hwnd, NULL, newframe.x, newframe.y, newframe.cx, newframe.cy,
                         SWP_ACTIVATE | SWP_SHOW | SWP_SIZE | SWP_MOVE);
      // Read the font dialog data
      // Set default pointsize
      PointSize=10;
      // Set all values in the FONTDLG structure fd to zero
      memset(&fd, 0, sizeof(FONTDLG));
      // Fill the structure with the necessary data
      // set default fAttrs values
      fd.fAttrs.usRecordLength=sizeof(FATTRS);
      fd.fAttrs.fsSelection=0;
      fd.fAttrs.lMatch=0;
      fd.fAttrs.idRegistry=0;
      fd.fAttrs.usCodePage=850;
      fd.fAttrs.lMaxBaselineExt=0;
      fd.fAttrs.lAveCharWidth=0;
      fd.fAttrs.fsType=0;
      fd.fAttrs.fsFontUse=0;
      // read fAttrs values
      PrfQueryProfileData(*pProfile, "FontAttr", "PointSize", &PointSize, &Size);
      PrfQueryProfileData(*pProfile, "FontAttr", "fsSelection", &fd.fAttrs.fsSelection, &Size);
      PrfQueryProfileData(*pProfile, "FontAttr", "lMatch", &fd.fAttrs.lMatch, &Size);
      PrfQueryProfileString(*pProfile, "FontAttr", "Facename", "Helv", fd.fAttrs.szFacename, FACESIZE);
      PrfQueryProfileData(*pProfile, "FontAttr", "isRegistry", &fd.fAttrs.idRegistry, &Size);
      PrfQueryProfileData(*pProfile, "FontAttr", "usCodePage", &fd.fAttrs.usCodePage, &Size);
      PrfQueryProfileData(*pProfile, "FontAttr", "lMaxBaselineExt", &fd.fAttrs.lMaxBaselineExt, &Size);
      PrfQueryProfileData(*pProfile, "FontAttr", "fAveCharWidth", &fd.fAttrs.lAveCharWidth, &Size);
      PrfQueryProfileData(*pProfile, "FontAttr", "fsType", &fd.fAttrs.fsType, &Size);
      PrfQueryProfileData(*pProfile, "FontAttr", "fsFontUse", &fd.fAttrs.fsFontUse, &Size);
      // size of the structure
      fd.cbSize=sizeof(FONTDLG);
      // Current font
      CurrentFont[0]=0;
      fd.pszFamilyname=CurrentFont;
      // Preferred point size
      fd.fxPointSize=MAKEFIXED(PointSize,0);
      // Size of buffer for fontfamily name
      fd.usFamilyBufLen=FACESIZE;
      // Default foreground colour
      fd.clrFore=SYSCLR_WINDOWTEXT;
      // Default background colour
      fd.clrBack=SYSCLR_WINDOW;
      // Dialog flags
      // Center dialog, and use font attributes
      fd.fl=FNTS_CENTER | FNTS_INITFROMFATTRS;
      // Set the font through the presentation parameters
      sprintf(CurrentFont, "%i.%s", PointSize, fd.fAttrs.szFacename);
      // in the value set
      WinSetPresParam(WinWindowFromID(hwnd, SET_ASCII), PP_FONTNAMESIZE, sizeof(CurrentFont), CurrentFont);
      // in the mle (multi line entryfield)
      WinSetPresParam(WinWindowFromID(hwnd, MLE_TEXT), PP_FONTNAMESIZE, sizeof(CurrentFont), CurrentFont);
      // set the text of this static text control to the name and pointsize of the font
      WinSetWindowText(WinWindowFromID(hwnd, ST_FONT), CurrentFont);
      break;
   case WM_COMMAND:
      // Commands raising from the controls
      // mp1 contains the resource ID of the control
      ControlID=SHORT1FROMMP(mp1);
      switch (ControlID)
         {
         case PB_CLEAR:
            // Clear pushbutton
            // Get the number of bytes in MLE
            Len=LONGFROMMR(WinSendMsg(WinWindowFromID(hwnd, MLE_TEXT), MLM_QUERYTEXTLENGTH, 0L, 0L));
            // Delete the contents of the MLE
            WinSendMsg(WinWindowFromID(hwnd, MLE_TEXT), MLM_DELETE, 0L, MPFROMLONG(Len));
            break;
         case PB_COPY:
            // copy pushbutton
            // Get the number of bytes in MLE
            Len=LONGFROMMR(WinSendMsg(WinWindowFromID(hwnd, MLE_TEXT), MLM_QUERYTEXTLENGTH, 0L, 0L));
            // select all of the MLE contents
            WinSendMsg(WinWindowFromID(hwnd, MLE_TEXT), MLM_SETSEL, 0L, MPFROMLONG(Len));
            // copy selected text to the clipboard
            WinSendMsg(WinWindowFromID(hwnd, MLE_TEXT), MLM_COPY, 0L, 0L);
            break;
         case PB_FONT:
            // Font pushbutton
            // Open a presentation space (required for the font dialog
            hps=WinGetPS(hwnd);
            // presentation space
            fd.hpsScreen=hps;
            // Open the fonddialog
            hwndFD=WinFontDlg(HWND_DESKTOP, hwnd, &fd);
            if ((hwndFD) && (fd.lReturn==DID_OK))
               {
               // User selected a font and pressed Ok
               // Create a complete fontname
               PointSize=fd.fxPointSize/65536;
               sprintf(CurrentFont, "%i.%s", PointSize, fd.fAttrs.szFacename);
               // and set the presentation parameters
               // for the value set
               WinSetPresParam(WinWindowFromID(hwnd, SET_ASCII), PP_FONTNAMESIZE, sizeof(CurrentFont), CurrentFont);
               // for the MLE
               WinSetPresParam(WinWindowFromID(hwnd, MLE_TEXT), PP_FONTNAMESIZE, sizeof(CurrentFont), CurrentFont);
               // Update the text of the static text control
               WinSetWindowText(WinWindowFromID(hwnd, ST_FONT), CurrentFont);
               }
            // release presentation space
            WinReleasePS(hps);
            break;
         case PB_ABOUT:
            // about pushbutton
            // Load and display the about dialog, we don't load it modally, because I hate that
            WinLoadDlg(HWND_DESKTOP, HWND_DESKTOP, AboutProc, (HMODULE)0, DLG_ABOUT, NULL);
            break;
         }
      break;
   case WM_CONTROL:
      // Messages from controls
      // Control resource ID
      ControlID=SHORT1FROMMP(mp1);
      // Notify code
      NotifyCode=SHORT2FROMMP(mp1);
      switch (ControlID)
         {
         case SET_ASCII:
            // Value set
            if ((NotifyCode==VN_SELECT) || (NotifyCode==VN_ENTER))
               {
               // A Cell was selected, or enter was pressed in the selected cell
               // structure to get the text from the valueset
               // buffer size of zero, to let them know we want to query the needed size
               vsText.ulBufLen=0;
               // Send message to query buffer size
               WinSendMsg(WinWindowFromID(hwnd, SET_ASCII), VM_QUERYITEM, mp2, &vsText);
               // Increase buffer size by one to accomodate the trailing zero (I don't know whether it is
               // needed, some messages include it, others not)
               vsText.ulBufLen++;
               // Allocate the memory
               DosAllocMem((void**)&vsText.pszItemText, vsText.ulBufLen, PAG_COMMIT | PAG_READ | PAG_WRITE);
               // Query the text
               WinSendMsg(WinWindowFromID(hwnd, SET_ASCII), VM_QUERYITEM, mp2, &vsText);
               // Insert the text in the MLE
               WinSendMsg(WinWindowFromID(hwnd, MLE_TEXT), MLM_INSERT, MPFROMP(vsText.pszItemText), 0L);
               // Release the allocated memory
               DosFreeMem(vsText.pszItemText);
               }
            break;
         }
      break;
   case WM_PAINT:
      // Window need to be repainted
      // Call Default Dialog Window Procedure to repaint the window
      WinDefDlgProc(hwnd, msg, mp1, mp2);
      // Do a resize of the controls (should check first whether it is needed)
      WinPostMsg(hwnd, UM_RESIZE, 0L, 0L);
      break;
   case UM_RESIZE:
      // Requested to resize the controls
      // Query new size of the window
      WinQueryWindowPos(hwnd, &newframe);
      // Check whether the new size isn't to small
      if ((newframe.cx<initialframe.cx) || (newframe.cy<initialframe.cy))
         {
         // window is to small, restore it to the initial size
         // Copy the initial sizes to the newframe structure
         // So we use the initial size, but the new position
         newframe.cx=initialframe.cx;
         newframe.cy=initialframe.cy;
         // Make it so
         WinSetWindowPos(hwnd, NULL, newframe.x, newframe.y, newframe.cx, newframe.cy,
                         SWP_ACTIVATE | SWP_SHOW | SWP_SIZE | SWP_MOVE);
         // And break out, we've finished the resize (and don't want to do more unneeded work)
         break;
         }
      // These controls we don't want to size, they have their proper size already, just have to move them
      // to their new positions
      // Move the static text with the font name
      Move(hwnd, oldframe, newframe, ST_FONT);
      // Move the copy button
      Move(hwnd, oldframe, newframe, PB_COPY);
      // Move the clear button
      Move(hwnd, oldframe, newframe, PB_CLEAR);
      // move the font button
      Move(hwnd, oldframe, newframe, PB_FONT);
      // move the about button
      Move(hwnd, oldframe, newframe, PB_ABOUT);
      // These controls have to be resized and moved
      // The MLE
      Resize(hwnd, oldframe, newframe, MLE_TEXT);
      // The value set
      Resize(hwnd, oldframe, newframe, SET_ASCII);
      // Query the size of the window again, to store in oldframe
      // (could have copied it from newframe too)
      WinQueryWindowPos(hwnd, &oldframe);
      break;
   case WM_CLOSE:
      // User has selected to close the program
      // (Could ask for confirmation here)
      // Save the size & position
      WinQueryWindowPos(hwnd, &newframe);
      sprintf(temp, "%li", newframe.cx);
      PrfWriteProfileString(*pProfile, "Size", "x", temp);
      sprintf(temp, "%li", newframe.cy);
      PrfWriteProfileString(*pProfile, "Size", "y", temp);
      sprintf(temp, "%li", newframe.x);
      PrfWriteProfileString(*pProfile, "Position", "x", temp);
      sprintf(temp, "%li", newframe.y);
      PrfWriteProfileString(*pProfile, "Position", "y", temp);
      // Save the font dialog values
      PrfWriteProfileData(*pProfile, "FontAttr", "PointSize", &PointSize, sizeof(INT));
      PrfWriteProfileData(*pProfile, "FontAttr", "fsSelection", &fd.fAttrs.fsSelection, sizeof(USHORT));
      PrfWriteProfileData(*pProfile, "FontAttr", "lMatch", &fd.fAttrs.lMatch, sizeof(LONG));
      PrfWriteProfileString(*pProfile, "FontAttr", "Facename", fd.fAttrs.szFacename);
      PrfWriteProfileData(*pProfile, "FontAttr", "isRegistry", &fd.fAttrs.idRegistry, sizeof(USHORT));
      PrfWriteProfileData(*pProfile, "FontAttr", "usCodePage", &fd.fAttrs.usCodePage, sizeof(USHORT));
      PrfWriteProfileData(*pProfile, "FontAttr", "lMaxBaselineExt", &fd.fAttrs.lMaxBaselineExt, sizeof(LONG));
      PrfWriteProfileData(*pProfile, "FontAttr", "fAveCharWidth", &fd.fAttrs.lAveCharWidth, sizeof(LONG));
      PrfWriteProfileData(*pProfile, "FontAttr", "fsType", &fd.fAttrs.fsType, sizeof(USHORT));
      PrfWriteProfileData(*pProfile, "FontAttr", "fsFontUse", &fd.fAttrs.fsFontUse, sizeof(USHORT));
      // Dismiss the window
      WinDismissDlg(hwnd, TRUE);
      // Let the program know we are ready to quit
      WinPostMsg(hwnd, WM_QUIT, 0L, 0L);
      break;
   default:
      // We didn't handle the message, let the default window procedure handle it
      return WinDefDlgProc(hwnd, msg, mp1, mp2);
   }
// We have handled all messages
return (MRESULT)FALSE;
}

// Window procedure for the about dialogbox
// Is called by the system
MRESULT EXPENTRY AboutProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
// Declaration of variables
USHORT ControlID;
switch (msg)
   {
   case WM_INITDLG:
      // Initialization
      // Nothing
      break;
   case WM_COMMAND:
      // Commands from controls
      // Resource ID of control
      ControlID=SHORT1FROMMP(mp1);
      switch (ControlID)
         {
         case PB_OK:
            // Pushbutton pressed
            // Close the About dialogbox
            // Send the WM_CLOSE message
            WinSendMsg(hwnd, WM_CLOSE, 0L, 0L);
            break;
         }
      break;
   case WM_CLOSE:
      // Close the About dialogbox
      // User pressed the Ok button
      // Dismiss the dialogbox
      WinDismissDlg(hwnd, TRUE);
      // Note we now do not send a WM_QUIT message, if we did so, we would close all of the application
      break;
   default:
      // Let the default window procedure handle messages we didn't handle
      return WinDefDlgProc(hwnd, msg, mp1, mp2);
   }
// All messages are handled
return (MRESULT)FALSE;
}

// Function to resize and move controls
// Parameters:
// hwnd Window handler of the main window
// oldframe & newframe SWP structures which contain the old & new sizes of the main window
//   used to calculate the new size and position of the client window
// ID Resource ID of the client window
void Resize(HWND hwnd, SWP oldframe, SWP newframe, ULONG ID)
{
// structure to store the current position and size
SWP swp;
// Flags to resize and move
ULONG flags=SWP_ACTIVATE | SWP_SHOW | SWP_SIZE | SWP_MOVE;
// Query current position and size
WinQueryWindowPos(WinWindowFromID(hwnd, ID), &swp);
// Calculate the new position and size
swp.x=(swp.x*newframe.cx)/oldframe.cx;
swp.y=(swp.y*newframe.cy)/oldframe.cy;
swp.cx=(swp.cx*newframe.cx)/oldframe.cx;
swp.cy=(swp.cy*newframe.cy)/oldframe.cy;
// Move and resize the control
WinSetWindowPos(WinWindowFromID(hwnd, ID), NULL, swp.x, swp.y, swp.cx, swp.cy, flags);
}

// Function to move controls
// Parameters:
// hwnd Window handler of the main window
// oldframe & newframe SWP structures which contain the old & new sizes of the main window
// ID Resource ID of the client window
void Move(HWND hwnd, SWP oldframe, SWP newframe, ULONG ID)
{
// structure to store the current position and size
SWP swp;
// Flags to move
ULONG flags=SWP_ACTIVATE | SWP_SHOW | SWP_MOVE;
// Query current position and size
WinQueryWindowPos(WinWindowFromID(hwnd, ID), &swp);
// Calculate the new position
swp.x=(swp.x*newframe.cx)/oldframe.cx;
swp.y=(swp.y*newframe.cy)/oldframe.cy;
// Move the control
WinSetWindowPos(WinWindowFromID(hwnd, ID), NULL, swp.x, swp.y, swp.cx, swp.cy, flags);
}

// That was all















































// Really?










































// Yes, really.
