# ifndef yyErrors
# define yyErrors

/* $Id: Errors.h,v 2.5 1992/06/23 12:33:51 grosch rel $ */

# include "Scanner.h"

# define yyNoText		0
# define yySyntaxError		1	/* error codes		*/
# define yyExpectedTokens	2
# define yyRestartPoint		3
# define yyTokenInserted	4

# define yyNone			0
# define yyFatal		1	/* error classes	*/
# define yyRestriction		2
# define yyError		3
# define yyWarning		4
# define yyRepair		5
# define yyNote			6
# define yyInformation		7

# define yyInteger		1	/* info classes		*/
# define yyShort		2
# define yyLong			3
# define yyReal			4
# define yyBoolean		5
# define yyCharacter		6
# define yyString		7
# define yySet			8
# define yyToken		9
# define yyTokenSet		10

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

extern void ErrorMessage  ARGS((short yyErrorCode, short yyErrorClass, tPosition yyPosition));
extern void ErrorMessageI ARGS((short yyErrorCode, short yyErrorClass, tPosition yyPosition, short yyInfoClass, char * yyInfo));

# endif
