/*************************************************************************
*                                                                        *
*  Name : global.c                                                       *
*                                                                        *
*  Purpose : declaration of global data for ADAPTOR translation          *
*                                                                        *
*  Author : Dr. Thomas Brandes, GMD, I1.HR                               *
*                                                                        *
*  Last Update : April 1993                                              *
*                                                                        *
**************************************************************************

#include "global.h"

#define NOF(X) (sizeof((X))/sizeof((X)[0]))

/* possible target machines */

char *machine_items [] =
    { "Intel iPSC/860 ",
      "CM-5           ",
      "Parsytec GCel  ",
      "Meiko CS 1     ",
      "Meiko CS 2     ",
      "Suprenum  S1   ",
      "Alliant FX/2800",
      "Silicon Graphic",
      "KSR 1          ",
      "Sun Net (PVM)  ",
      "IBM Net (PVM)  ",
      "Alliant (PVM)  ",
      "OS2     (PVM)  ",
      "KSR 1 (PVM)    " };

int no_machine = 14;

int target_machine;

/* possible target languages */

char *language_items [] = { "Fortran 77", "Fortran 90" };
int  no_language = 2;

int target_language;

/* possible target models */

char *model_items [] = { "Host-Node", "Only Node", "Uni Proc "};
int  no_model    = 3;

int target_model;

/* possible arrays */

char *array_items [] = { "Dynamic    ", "Static     " };
int  no_array    = 2;

int array_kind;

/* possible default distributions */

char *ddefault_items [] = {"replicated ", "distributed", "cm default " };
int  no_ddefault  = 3;
int  ddefault_kind;

/* possible switches for split flag */

char *split_items [] = { "No   ","Yes  " };
int  no_split    = 2;

int split_flag;

/* possible values/entries for minproc */

char *minproc_items [] = { "p=1", "p=2", "p=4", "p=8",
                            "p+1", "p-1", "p*2", "p/2",
                            "typ" };

int no_minproc  = 9;
int MinProc     ;

/* some other global data */

int  StaticArraySize;

char last_message [160];   /* last error/hints message */

char PHOME [160];

/* Flags that are used during the translation */

int IsHost;
int IsPure;
