------------------------------------------------------------------------------
--                                                                          --
--                               PM Bindings                                --
--                                                                          --
--                                Pm_Types                                  --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: .11 $                              --
--                                                                          --
--     Copyright (c) 1994 Dimensional Media Systems, All Rights Reserved    --
--                                                                          --
--   The PM bindings are free software; you can redistribute them and/or    --
--   modify them under terms of the GNU General Public License as published --
--   by the Free Software Foundation; either version 2, or (at your         --
--   option) any later version.  The PM bindings are distributed in the     --
--   hope that they will be useful, but WITH OUT ANY WARRANTY; without even --
--   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR    --
--   PURPOSE.  See the GNU General Public License for more details.  You    --
--   should have received a copy of the GNU General Public License          --
--   distributed with The PM bindings; see file COPYING.  If not, write to  --
--   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  --
--                                                                          --
------------------------------------------------------------------------------
--                                                                          --
--   For more information about these PM bindings and their usage with GNAT --
--   you can contact Bill Yow at                                            --
--                                                                          --  
--      Dimensional Media Systems (DMS)                                     --
--      1522 Festival Dr.                                                   --
--      Houston TX, 77062                                                   --
--      Phone - (713) 488-7050                                              --
--      Email - Byow@mci.com                                                --
--                                                                          --
------------------------------------------------------------------------------

package Pm_Types is

  --Base type for the PM interface packages

  type Byte is range -128 .. 127;
  for Byte'size use 8;

  type U_Byte is range 0 .. 255;
  for U_Byte'size use 8;

  type Short is range -32_768 .. 32_767;
  for Short'size use 16;

  type U_Short is range 0 .. 65_535;
  for U_Short'size use 16;

  type Long is range -2_147_483_648 .. 2_147_483_647;
  for Long'size use 32;

  type U_Long is range 0 .. 4_294_967_295;
  for U_Long'size use 32;

  type V_Long is range -9_223_372_036_854_775_808 
                               .. 9_223_372_036_854_775_807;
  for V_Long'size use 64;

--Compiler 1.76 could not compile this.
--  type U_V_Long is range 0 .. 18_446_744_073_709_551_615;
--  for U_V_Long'size use 64;

--  type U_V_Long is mod 18_446_744_073_709_551_616;
--  for U_V_Long'size use 64;

end Pm_Types;
  
