------------------------------------------------------------------------------
--                                                                          --
--                               PM Bindings                                --
--                                                                          --
--                                PM_Hello                                  --
--                                                                          --
--   Vers .1           A Simple hello world test program.                   --
--                                                                          --
--   Vers .11          Added Character handling                             --
--   Vers .12          Added some attribute controls                        --
--   Vers .13          Added Line, Box and Arc routines.                    --
--                                                                          --
--                                                                          --
--                            $Revision: .13 $                              --
--                                                                          --
--     Copyright (c) 1994 Dimensional Media Systems, All Rights Reserved    --
--                                                                          --
--   The PM bindings are free software; you can redistribute them and/or    --
--   modify them under terms of the GNU General Public License as published --
--   by the Free Software Foundation; either version 2, or (at your         --
--   option) any later version.  The PM bindings are distributed in the     --
--   hope that they will be useful, but WITH OUT ANY WARRANTY; without even --
--   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR    --
--   PURPOSE.  See the GNU General Public License for more details.  You    --
--   should have received a copy of the GNU General Public License          --
--   distributed with The PM bindings; see file COPYING.  If not, write to  --
--   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  --
--                                                                          --
------------------------------------------------------------------------------
--                                                                          --
--   For more information about these PM bindings and their usage with GNAT --
--   you can contact Bill Yow at                                            --
--                                                                          --  
--      Dimensional Media Systems (DMS)                                     --
--      1522 Festival Dr.                                                   --
--      Houston TX, 77062                                                   --
--      Phone - (713) 488-7050                                              --
--      Email - Byow@mci.com                                                --
--                                                                          --
------------------------------------------------------------------------------

with Win;
with GPI;
with Text_Io;
with Pm_Types;

procedure Pm_Hello is

  Hab            : Win.Anchor_Block_Handle_Type := Win.Null_Anchor_Block;
  Queue          : Win.Queue_Handle_Type; 

  Queue_Message  : Win.Queue_Message_Pointer_Type;

  Button_Pressed : Win.MB_Response_Type;

  Frame_Cf       : Win.Frame_Control_Flags_Type;
  New_Win        : Win.Handle_Pointer_Type;
  Frame_Win      : Win.Handle_Type; 

  Successful     : Boolean;
  Window_Style   : Win.Class_Styles_Type := (others => False);

  Key_Info       : Win.Key_Press_Info_Type;

  Point          : Win.Point_Type := (10, 350);


  Error_File     : Text_Io.File_Type;

  ------------------------------------------------------------------

  procedure Error_Write (Str : String) is
    begin
      Text_Io.Put_Line (Error_File, Str);
    end Error_Write;

  ------------------------------------------------------------------

  function Win_Test_Handler (Window  : Win.Handle_Type;
                             Message : Win.Message_Type;
                             MP1     : Win.Parameter_Type;
                             MP2     : Win.Parameter_Type) return 
                                                    Pm_Types.U_Long is
    Result      : Boolean;
    Ps          : Win.Ps_Type; 

    Str         : String (1 .. 1);

    Gpi_Results : Gpi.Status_Type;

    use Win;
   begin

     case Message is

      when Win.Wm_Button_1_Down => 
           
           Ps := Win.Get_Ps (Window);
           GPI.Set_Background_Mix (Ps, GPI.Bm_Overpaint);
           GPI.Set_Background_Color (Ps, GPI.Clr_Pale_Gray);
           GPI.Set_Color (Ps, GPI.Clr_Blue);
           GPI.Char_String_At (
                              Ps    => Ps,
                              Point => Win.Pointer_Is (MP1),
                              Text  => "Hello from GNAT");
           Win.Release_Ps (Ps);

           return 1;

      when Win.Wm_Button_2_Down => 

           Ps := Win.Get_Ps (Window);

           GPI.Set_Background_Mix (Ps, GPI.Bm_Overpaint);
           GPI.Set_Background_Color (Ps, GPI.Clr_Background);
           GPI.Set_Color (Ps, GPI.Clr_Blue);
           GPI.Char_String_At (
                              Ps    => Ps,
                              Point => (60, 380),
                              Text  => "Lines");
          
           GPI.Set_Color (Ps, GPI.Clr_Pink);

           for I in 1 .. 35 loop
              GPI.Line (Ps          => Ps,
                        Start_Point => (50, 50),
                        End_Point   => (X => 150 - (Win.Pixel_Type (I) * 3), 
                                        Y => 120 + (Win.Pixel_Type (I) * 8)));
           end loop;


           GPI.Set_Background_Color (Ps, GPI.Clr_Background);
           GPI.Set_Color (Ps, GPI.Clr_Blue);
           GPI.Char_String_At (
                              Ps    => Ps,
                              Point => (225, 380),
                              Text  => "Boxes");
          
           GPI.Set_Color (Ps, GPI.Clr_Red);
           Gpi.Box (Ps            => Ps,
                    Start_Corner    => (200, 50),
                    End_Corner      => (300, 125),
                    Outline_Style   => Gpi.Dro_Fill,
                    Horz_Rounding   => 0,
                    Vert_Rounding   => 0);

           GPI.Set_Color (Ps, GPI.Clr_Blue);
           Gpi.Box (Ps            => Ps,
                    Start_Corner  => (200, 175),
                    End_Corner    => (300, 250),
                    Outline_Style => Gpi.Dro_Outline,
                    Horz_Rounding => 10,
                    Vert_Rounding => 10);
                    
           GPI.Set_Color (Ps, GPI.Clr_Dark_Green);
           Gpi.Box (Ps            => Ps,
                    Start_Corner  => (200, 275),
                    End_Corner    => (300, 350),
                    Outline_Style => Gpi.Dro_Outline_Fill,
                    Horz_Rounding => 30,
                    Vert_Rounding => 30);


           GPI.Set_Background_Color (Ps, GPI.Clr_Background);
           GPI.Set_Color (Ps, GPI.Clr_Blue);
           GPI.Char_String_At (
                              Ps    => Ps,
                              Point => (400, 380),
                              Text  => "Arcs");
          
            --A Circle
            GPI.Set_Color (Ps, GPI.Clr_White);
            Gpi.Full_Arc (
                 Ps            => Ps,
                 Center        => (420, 75),
                 Arc_Params    => (1, 1, 0, 0), 
                 Outline_Style => Gpi.Dro_Outline,
                 Multiplier    => 50);

            --A Width Ellipse
            GPI.Set_Color (Ps, GPI.Clr_Brown);
            Gpi.Full_Arc (
                 Ps            => Ps,
                 Center        => (420, 200),
                 Arc_Params    => (1, 2, 0, 0), 
                 Outline_Style => Gpi.Dro_Fill,
                 Multiplier    => 25);

            --A Tall Ellipse
            GPI.Set_Color (Ps, GPI.Clr_Yellow);
            Gpi.Full_Arc (
                 Ps            => Ps,
                 Center        => (420, 325),
                 Arc_Params    => (2, 1, 0, 0), 
                 Outline_Style => Gpi.Dro_Outline_Fill,
                 Multiplier    => 25);

            Win.Release_Ps (Ps);

            return 1;

      when Win.Wm_Char => 
           Key_Info := Win.Key_Info_Is (Mp1, Mp2);

           if (Key_Info.Flags (Win.Kc_Char) and then
               not Key_Info.Flags (Win.Kc_Virtual_Key)) or else
                (Key_Info.Flags (Win.Kc_Virtual_Key) and then
                   Key_Info.Virtual_Key = Win.Vk_Space and then
                    not Key_Info.Flags (Win.Kc_Key_Up)) then

             Str (1) := Character'Val (Integer (Key_Info.Character_Code));

             Ps := Win.Get_Ps (Window);

             GPI.Set_Background_Mix (Ps, GPI.Bm_Overpaint);
             GPI.Set_Background_Color (Ps, GPI.Clr_Background);
             GPI.Char_String_At (
                              Ps    => Ps,
                              Point => Point,
                              Text  => Str);
             Win.Release_Ps (Ps);

             Point.X := Point.X + 11;

             if Point.X > 200 then
                Point.X := 10;
                Point.Y := Point.Y - 18;
             end if;

           elsif key_Info.Flags (Win.Kc_Virtual_Key) and then
                 not Key_Info.Flags (Win.Kc_Key_Up) then

             Ps := Win.Get_Ps (Window);

             GPI.Set_Background_Mix (Ps, GPI.Bm_Overpaint);
             GPI.Set_Background_Color (Ps, GPI.Clr_Background);
             GPI.Char_String_At (
                  Ps    => Ps,
                  Point => (250, Point.Y),
                  Text  => "                                          ");
             GPI.Char_String_At (
                   Ps    => Ps,
                   Point => (250, Point.Y),
                   Text  => Win.Virtual_Key_Type'Image (Key_Info.Virtual_Key));
             Win.Release_Ps (Ps);
             
             Point.Y := Point.Y - 18;

             if Point.Y < 10 then
               Point.Y := 350;
             end if;

           end if;

           return 1;

      when Win.Wm_Erase_Background => 
           return 1;

      when Win.Wm_Close =>
        Result := Win.Post_Message (Window, Win.Wm_Quit, 0, 0);

      when others => 
        return Win.Default_Window_Procedure (Window, Message, Mp1, Mp2);
     end case;

     return 0;

   end Win_Test_Handler; 

  ------------------------------------------------------------------

   procedure Show_Error (Message : String) is
     begin
       Button_Pressed := Win.Message_Box (
                        Parent_Window  => Win.Desktop_Window,
                        Request_Owner  => Win.Null_Window,
                        Message        => Message,
                        Title          => " Error ",
                        Help_Id        => 1,
                        Buttons        => Win.MB_Ok,
                        Icons          => Win.Mb_Icon_Hand, 
                        Default_Action => Win.Mb_Default_On_Button_1);
     end Show_Error;

  ------------------------------------------------------------------

   use Pm_Types;

  begin

    Text_Io.Create (Error_File, Text_Io.Out_File, "Errors.txt");
    Error_Write ("H1");

    New_Win       := new Win.Handle_Type;

    Error_Write ("H2");

    Queue_Message := new Win.Queue_Message_Type;

    Error_Write ("H3");

--    Win.Initialize (Win.System_Default, Hab);

    Error_Write ("H4");

    Win.Create_Message_Queue (Hab, Win.System_Default, Queue);    

    Error_Write ("H5");

    Window_Style (Win.Cs_Size_Redraw) := True;

    Error_Write ("H6");

    Win.Register_Class (
                        Anchor_Block    => Hab,
                        Class_Name      => "My_Window_Class",
                        Message_Handler => Win_Test_Handler'access,
                        Class_Style     => Window_Style,
                        Extra_Storage   => 0); 

    Error_Write ("H7");

    Frame_CF := 
       (Win.Fcf_Title_Bar     => True,
        Win.Fcf_System_Menu   => True,
        Win.Fcf_Min_Max       => True,
        Win.Fcf_Sizing_Border => True,
        Win.Fcf_Task_List     => True,
        others                => False);

    Error_Write ("H8");

    Frame_Win := Win.Create_Standard_Window (
             Parent_Window       => Win.Desktop_Window,
             Window_Styles       => Win.Use_Class_Styles,
             Frame_Control_Flags => Frame_CF,
             Class_Name          => "My_Window_Class",
             Window_Title        => "An OS/2 Window created by GNAT!",
             Class_Style         => Window_Style,
             Resource            => null, 
             Resource_ID         => 1,
             New_Window          => New_Win);

    Error_Write ("H9");

    if Win.Is_Null (Frame_Win) then
       Show_Error ("The window was not created");
    else

       Win.Set_Window_Position (
               Window           => Frame_Win,
               Behind_Window    => Win.Top_Window,
               X                => 20,
               Y                => 20,
               Width            => 600,
               Height           => 430,
               Position_Options => Win.Show_Window);

    Error_Write ("H10");

    Text_Io.Close (Error_File);

       loop

          exit when not Win.Get_Message (Hab, Queue_Message, 
                                          Win.Null_Window, 0, 0);
          Win.Dispatch_Message (Hab, Queue_Message);

       end loop;

    end if;

    Win.Destroy_Message_Queue (Queue);
    Win.Terminate_App (Hab);


  end Pm_Hello;





