------------------------------------------------------------------------------
--                                                                          --
--                               PM Bindings                                --
--                                                                          --
--                                  GPI                                     --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: .14 $                              --
--
--  .11 
--       First version of GPI 
--       Char_String_At
--
--  .12  
--       Background_Mix_Type
--       Set_Background_Mix
--       Color_Type
--       Set_Background_Color
--       Set_Color
--
--  .13
--     Converted Text_Status_Type to Status_Type
--     GPI_Error exception       
--     Set_Current_Position
--     Line    
--     Box
--     Set_Arc_Parameters
--     Full_Arc
--
--  .14
--    Char_String
--    Move
--    Set_Default_Arc_Parameters
--    Query_Default_Arc_Parameters
--    Query_Arc_Parameters
--    Query_Current_Position
--    Query_Line_End
--    Set_Line_End
--    Query_Line_Join
--    Set_Line_Join
--    Erase
--    Destroy_Ps
--
--                                                                          --
--     Copyright (c) 1994 Dimensional Media Systems, All Rights Reserved    --
--                                                                          --
--   The PM bindings are free software; you can redistribute them and/or    --
--   modify them under terms of the GNU General Public License as published --
--   by the Free Software Foundation; either version 2, or (at your         --
--   option) any later version.  The PM bindings are distributed in the     --
--   hope that they will be useful, but WITH OUT ANY WARRANTY; without even --
--   the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR    --
--   PURPOSE.  See the GNU General Public License for more details.  You    --
--   should have received a copy of the GNU General Public License          --
--   distributed with The PM bindings; see file COPYING.  If not, write to  --
--   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  --
--                                                                          --
------------------------------------------------------------------------------
--                                                                          --
--   For more information about these PM bindings and their usage with GNAT --
--   you can contact Bill Yow at                                            --
--                                                                          --  
--      Dimensional Media Systems (DMS)                                     --
--      1522 Festival Dr.                                                   --
--      Houston TX, 77062                                                   --
--      Phone - (713) 488-7050                                              --
--      Email - byow@mci.com                                                --
--                                                                          --
------------------------------------------------------------------------------

with Pm_Types;
with Win;

package GPI is

   GPI_Error  : exception;

   type Status_Type is (Okay, Hits, Error);

   type Background_Mix_Type is (
       Bm_Error,
       Bm_Default,
       Bm_Or,
       Bm_Overpaint,
       Bm_Leave_Alone,
       Bm_Xor,
       Bm_And,
       Bm_Subtract,
       Bm_Mask_Src_Not,
       Bm_Zero,
       Bm_Not_Merge_Src,
       Bm_Not_Xor_Src,
       Bm_Invert,
       Bm_Merge_Src_Not,
       Bm_Not_Copy_Src,
       Bm_Merge_Not_Src,
       Bm_Not_Mask_Src,
       Bm_One,
       Bm_Src_Transparent,
       Bm_Dest_Transparent);

   function Set_Background_Mix (
              Ps  : Win.Ps_Type;
              Mix : Background_Mix_Type) return Boolean;
             
   procedure Set_Background_Mix (
              Ps  : Win.Ps_Type;
              Mix : Background_Mix_Type);

   type Color_Type is private;

   Clr_False        : constant Color_Type;
   Clr_True         : constant Color_Type;
   Clr_Error        : constant Color_Type;
   Clr_Default      : constant Color_Type;

   Clr_White        : constant Color_Type;
   Clr_Black        : constant Color_Type;
   Clr_Background   : constant Color_Type;
   Clr_Blue         : constant Color_Type;
   Clr_Red          : constant Color_Type;
   Clr_Pink         : constant Color_Type;
   Clr_Green        : constant Color_Type;
   Clr_Cyan         : constant Color_Type;
   Clr_Yellow       : constant Color_Type;
   Clr_Neutral      : constant Color_Type;

   Clr_Dark_Gray    : constant Color_Type;
   Clr_Dark_Blue    : constant Color_Type;
   Clr_Dark_Red     : constant Color_Type;
   Clr_Dark_Pink    : constant Color_Type;
   Clr_Dark_Green   : constant Color_Type;
   Clr_Dark_Cyan    : constant Color_Type;
   Clr_Brown        : constant Color_Type;
   Clr_Pale_Gray    : constant Color_Type;

   RGB_Error        : constant Color_Type;
   RGB_Black        : constant Color_Type;
   RGB_Blue         : constant Color_Type;
   RGB_Green        : constant Color_Type;
   RGB_Cyan         : constant Color_Type;
   RGB_Red          : constant Color_Type;
   RGB_Pink         : constant Color_Type;
   RGB_Yellow       : constant Color_Type;
   RGB_White        : constant Color_Type;

  ---------------------------------------------

   function Set_Background_Color (
                  Ps    : Win.Ps_Type;
                  Color : Color_Type) return Boolean;
       
   procedure Set_Background_Color (
                  Ps    : Win.Ps_Type;
                  Color : Color_Type);

  ---------------------------------------------

   function Set_Color (
                  Ps    : Win.Ps_Type;
                  Color : Color_Type) return Boolean;
       
   procedure Set_Color (
                  Ps    : Win.Ps_Type;
                  Color : Color_Type);

  ---------------------------------------------

   function Char_String_At (
                  Ps    : Win.Ps_Type;
                  Point : Win.Point_Type;
                  Text  : String) return Status_Type;

   procedure Char_String_At (
                  Ps    : in Win.Ps_Type;
                  Point : in Win.Point_Type;
                  Text  : in String);

  ---------------------------------------------

   function Char_String (
                  Ps    : Win.Ps_Type;
                  Text  : String) return Status_Type;

   procedure Char_String (
                  Ps    : in Win.Ps_Type;
                  Text  : in String);

  ---------------------------------------------

   function Set_Current_Position (
              Ps    : Win.Ps_Type;
              Point : Win.Point_Type) return Boolean;

   procedure Set_Current_Position (
              Ps    : Win.Ps_Type;
              Point : Win.Point_Type);

  ---------------------------------------------

   function Query_Current_Position (
              Ps    : Win.Ps_Type;
              Point : Win.Point_Pointer_Type) return Boolean;

   procedure Query_Current_Position (
              Ps    : in     Win.Ps_Type;
              Point :    out Win.Point_Type);

  ---------------------------------------------

   function Erase (Ps : Win.Ps_Type) return Boolean;

   procedure Erase (Ps : Win.Ps_Type);

  ---------------------------------------------

   function Destroy_Ps (Ps : Win.Ps_Type) return Boolean;

   procedure Destroy_Ps (Ps : in Win.Ps_Type);

  ---------------------------------------------

   function Move (
              Ps    : Win.Ps_Type;
              Point : Win.Point_Type) return Boolean;

   procedure Move (
              Ps    : Win.Ps_Type;
              Point : Win.Point_Type);

  ---------------------------------------------

   type Line_End_Style_Type is (
         Line_End_Error,
         Line_End_Default,
         Line_End_Flat,
         Line_End_Square,
         Line_End_Round);

   type Line_Join_Style_Type is (
         Line_Join_Error,
         Line_Join_Default,
         Line_Join_Bevel,
         Line_Join_Round,
         Line_Join_Mitre);

  ---------------------------------------------

   function Set_Line_End (
              Ps        : Win.Ps_Type;
              Style     : Line_End_Style_Type) return Boolean;

   procedure Set_Line_End (
              Ps        : in Win.Ps_Type;
              Style     : in Line_End_Style_Type);

  ---------------------------------------------

   function Query_Line_End (Ps : Win.Ps_Type) return Line_End_Style_Type;

  ---------------------------------------------

   function Set_Line_Join (
              Ps        : Win.Ps_Type;
              Style     : Line_Join_Style_Type) return Boolean;

   procedure Set_Line_Join (
              Ps        : in Win.Ps_Type;
              Style     : in Line_Join_Style_Type);

  ---------------------------------------------

   function Query_Line_Join (Ps : Win.Ps_Type) return Line_Join_Style_Type;

  ---------------------------------------------

   function Line (
              Ps        : Win.Ps_Type;
              End_Point : Win.Point_Type) return Status_Type;

   procedure Line (
              Ps        : Win.Ps_Type;
              End_Point : Win.Point_Type);

   procedure Line (
              Ps          : Win.Ps_Type;
              Start_Point : Win.Point_Type;
              End_Point   : Win.Point_Type);

  ---------------------------------------------

   type Outline_Style_Type is (
      Dro_Fill,          --Fill the interior of the box without drawing 
                         --the outline.
      Dro_Outline,       --Draw the outline of the box.
      Dro_Outline_Fill); --Draw the outline of the box and fill the interior.
 
   function Box (
              Ps            : Win.Ps_Type;
              Corner_Point  : Win.Point_Type;
              Outline_Style : Outline_Style_Type;
              Horz_Rounding : Pm_Types.Long;
              Vert_Rounding : Pm_Types.Long) return Status_Type; 

   procedure Box (
              Ps            : in Win.Ps_Type;
              Corner_Point  : in Win.Point_Type;
              Outline_Style : in Outline_Style_Type;
              Horz_Rounding : in Pm_Types.Long;
              Vert_Rounding : in Pm_Types.Long);

   procedure Box (
              Ps            : in Win.Ps_Type;
              Start_Corner  : in Win.Point_Type;
              End_Corner    : in Win.Point_Type;
              Outline_Style : in Outline_Style_Type;
              Horz_Rounding : in Pm_Types.Long;
              Vert_Rounding : in Pm_Types.Long);

 ---------------------------------------------
   type Arc_Parameter_Type is
     record
       lP : Pm_Types.Long;
       lQ : Pm_Types.Long;
       lR : Pm_Types.Long;
       lS : Pm_Types.Long;
     end record;

   type Arc_Parameter_Pointer_Type is access Arc_Parameter_Type;

   function Set_Arc_Parameters (
              Ps         : Win.Ps_Type;
              Parameters : Arc_Parameter_Type) return Boolean;

   procedure Set_Arc_Parameters (
              Ps         : in Win.Ps_Type;
              Parameters : in Arc_Parameter_Type);

 ---------------------------------------------

   function Query_Arc_Parameters (
              Ps         : Win.Ps_Type;
              Parameters : Arc_Parameter_Pointer_Type) return Boolean;

   procedure Query_Arc_Parameters (
              Ps         : in     Win.Ps_Type;
              Parameters :    out Arc_Parameter_Type);

 ---------------------------------------------

   function Set_Default_Arc_Parameters (
              Ps         : Win.Ps_Type;
              Parameters : Arc_Parameter_Type) return Boolean;

   procedure Set_Default_Arc_Parameters (
              Ps         : in Win.Ps_Type;
              Parameters : in Arc_Parameter_Type);

 ---------------------------------------------

   function Query_Default_Arc_Parameters (
              Ps         : Win.Ps_Type;
              Parameters : Arc_Parameter_Pointer_Type) return Boolean;

   procedure Query_Default_Arc_Parameters (
              Ps         : in     Win.Ps_Type;
              Parameters :    out Arc_Parameter_Type);

 ---------------------------------------------

--   type Multipler_Type is delta 0.001 range 0.0 .. 255.0;
     type Multipler_Type is range 0 .. 255;  --Will be converted to fixed 
                                             --type when implement.

   function Full_Arc (
              Ps            : Win.Ps_Type;
              Outline_Style : Outline_Style_Type;
              Multiplier    : Multipler_Type) return Status_Type;

   procedure Full_Arc (
              Ps            : in Win.Ps_Type;
              Outline_Style : in Outline_Style_Type;
              Multiplier    : in Multipler_Type);

   procedure Full_Arc (
              Ps            : in Win.Ps_Type;
              Center        : in Win.Point_Type;
              Arc_Params    : in Arc_Parameter_Type;
              Outline_Style : in Outline_Style_Type;
              Multiplier    : in Multipler_Type);

 ---------------------------------------------

 private 

   type Color_Type is new Pm_Types.Long;

   Clr_False        : constant Color_Type := -5;
   Clr_True         : constant Color_Type := -4;
   Clr_Error        : constant Color_Type := -255;
   Clr_Default      : constant Color_Type := -3;

   Clr_White        : constant Color_Type := -2;
   Clr_Black        : constant Color_Type := -1;
   Clr_Background   : constant Color_Type := 0;
   Clr_Blue         : constant Color_Type := 1;
   Clr_Red          : constant Color_Type := 2;
   Clr_Pink         : constant Color_Type := 3;
   Clr_Green        : constant Color_Type := 4;
   Clr_Cyan         : constant Color_Type := 5;
   Clr_Yellow       : constant Color_Type := 6;
   Clr_Neutral      : constant Color_Type := 7;

   Clr_Dark_Gray    : constant Color_Type := 8;
   Clr_Dark_Blue    : constant Color_Type := 9;
   Clr_Dark_Red     : constant Color_Type := 10;
   Clr_Dark_Pink    : constant Color_Type := 11;
   Clr_Dark_Green   : constant Color_Type := 12;
   Clr_Dark_Cyan    : constant Color_Type := 13;
   Clr_Brown        : constant Color_Type := 14;
   Clr_Pale_Gray    : constant Color_Type := 15;

   RGB_Error        : constant Color_Type := -255;
   RGB_Black        : constant Color_Type := 16#0000_0000#;
   RGB_Blue         : constant Color_Type := 16#0000_00FF#;
   RGB_Green        : constant Color_Type := 16#0000_FF00#;
   RGB_Cyan         : constant Color_Type := 16#0000_FFFF#;
   RGB_Red          : constant Color_Type := 16#00FF_0000#;
   RGB_Pink         : constant Color_Type := 16#00FF_00FF#;
   RGB_Yellow       : constant Color_Type := 16#00FF_FF00#;
   RGB_White        : constant Color_Type := 16#00FF_FFFF#;

end GPI;
