/*************************************************************************

 IBM(R) VisualAge(TM) C++ for OS/2(R), Version 3
  - Collection Class Library -

 (C) Copyright IBM Corp. 1991, 1995.
  - Licensed Material - Program-Property of IBM - All Rights Reserved.

 *************************************************************************/

#include <iglobals.h>
#include <iostream.h>
#include <sperson6.h>

#include <iset.h>
#include <irset.h>
typedef ISet <Person>  PeopleSet;
typedef IRSet <Person, PeopleSet>  PolyPeopleSet;

#include <ieqseq.h>
#include <irseq.h>
typedef IEqualitySequence <Person>  People;
typedef IRSequence <Person, People> PolyPeopleSeq;

#include <itbseq.h>
typedef ITabularSequence <Person>  PeopleTab;
typedef IRSequence <Person, PeopleTab> PolyPeopleTab;


class MyPrint: public IConstantIterator <Person> {
    applyTo(Person const & person){
      cout << "Name " << person.getName() << "\n" ;
      return  True;
  }
};

void printCollection( IACollection <Person> const & collection){
   MyPrint myPrint;
   collection.allElementsDo(myPrint);
}

int main () {
        People people;

        people.add("J. Uhl");
        people.add("K. Liegert");
        people.add("M. Blum");
        people.add("T. Wappler");
        people.add("F. Seliger");
        people.add("S. Hartig");
        people.add("B. Proske");
        people.add("C. Ludwig");
        people.add("A. Wessling");


        people.add("Your Name");
        people.remove("K. Liegert");

     PeopleSet peopleSet;

        peopleSet.add("Joe Cool");
        peopleSet.add("Mr. Nobody");
        peopleSet.remove("T. Wappler");
        peopleSet.add("Mrs. Somebody");


        printCollection(PolyPeopleSet(peopleSet));
        printCollection(PolyPeopleSeq(people));


        PeopleTab peopleTab;
        PolyPeopleTab polyPeopleTab(peopleTab);
        polyPeopleTab.addAllFrom(PolyPeopleSeq(people));
        polyPeopleTab.add("Your Name again");
        printCollection(polyPeopleTab);
        peopleTab.add(" yet another Joe Cool");

        return 0;
}
