/*************************************************************************

 IBM(R) VisualAge(TM) C++ for OS/2(R), Version 3
  - Collection Class Library -

 (C) Copyright IBM Corp. 1991, 1995.
  - Licensed Material - Program-Property of IBM - All Rights Reserved.

 *************************************************************************/

#include <istring.hpp>
#include <iostream.h>
#include <iglobals.h>

class Person {
        IString name;                          // the key
        IString telephoneNumber;
public:
        Person(char* n, char* tel) : name(n), telephoneNumber(tel)  { }
        Person(Person const & person)
        : name(person.name),
          telephoneNumber(person.telephoneNumber)  { }
        Person& operator = (Person const & person) {
           if (& person != this) {
              name = person.name;
              telephoneNumber =person.telephoneNumber;
           } /* endif */
          return *this;
        }

        IString const& getName()  const {
             return name;
        }
        IString const& getTel() const{
             return telephoneNumber;
        }
};
// key function

inline IString const &  key  (Person const & keyPerson){
      return   keyPerson.getName();
}
// hash function for the key
inline unsigned long  hash (Person const & person, unsigned long n){
      return  hash (key(person), n );
      // hash for char * defined in istdops.h
}
