/*************************************************************************

 IBM(R) VisualAge(TM) C++ for OS/2(R), Version 3
  - Collection Class Library -

 (C) Copyright IBM Corp. 1991, 1995.
  - Licensed Material - Program-Property of IBM - All Rights Reserved.

 *************************************************************************/

#include <iostream.h>
#include <person5.h>

//include <ikeyset.h>
//typedef IKeySet <Person , String>  People;

#include <ihshks.h>
typedef IHashKeySet <Person, IString>  People;

ostream & operator << (ostream & sout, People people)
{
  cout << "Number of entries: " << people.numberOfElements () << endl;

  People::Cursor cursor (people);
  forCursor (cursor)
  {
    cout << "Name " << cursor.element ().getName ()
         << " Phone " <<  cursor.element ().getTel () << endl;
  }

  return sout;
}

class MyIterator : public IConstantIterator <Person>
{
  applyTo (Person const & person)
  {
    cout << "Phone " << person.getTel () << endl;
    return  True;
  }
};

IBoolean nonUSNumber (Person const & person, void*)
{
  return person.getTel ().subString (1, 3) == "xxx";
}

int main ()
{
//People people;
  People people (50);

  people.add (Person ("J. Uhl", "001-344111"));
  people.add (Person ("K. Liegert", "911-911911"));
  people.add (Person ("M. Blum", "xxx-245343"));
  people.add (Person ("T. Wappler", "xxx-344543"));
  people.add (Person ("F. Seliger", "xxx-34835473"));
  people.add (Person ("S. Hartig", "001-12345633"));
  people.add (Person ("B. Proske", "001-260678"));
  people.add (Person ("C. Ludwig", "xxx-9456543"));
  people.add (Person ("A. Wessling", "007-081500"));

  cout << people;

  if (! people.removeElementWithKey ("C. Ludwig"))
  {
    cout << "element not removed !" << endl;
  }

  MyIterator printNumbers;
  people.allElementsDo (printNumbers);

  People::Cursor cursor (people);

  if (people.locateElementWithKey ("F. Seliger", cursor))
  {
    Person person (people.elementAt (cursor));
    cout << person.getName () << ' ' <<  person.getTel ()  << endl;
  }
  else
  {
    cout<< "F. Seliger not found" << endl;
  }

  people.removeAll (nonUSNumber);
  cout << people;

  return 0;
}
