/* REXX */

%PROLOG%

/*  REXX - %M_MYOBJECT% install script                        */
/*  Installs %M_MYOBJECT%'s DLL                               */

Parse source . . __rexx_name;
__rexx_dir = Filespec('D',__rexx_name)||Filespec('P',__rexx_name)

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;           

     /* Get system DLL directory path */
     system_dll=FileSpec('Drive',Value('SYSTEM_INI',,'OS2ENVIRONMENT'))||'\OS2\DLL';

     rc=SysDeregisterObjectClass('%M_MYOBJECT%');     /* Deregister %M_MYOBJECT% class */

     Address CMD '@ERASE 'system_dll'\%U_MYOBJECT%.DLL 2>NUL';    /* Erase old DLL */

     Address CMD '@COPY '__rexx_dir'%U_MYOBJECT%.DLL 'system_dll; /* Copy new DLL to system DLL dir */

     If rc <> 0                 /* If %M_MYOBJECT% class did not deregister OK */
        Then Do;
          Say  "%M_MYOBJECT%: Could not replace the %M_MYOBJECT% DLL, rc="rc".";
          Say  "%M_MYOBJECT%: Delete the object and the DLL from \OS2\DLL directory.";
          Exit;
          End;

     /* Everything OK so far.  Register %M_MYOBJECT% class */
     rc=SysRegisterObjectClass('%M_MYOBJECT%',system_dll||'\%U_MYOBJECT%.DLL');

     If rc <> 1                 /* If %M_MYOBJECT% class did not register OK */
        Then Do;
          Say  "%M_MYOBJECT%: could not register %M_MYOBJECT% class, rc="rc".";
          Exit;
          End;    

     /* Now create object on Desktop */
     rc=SysCreateObject('%M_MYOBJECT%', '%M_MYOBJECT%', '<WP_DESKTOP>', ,
                        'ICONFILE='__rexx_dir'%U_MYOBJECT%.ICO;OBJECTID=<%U_MYOBJECT%>;',,
                        'replace');

     If rc <> 1                 /* If there were create errors */
        Then Do;
          Say  "%M_MYOBJECT%: could not create object on the Desktop, rc="rc".";
          End;
Exit;
