/*REXX*/

/*   WPSSCR.CMD   Project Smarts install script for WPS project
 *
 *   Licensed Materials - Property of IBM
 *
 *   "Restricted Materials of IBM"
 *
 *   IBM WorkFrame
 *
 *   (C) Copyright IBM Corp. 1995. All Rights Reserved.
 *
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with
 *   IBM Corp.
 *
 */

/* Initialize - use a global stem variable. */
stem = "stem"
RC_OK     = 0
RC_CANCEL = 95


/* Open the installation console. */
rc = IwfOpenConsole(stem);

/* Load the REXX utility functions. */
rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs');
rc = SysLoadFuncs();

/* Load the Tools Setup utility functions */
rc = RxFuncAdd('IwfEnvPrfLoadFuncs', 'IWFPAPI', 'IwfRxEnvPrfLoadFuncs');
rc = IwfEnvPrfLoadFuncs();

/* Extract the passed parameters. */
if (Arg() <> 3) Then
   call Abort("Error in parameter list.");
Parse Arg Proj,Src,Cat;

SAY Cat

/* Initialize the progress, status, and log. */
stem.usPercent     = 0
stem.pszStatusText = "Initializing..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Initializing the Project Smarts install..."
SAY " "

/* Present disclaimers. */
stem.usPercent     = 10
stem.pszStatusText = "Presenting disclaimers..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
line1 = 'DISCLAIMER OF WARRANTIES.  The code that will be installed is '
line2 = 'template code created by IBM Corporation. This code is not '
line3 = 'part of any standard or IBM product and is provided to you solely '
line4 = 'for  the purpose of assisting you in the development of your '
line5 = 'applications.  The code is provided "AS IS", without '
line6 = 'warranty of any kind.  IBM shall not be liable for any damages '
line7 = 'arising out of your use of the sample code, even if they have been '
line8 = 'advised of the possibility of such damages.'
SAY line1||line2||line3||line4||line5||line6||line7||line8
SAY " "

/* Query the target location for the install. */
stem.usPercent     = 30
stem.pszStatusText = "Querying the install location..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Enter the project name, target directory, and folder for the installation."
/* Set defaults for Location dialog */
env='OS2ENVIRONMENT';                  /* Default target directory */
tmploc = VALUE('tmp',,env)             /* is on TMP variable dir   */  
tmploc = STRIP(tmploc,Trailing,'\');   /* Strip any backslashes at end of path */
Locn = tmploc||'\wpsprj';
stem.pszTargetProject   = Proj
stem.pszTargetDirectory = Locn
stem.pszTargetFolder    = "Desktop"
do until (rc = RC_OK)
   rc = IwfQueryLocation(stem);
   if (rc  = RC_CANCEL) then call Cancel
   else
   if (rc <> RC_OK) then call Abort("Error querying target information.");
end


/* Set up default variable settings for the installation. */
stem.usPercent     = 40
stem.pszStatusText = "Confirming variable settings..."
stem.usVariableCount = 4
stem.pszVariableName.1        = "Your_Name"
stem.pszVariableDescription.1 = "Your name for the source code prolog."
stem.pszVariableValue.1       = "Your name"
stem.pszVariableName.2        = "Date"
stem.pszVariableDescription.2 = "The date for the source code prolog."
stem.pszVariableValue.2       = Date()
stem.pszVariableName.3        = "Object_Name"
stem.pszVariableDescription.3 = "The name of the WPS class you want to implement. This class will be defined for you in the generated SOM IDL file.  Please specify an 8-character name if the destination file system is FAT."
stem.pszVariableValue.3       = "MyObject"
stem.pszVariableName.4        = "Prolog"
stem.pszVariableDescription.4 = "The prolog that appears at the head of all the generated source files."
stem.pszVariableValue.4       = "/*\n * %OBJECT_NAME%. This file was created for %YOUR_NAME% \n * by Project Smarts on %DATE%. \n */";
stem.pszVariableName.5        = "M_MYOBJECT"
stem.pszVariableDescription.5 = "Class name - mixed case."
stem.pszVariableValue.5       = "MyObject"
stem.pszVariableName.6        = "U_MYOBJECT"
stem.pszVariableDescription.6 = "Class name - upper case."
stem.pszVariableValue.6       = "MYOBJECT"
stem.pszVariableName.7        = "L_MYOBJECT"
stem.pszVariableDescription.7 = "Class name - lower case."
stem.pszVariableValue.7       = "myobject"

rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Confirm the settings of variables used to customize the installation."
/* Restore any saved variable settings */
stem.pszCatalog = Cat;
stem.pszApplication = 'VAPSWPS';
rc = IwfRestoreVariables(stem);
if (rc <> RC_OK) then SAY ("Could not restore variable settings. Will use defaults.");
/* Restore date to current date */
stem.pszVariableValue.2 = Date()
/* Show Variable Settings window */
do until (rc = RC_OK)
   rc = IwfQueryVariables(stem);
   if (rc  = RC_CANCEL) then call Cancel
   else
   if (rc <> RC_OK) then call Abort("Error querying variable settings.");
end
/* Save variable settings */
rc = IwfSaveVariables(stem);
if (rc <> RC_OK) then SAY ("Error saving variable settings.");


/**** Process variable settings ****/
/* Take only an 8-character file name */
/* stem.pszVariableValue.3 = SUBSTR(stem.pszVariableValue.3,1,8); */
/* stem.pszVariableValue.3 = STRIP(stem.pszVariableValue.3);      */
SAY "New file name: "stem.pszVariableValue.3;
/* Process lower- and upper-case variables */
stem.pszVariableValue.5 = stem.pszVariableValue.3;
stem.pszVariableValue.6 = TRANSLATE(stem.pszVariableValue.5);  /* Change to upper case */
stem.pszVariableValue.7 = LowerCase(stem.pszVariableValue.5);  /* Change to lower case */
/* Update variable count to include invisible variables */
stem.usVariableCount = 7;
/* Strip any backslashes from the end of the specified target path */
stem.pszTargetDirectory = STRIP(stem.pszTargetDirectory,Trailing,'\');



/* Copy the files over, substituting the variable settings. */
stem.usPercent     = 50
stem.pszStatusText = "Copying files, with substitution."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The project source files in" Src "are being copied to" stem.pszTargetDirectory"."
stem.pszSourceFileMask = Src;
/* Copy main directory files */
rc = IwfCopyWithSubstitution(stem);
if (rc <> RC_OK) then call Abort("Error performing copy with substitution.");
/* Copy files in help subdirectory */
mainTargetDir = stem.pszTargetDirectory;
mainSourceDir = Src;
helpTargetDir = mainTargetDir||"\HLP";
stem.pszTargetDirectory = helpTargetDir;
stem.pszSourceFileMask = mainSourceDir||"\HLP"
rc = IwfCopyWithSubstitution(stem);
if (rc <> RC_OK) then call Abort("Error performing copy with substitution.");
/* Copy files in WPS DLL subdirectory */
DLLTargetDir =  mainTargetDir||"\WPSDLL";
stem.pszTargetDirectory = DLLTargetDir;
stem.pszSourceFileMask = mainSourceDir||"\WPSDLL"
rc = IwfCopyWithSubstitution(stem);
if (rc <> RC_OK) then call Abort("Error performing copy with substitution.");
/* Restore variables */
stem.pszTargetDirectory = mainTargetDir
stem.pszSourceFileMask = mainSourceDir


/* Renaming files */
stem.usPercent     = 60
stem.pszStatusText = "Renaming files."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
curdir = DIRECTORY();
newdir = DIRECTORY(stem.pszTargetDirectory);
newFileMask = stem.pszVariableValue.6'.*'
'rename myobject.*' newFileMask
if (rc <> RC_OK) then call Abort("Error renaming files. The specified file name may be invalid or the disk is full. Please delete any created files and start over.");
/* Rename files in Help subdirectory */
call DIRECTORY helpTargetDir
'rename myobject.*' newFileMask
if (rc <> RC_OK) then call Abort("Error renaming files. The specified file name may be invalid or the disk is full. Please delete any created files and start over.");
/* Rename files in WPSDLL subdirectory */
call DIRECTORY DLLTargetDir
'rename myobject.*' newFileMask
if (rc <> RC_OK) then call Abort("Error renaming files. The specified file name may be invalid or the disk is full. Please delete any created files and start over.");
/* Return to original directory */
call DIRECTORY curdir;


/* Create and set the WPS Resource project. */
stem.usPercent     = 70;
stem.pszStatusText = "Creating the WPS Resource project.";
SAY "The project will be created in "||stem.pszTargetFolder;
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
/* Get the path of the shell projects */
ShellPath = VALUE('CPPMAIN',,env);   /* on CPPMAIN variable path */
if ShellPath='' then call Abort("Error obtaining Project Smarts path.");
ShellPath = ShellPath'\smarts\projects';
stem.pszSourceProject = ShellPath'\RESDLL'
pszTarDir = stem.pszTargetDirectory;
stem.pszTargetProjectSetup = 'TARGETNAME=myobjres.dll;MAKEFILENAME=myobjres.mak;PAMLOCATION:IWFBPAM='pszTarDir';PAMDEFAULT:IWFBPAM='pszTarDir';INHERITLIST=<CPPDFTPRJ>;TITLE='stem.pszTargetProject';'
SAY stem.pszTargetProjectSetup;
rc = IwfCreateProjectFromProject(stem)
SAY 'Returned Resource WPS project path name: 'stem.pszTargetFile
if (rc <> RC_OK) then call Abort("Error creating project.");
ResPrjPath = stem.pszTargetFile;


/* Create and set the WPS DLL project. */
stem.usPercent     = 80;
stem.pszStatusText = "Creating the Object DLL project.";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
WPSDir = pszTarDir||'\WPSDLL';
stem.pszSourceProject = ShellPath'\WPS';
stem.pszTargetProjectSetup = 'TARGETNAME='stem.pszVariableValue.7'.dll;MAKEFILENAME='stem.pszVariableValue.7'.mak;PAMLOCATION:IWFBPAM='WPSDir';PAMDEFAULT:IWFBPAM='WPSDir';INHERITLIST=<CPPDFTPRJ>;TITLE=Class DLL Project;'
stem.pszTargetFolder = pszTarDir;
SAY stem.pszTargetProjectSetup;
rc = IwfCreateProjectFromProject(stem)
SAY 'Returned Class DLL project path name: 'stem.pszTargetFile
if (rc <> RC_OK) then call Abort("Error creating project.");
WPSPrjPath = stem.pszTargetFile;


/* Create and set the Help project. */
stem.usPercent     = 75;
stem.pszStatusText = "Creating the Help project.";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
stem.pszSourceProject = ShellPath'\Help';
stem.pszTargetProject = 'Help Project';
stem.pszTargetFolder = pszTarDir;
pszHlpDir = pszTarDir'\HLP';
stem.pszTargetProjectSetup = 'TARGETNAME=help.hlp;MAKEFILENAME=help.mak;PAMLOCATION:IWFBPAM='pszHlpDir';PAMDEFAULT:IWFBPAM='pszHlpDir';INHERITLIST=<CPPDFTPRJ>;TITLE=Help Project;'
SAY stem.pszTargetProjectSetup;
rc = IwfCreateProjectFromProject(stem)
if (rc <> RC_OK) then call Abort("Error creating project.");
SAY 'Returned Help project path name: 'stem.pszTargetFile


/* Set the WPS and Resource projects */
stem.usPercent     = 90;
stem.pszStatusText = "Updating the WPS project.";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY 'Adding environment variables...'
/* Add environment variables to WPS Class DLL project */
stem.pszProject = WPSPrjPath;
stem.pszName    = "SMEMIT";
stem.pszValue   = "C;H;IH;DEF;"
rc = IwfAddVariable(stem);
if (rc <> RC_OK) then call Abort("Error adding SMEMIT environment variable.");
stem.pszName    = "HELP";
stem.pszValue   = pszHlpDir';%HELP%;'
rc = IwfAddVariable(stem);
if (rc <> RC_OK) then call Abort("Error adding HELP environment variable.");
/* Now add INCLUDE variable to WPS Resource project */
stem.pszProject = ResPrjPath;
stem.pszName    = "INCLUDE";
stem.pszValue   = WPSDir||';%INCLUDE%'
rc = IwfAddVariable(stem);
if (rc <> RC_OK) then call Abort("Error adding INCLUDE environment variable.");


/* Done! */
stem.usPercent     = 100
stem.pszStatusText = "Installation successful."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The installation is complete and was successful."
rc = RxMessageBox("The WorkFrame project has been created.", "Done!", "OK", "Information");

/* We are done. */
call Done(0);


LowerCase:
arg Str
return TRANSLATE(Str,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ');

Cancel:
rcCancel = RxMessageBox("Do you really want to cancel?", , "YesNo", "Query")
if (rcCancel = 6) Then
   call Done(8)
return

Abort:
parse arg abortMessage
rcAbort = RxMessageBox(abortMessage, , "OK", "Error")
call Done(16)

Done:
arg exitRc
/* Close the installation console. */
rcDone = IwfCloseConsole(stem);
/* Unload the environment profile functions */
rc = IwfEnvPrfDropFuncs() 
exit(exitRc)




