/*REXX*/

/*   VBSCR.CMD  Project Smarts install script for Visual Builder project
 *
 *   Licensed Materials - Property of IBM
 *
 *   "Restricted Materials of IBM"
 *
 *   IBM WorkFrame
 *
 *   (C) Copyright IBM Corp. 1995. All Rights Reserved.
 *
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with
 *   IBM Corp.
 *
 */


/* Initialize - use a global stem variable. */
stem = "stem"
RC_OK     = 0
RC_CANCEL = 95


/* Open the installation console. */
rc = IwfOpenConsole(stem);


/* Load the REXX utility functions. */
rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs');
rc = SysLoadFuncs();


/* Extract the passed parameters. */
if (Arg() <> 2) Then
   call Abort("Error in parameter list.");
Parse Arg Proj,Src;


/* Initialize the progress, status, and log. */
stem.usPercent     = 0
stem.pszStatusText = "Initializing..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Initializing the Project Smarts install..."
SAY " "

/* Present disclaimers. */
stem.usPercent     = 10
stem.pszStatusText = "Presenting disclaimers..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
line1 = 'DISCLAIMER OF WARRANTIES.  The code that will be installed is '
line2 = 'template code created by IBM Corporation. This code is not '
line3 = 'part of any standard or IBM product and is provided to you solely '
line4 = 'for  the purpose of assisting you in the development of your '
line5 = 'applications.  The code is provided "AS IS", without '
line6 = 'warranty of any kind.  IBM shall not be liable for any damages '
line7 = 'arising out of your use of the sample code, even if they have been '
line8 = 'advised of the possibility of such damages.'
SAY line1||line2||line3||line4||line5||line6||line7||line8
SAY " "

/* Query the target location for the install. */
stem.usPercent     = 30
stem.pszStatusText = "Querying the install location..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Enter the project name, target directory, and folder for the installation."
/* Set defaults for Location dialog */
env='OS2ENVIRONMENT';                  /* Default target directory */
tmploc = VALUE('tmp',,env)             /* is on TMP variable dir   */  
tmploc = STRIP(tmploc,Trailing,'\');   /* Strip any backslashes at end of path */
Locn = tmploc||'\vbprj';
stem.pszTargetProject   = Proj
stem.pszTargetDirectory = Locn
stem.pszTargetFolder    = "Desktop"
do until (rc = RC_OK)
   rc = IwfQueryLocation(stem);
   if (rc  = RC_CANCEL) then call Cancel
   else
   if (rc <> RC_OK) then call Abort("Error querying target information.");
end


/* Copy the parts file over. */
stem.usPercent     = 50
stem.pszStatusText = "Copying files, with substitution."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The project source files in" Src "are being copied to" stem.pszTargetDirectory"."
stem.pszSourceFileMask = Src;
copy Src'\* ' stem.pszTargetDirectory
if (rc <> RC_OK) then call Abort("Error copying files.");


/* Create and set the WorkFrame project. */
stem.usPercent     = 80;
stem.pszStatusText = "Creating the Workframe/2 project.";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The project will be created in "stem.pszTargetFolder;
pszTarDir = stem.pszTargetDirectory;
/* Get the path of the shell projects */
ShellPath = VALUE('CPPMAIN',,env);   /* on CPPMAIN variable path */
if ShellPath='' then call Abort("Error obtaining CPPMAIN path.");
ShellPath = ShellPath'\smarts\projects';
stem.pszSourceProject = ShellPath'\VB'
stem.pszTargetProjectSetup = 'TARGETNAME=VBMain.exe;MAKEFILENAME=VBMain.mak;PAMLOCATION:IWFBPAM='pszTarDir';PAMDEFAULT:IWFBPAM='pszTarDir';INHERITLIST=<CPPDFTPRJ>;TITLE='stem.pszTargetProject';'
SAY stem.pszTargetProjectSetup;
rc = IwfCreateProjectFromProject(stem)
if (rc <> RC_OK) then call Abort("Error creating project.");


/* Done! */
stem.usPercent     = 100
stem.pszStatusText = "Installation successful."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The installation is complete and was successful."
rc = RxMessageBox("The WorkFrame project has been created.", "Done!", "OK", "Information");

/* We are done. */
call Done(0);


Cancel:
rcCancel = RxMessageBox("Do you really want to cancel?", , "YesNo", "Query")
if (rcCancel = 6) Then
   call Done(8)
return

Abort:
parse arg abortMessage
rcAbort = RxMessageBox(abortMessage, , "OK", "Error")
call Done(16)

Done:
arg exitRc
/* Close the installation console. */
rcDone = IwfCloseConsole(stem);
exit(exitRc)



