/*REXX*/

/*   RESSCR.CMD   Project Smarts install script for Resource DLL project
 *
 *   Licensed Materials - Property of IBM
 *
 *   "Restricted Materials of IBM"
 *
 *   IBM WorkFrame
 *
 *   (C) Copyright IBM Corp. 1995. All Rights Reserved.
 *
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with
 *   IBM Corp.
 *
 */


/* Initialize - use a global stem variable. */
stem = "stem"
RC_OK     = 0
RC_CANCEL = 95


/* Open the installation console. */
rc = IwfOpenConsole(stem);


/* Load the REXX utility functions. */
rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs');
rc = SysLoadFuncs();

/* Load the Tools Setup utility functions */
rc = RxFuncAdd('IwfEnvPrfLoadFuncs', 'IWFPAPI', 'IwfRxEnvPrfLoadFuncs');
rc = IwfEnvPrfLoadFuncs();

/* Extract the passed parameters. */
if (Arg() <> 3) Then
   call Abort("Error in parameter list.");
Parse Arg Proj,Src,Cat;

SAY Cat

/* Initialize the progress, status, and log. */
stem.usPercent     = 0
stem.pszStatusText = "Initializing..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Initializing the Project Smarts install..."
SAY " "

/* Present disclaimers. */
stem.usPercent     = 10
stem.pszStatusText = "Presenting disclaimers..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
line1 = 'DISCLAIMER OF WARRANTIES.  The code that will be installed is '
line2 = 'template code created by IBM Corporation. This code is not '
line3 = 'part of any standard or IBM product and is provided to you solely '
line4 = 'for  the purpose of assisting you in the development of your '
line5 = 'applications.  The code is provided "AS IS", without '
line6 = 'warranty of any kind.  IBM shall not be liable for any damages '
line7 = 'arising out of your use of the sample code, even if they have been '
line8 = 'advised of the possibility of such damages.'
SAY line1||line2||line3||line4||line5||line6||line7||line8
SAY " "

/* Query the target location for the install. */
stem.usPercent     = 30
stem.pszStatusText = "Querying the install location..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Enter the project name, target directory, and folder for the installation."
/* Set defaults for Location dialog */
env='OS2ENVIRONMENT';                  /* Default target directory */
tmploc = VALUE('tmp',,env)             /* is on TMP variable dir   */  
tmploc = STRIP(tmploc,Trailing,'\');   /* Strip any backslashes at end of path */
Locn = tmploc||'\resprj';
stem.pszTargetProject   = Proj
stem.pszTargetDirectory = Locn
stem.pszTargetFolder    = "Desktop"
do until (rc = RC_OK)
   rc = IwfQueryLocation(stem);
   if (rc  = RC_CANCEL) then call Cancel
   else
   if (rc <> RC_OK) then call Abort("Error querying target information.");
end


/* Set up default variable settings for the installation. */
stem.usPercent     = 40
stem.pszStatusText = "Confirming variable settings..."
stem.usVariableCount = 6
stem.pszVariableName.1        = "Your_Name"
stem.pszVariableDescription.1 = "Your name for the source file prolog."
stem.pszVariableValue.1       = "Your name"
stem.pszVariableName.2        = "Resource_File_Path"
stem.pszVariableDescription.2 = "The fully-qualified path name of a directory that contains one or more existing resource (.RC) files. If you accept the default value in this field (that is, "Src"), a template .RC file will be created for you."
stem.pszVariableValue.2       = Src
stem.pszVariableName.3        = "INCLUDE_Path"
stem.pszVariableDescription.3 = "The INCLUDE path you want active for the project.  Ensure that the directories that contain any required header files are included in this path list."
stem.pszVariableValue.3       = ".;%INCLUDE%"
stem.pszVariableName.4        = "File_name"
stem.pszVariableDescription.4 = "The file name for the generated files, for example, RESOURCE.\n"
stem.pszVariableValue.4       = "resource"
stem.pszVariableName.5        = "Prolog"
stem.pszVariableDescription.5 = "The prolog that appears at the head of all the generated source files."
stem.pszVariableValue.5       = "/*\n * Resource DLL. This file was created for %YOUR_NAME% \n * by Project Smarts on %DATE%. \n */";
stem.pszVariableName.6        = "Date"
stem.pszVariableDescription.6 = "The date for the source file prolog."
stem.pszVariableValue.6       = Date()
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Confirm the settings of variables used to customize the installation."
/* Restore any saved variable settings */
stem.pszCatalog = Cat;
stem.pszApplication = 'VAPSResDLL';
rc = IwfRestoreVariables(stem);
if (rc <> RC_OK) then SAY ("Could not restore variable settings. Will use defaults.");
/* Restore date variable to current date */
stem.pszVariableValue.6 = Date()
/* Show Variable Settings window */
do until (rc = RC_OK)
   rc = IwfQueryVariables(stem);
   if (rc  = RC_CANCEL) then call Cancel
   else
   if (rc <> RC_OK) then call Abort("Error querying variable settings.");
end
/* Save variable settings */
/* Store path names upper case in case part of them could be */
/* interpreted as control characters                         */
stem.pszVariableValue.2 = TRANSLATE(stem.pszVariableValue.2);
stem.pszVariableValue.3 = TRANSLATE(stem.pszVariableValue.3);
rc = IwfSaveVariables(stem);
if (rc <> RC_OK) then SAY ("Error saving variable settings.");


/**** Process variable settings ****/
/* Take only an 8-character file name */
/* stem.pszVariableValue.4 = SUBSTR(stem.pszVariableValue.4,1,8); */
/* stem.pszVariableValue.4 = STRIP(stem.pszVariableValue.4);      */
SAY "New file name is: "stem.pszVariableValue.4;
/* Strip any backslashes from the end of the specified target path */
stem.pszTargetDirectory = STRIP(stem.pszTargetDirectory,Trailing,'\');



/* Copy the files over, substituting the variable settings. */
stem.usPercent     = 50
stem.pszStatusText = "Copying files, with substitution."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The project source files in" Src "are being copied to" stem.pszTargetDirectory"."
stem.pszSourceFileMask = Src;
rc = IwfCopyWithSubstitution(stem);
if (rc <> RC_OK) then call Abort("Error performing copy with substitution.");

/* Copy any existing RC's */
if (POS('SMARTS\RESDLL', TRANSLATE(stem.pszVariableValue.2)) = 0) then 
/* If not using default path */
DO
  del stem.pszTargetDirectory'\*.rc'       /* Delete skeleton .RC file first */
  del stem.pszTargetDirectory'\*.h'        /* Delete skeleton .H file */
  del stem.pszTargetDirectory'\*.ico'      /* Delete unrequired .ICO file */
  copy stem.pszVariableValue.2'\*.rc 'stem.pszTargetDirectory
  if (rc <> RC_OK) then call Abort("Error copying resource files. The specified directory may be invalid, or does not contain any .RC files, or the disk is full. Please delete any created files and start over.");
END
/* Renaming files */
stem.usPercent     = 60
stem.pszStatusText = "Renaming files."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
curdir = DIRECTORY();
newdir = DIRECTORY(stem.pszTargetDirectory);
rename 'resdll.* 'stem.pszVariableValue.4'.*'
if (rc <> RC_OK) then call Abort("Error renaming files. The specified file name may be invalid or the disk is full. Please delete any created files and start over.");
call DIRECTORY curdir;


/* Create and set the WorkFrame project */
stem.usPercent     = 80;
stem.pszStatusText = "Creating the Workframe/2 project.";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The project will be created in "stem.pszTargetFolder;
pszTarDir = stem.pszTargetDirectory;
/* Get the path of the shell projects */
ShellPath = VALUE('CPPMAIN',,env);   /* on CPPMAIN variable path */
if ShellPath='' then call Abort("Error obtaining Project Smarts path.");
ShellPath = ShellPath'\smarts\projects';
stem.pszSourceProject = ShellPath'\RESDLL'
stem.pszTargetProjectSetup = 'TARGETNAME='stem.pszVariableValue.4'.dll;MAKEFILENAME='stem.pszVariableValue.4'.mak;PAMLOCATION:IWFBPAM='pszTarDir';PAMDEFAULT:IWFBPAM='pszTarDir';INHERITLIST=<CPPDFTPRJ>;TITLE='stem.pszTargetProject';'
SAY stem.pszTargetProjectSetup;
rc = IwfCreateProjectFromProject(stem)
if (rc <> RC_OK) then call Abort("Error creating project.");
SAY 'Returned Resource DLL project path name: 'stem.pszTargetFile

/* Set the INCLUDE path */
stem.usPercent     = 90;
stem.pszStatusText = "Updating the Resource DLL project.";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY 'Adding INCLUDE environment variable...'
/* Add environment variables to WPS Class DLL project */
stem.pszProject = stem.pszTargetFile
stem.pszName    = "INCLUDE";
stem.pszValue   = stem.pszVariableValue.3       
rc = IwfAddVariable(stem);
if (rc <> RC_OK) then call Abort("Error adding INCLUDE environment variable.");


/* Done! */
stem.usPercent     = 100
stem.pszStatusText = "Installation successful."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The installation is complete and was successful."
rc = RxMessageBox("The WorkFrame project has been created.", "Done!", "OK", "Information");

/* We are done. */
call Done(0);


Cancel:
rcCancel = RxMessageBox("Do you really want to cancel?", , "YesNo", "Query")
if (rcCancel = 6) Then
   call Done(8)
return

Abort:
parse arg abortMessage
rcAbort = RxMessageBox(abortMessage, , "OK", "Error")
call Done(16)

Done:
arg exitRc
/* Close the installation console. */
rcDone = IwfCloseConsole(stem);
/* Unload the environment profile functions */
rc = IwfEnvPrfDropFuncs() 
exit(exitRc)








