/*REXX*/

/*   IWFSMART.CMD  Project Smarts default install script
 *
 *   Licensed Materials - Property of IBM
 *
 *   "Restricted Materials of IBM"
 *
 *   IBM WorkFrame
 *
 *   (C) Copyright IBM Corp. 1995. All Rights Reserved.
 *
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with
 *   IBM Corp.
 *
 */


/* Initialize - use a global stem variable. */
stem = "stem"
RC_OK     = 0
RC_CANCEL = 95


/* Open the installation console. */
rc = IwfOpenConsole(stem);


/* Load the REXX utility functions. */
rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs');
rc = SysLoadFuncs();


/* Extract the passed parameters. */
if (Arg() <> 2) Then
   call Abort("Error in parameter list.");
Parse Arg Proj,Src;


/* Initialize the progress, status, and log. */
stem.usPercent     = 10
stem.pszStatusText = "Initializing..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Initializing the Project Smarts install..."


/* Query the target location for the install. */
stem.usPercent     = 30
stem.pszStatusText = "Querying the install location..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Enter the project name, target directory, and folder for the installation."
/* Set defaults for Location dialog */
env='OS2ENVIRONMENT';                  /* Default target directory */
tmploc = VALUE('tmp',,env)             /* is on TMP variable dir   */  
tmploc = STRIP(tmploc,Trailing,'\');   /* Strip any backslashes at end of path */
Locn = tmploc||'\myprj';
stem.pszTargetProject   = Proj
stem.pszTargetDirectory = Locn
stem.pszTargetFolder    = "Desktop"
do until (rc = RC_OK)
   rc = IwfQueryLocation(stem);
   if (rc  = RC_CANCEL) then call Cancel
   else
   if (rc <> RC_OK) then call Abort("Error querying target information.");
end


/* Copy the files over. */
stem.usPercent     = 60
stem.pszStatusText = "Copying files."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The project source files in" Src "are being copied to" stem.pszTargetDirectory"."
stem.pszSourceFileMask = Src;
stem.usVariableCount = 0;
rc = IwfCopyWithSubstitution(stem);
if (rc <> RC_OK) then call Abort("Error performing copy.");


/* Create the WorkFrame project */
stem.usPercent     = 90;
stem.pszStatusText = "Creating the Workframe/2 project.";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The project will be created in "stem.pszTargetFolder;
stem.pszTargetFile = Src;
rc = IwfCreateProjectFromFiles(stem)
if (rc <> RC_OK) then call Abort("Error creating project.");


/* Done! */
stem.usPercent     = 100
stem.pszStatusText = "Installation successful."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Done!"
SAY "The installation is complete and was successful."
rc = RxMessageBox("The WorkFrame project has been created.", "Done!", "OK", "Information");


/* We are done. */
call Done(0);


Cancel:
rcCancel = RxMessageBox("Do you really want to cancel?", , "YesNo", "Query")
if (rcCancel = 6) Then
   call Done(8)
return

Abort:
parse arg abortMessage
rcAbort = RxMessageBox(abortMessage, , "OK", "Error")
call Done(16)

Done:
arg exitRc
/* Close the installation console. */
rcDone = IwfCloseConsole(stem);
exit(exitRc)





