/*REXX*/

/*   DTSSCR.CMD   Project Smarts install script for DTS project
 *
 *   Licensed Materials - Property of IBM
 *
 *   "Restricted Materials of IBM"
 *
 *   IBM WorkFrame
 *
 *   (C) Copyright IBM Corp. 1995. All Rights Reserved.
 *
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with
 *   IBM Corp.
 *
 */


/* Initialize - use a global stem variable. */
stem = "stem"
RC_OK     = 0
RC_CANCEL = 95


/* Open the installation console. */
rc = IwfOpenConsole(stem);

/* Load the REXX utility functions. */
rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs');
rc = SysLoadFuncs();

/* Extract the passed parameters. */
if (Arg() <> 3) Then
   call Abort("Error in parameter list.");
Parse Arg Proj,Src,Cat;

SAY Cat

/* Initialize the progress, status, and log. */
stem.usPercent     = 0
stem.pszStatusText = "Initializing..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Initializing the Project Smarts install..."
SAY " "

/* Present disclaimers. */
stem.usPercent     = 10
stem.pszStatusText = "Presenting disclaimers..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
line1 = 'DISCLAIMER OF WARRANTIES.  The code that will be installed is '
line2 = 'template code created by IBM Corporation. This code is not '
line3 = 'part of any standard or IBM product and is provided to you solely '
line4 = 'for  the purpose of assisting you in the development of your '
line5 = 'applications.  The code is provided "AS IS", without '
line6 = 'warranty of any kind.  IBM shall not be liable for any damages '
line7 = 'arising out of your use of the sample code, even if they have been '
line8 = 'advised of the possibility of such damages.'
SAY line1||line2||line3||line4||line5||line6||line7||line8
SAY " "

/* Query the target location for the install. */
stem.usPercent     = 30
stem.pszStatusText = "Querying the install location..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Enter the project name, target directory, and folder for the installation."
/* Set defaults for Location dialog */
env='OS2ENVIRONMENT';                  /* Default target directory */
tmploc = VALUE('tmp',,env)             /* is on TMP variable dir   */  
tmploc = STRIP(tmploc,Trailing,'\');   /* Strip any backslashes at end of path */
Locn = tmploc||'\dtsprj';
stem.pszTargetProject   = Proj
stem.pszTargetDirectory = Locn
stem.pszTargetFolder    = "Desktop"
do until (rc = RC_OK)
   rc = IwfQueryLocation(stem);
   if (rc  = RC_CANCEL) then call Cancel
   else
   if (rc <> RC_OK) then call Abort("Error querying target information.");
end


/* Set up default variable settings for the installation. */
stem.usPercent     = 40
stem.pszStatusText = "Confirming variable settings..."
stem.usVariableCount = 3
stem.pszVariableName.1        = "Your_Name"
stem.pszVariableDescription.1 = "Your name for the source code prolog."
stem.pszVariableValue.1       = "Your name"
stem.pszVariableName.2        = "Date"
stem.pszVariableDescription.2 = "The date for the source code prolog."
stem.pszVariableValue.2       = Date()
stem.pszVariableName.3        = "Prolog"
stem.pszVariableDescription.3 = "The prolog that appears at the head of all the generated source files."
stem.pszVariableValue.3       = "/*\n * This file was created for %YOUR_NAME% \n * by Project Smarts on %DATE%. \n */";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Confirm the settings of variables used to customize the installation."
/* Restore any saved variable settings */
stem.pszCatalog = Cat;
stem.pszApplication = 'VAPSDTS';
rc = IwfRestoreVariables(stem);
if (rc <> RC_OK) then SAY ("Could not restore variable settings. Will use defaults.");
/* Restore date to current date */
stem.pszVariableValue.2 = Date()
/* Display variable settings window */
do until (rc = RC_OK)
   rc = IwfQueryVariables(stem);
   if (rc  = RC_CANCEL) then call Cancel
   else
   if (rc <> RC_OK) then call Abort("Error querying variable settings.");
end
/* Save variable settings */
rc = IwfSaveVariables(stem);
if (rc <> RC_OK) then SAY ("Error saving variable settings.");


/* Copy the files over, substituting the variable settings. */
stem.usPercent     = 50
stem.pszStatusText = "Copying files, with substitution."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The project source files in" Src "are being copied to" stem.pszTargetDirectory"."
stem.pszSourceFileMask = Src;
/* Copy main directory files */
rc = IwfCopyWithSubstitution(stem);
if (rc <> RC_OK) then call Abort("Error performing copy with substitution.");
/* Copy files in Cat DLL subdirectory */
mainTargetDir = stem.pszTargetDirectory;
mainSourceDir = Src;
catTargetDir = mainTargetDir"\CAT";
stem.pszTargetDirectory = catTargetDir;
stem.pszSourceFileMask = mainSourceDir"\CAT"
rc = IwfCopyWithSubstitution(stem);
if (rc <> RC_OK) then call Abort("Error performing copy with substitution.");
/* Copy files in Dog DLL subdirectory */
dogTargetDir = mainTargetDir"\DOG";
stem.pszTargetDirectory = dogTargetDir;
stem.pszSourceFileMask = mainSourceDir"\DOG"
rc = IwfCopyWithSubstitution(stem);
if (rc <> RC_OK) then call Abort("Error performing copy with substitution.");
/* Copy files in Animal DLL subdirectory */
animTargetDir =  mainTargetDir"\ANIMAL";
stem.pszTargetDirectory = animTargetDir;
stem.pszSourceFileMask = mainSourceDir"\ANIMAL"
rc = IwfCopyWithSubstitution(stem);
if (rc <> RC_OK) then call Abort("Error performing copy with substitution.");
/* Restore variables */
stem.pszTargetDirectory = mainTargetDir
stem.pszSourceFileMask = mainSourceDir


/* Create and set the Main DTS project. */
stem.usPercent     = 70;
stem.pszStatusText = "Creating the root DTS project.";
SAY "The project will be created in "stem.pszTargetFolder;
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
/* Get the path of the shell projects */
ShellPath = VALUE('CPPMAIN',,env);   /* on CPPMAIN variable path */
if ShellPath='' then call Abort("Error obtaining Project Smarts path.");
ShellPath = ShellPath'\smarts\projects';
stem.pszSourceProject = ShellPath'\DTSMain'
pszTarDir = stem.pszTargetDirectory;
stem.pszTargetProjectSetup = 'TARGETNAME=main.exe;MAKEFILENAME=main.mak;PAMLOCATION:IWFBPAM='pszTarDir';PAMDEFAULT:IWFBPAM='pszTarDir';INHERITLIST=<CPPDFTPRJ>;TITLE='stem.pszTargetProject';'
SAY stem.pszTargetProjectSetup;
rc = IwfCreateProjectFromProject(stem)
SAY 'Returned root DTS project path name: 'stem.pszTargetFile
if (rc <> RC_OK) then call Abort("Error creating project.");
DTSPrjPath = stem.pszTargetFile;


/* Create and set the Dog DLL project. */
stem.usPercent     = 80;
stem.pszStatusText = "Creating the Dog DLL project.";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
stem.pszTargetProject = "Dog DLL Project";
stem.pszSourceProject = ShellPath'\DTSDog';
stem.pszTargetProjectSetup = 'TARGETNAME=dog.dll;MAKEFILENAME=dog.mak;PAMLOCATION:IWFBPAM='dogTargetDir';PAMDEFAULT:IWFBPAM='dogTargetDir';INHERITLIST=<CPPDFTPRJ>;TITLE=Dog DLL Project;'
stem.pszTargetFolder = pszTarDir;  
SAY stem.pszTargetProjectSetup;
rc = IwfCreateProjectFromProject(stem)
SAY 'Returned Dog DLL project path name: 'stem.pszTargetFile
if (rc <> RC_OK) then call Abort("Error creating project.");
DogPrjPath = stem.pszTargetFile;


/* Create and set the Cat DLL project. */
stem.usPercent     = 80;
stem.pszStatusText = "Creating the Cat DLL project.";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
stem.pszTargetProject = 'Cat DLL Project';
stem.pszSourceProject = ShellPath'\DTSDog';
stem.pszTargetProjectSetup = 'TARGETNAME=cat.dll;MAKEFILENAME=cat.mak;PAMLOCATION:IWFBPAM='catTargetDir';PAMDEFAULT:IWFBPAM='catTargetDir';INHERITLIST=<CPPDFTPRJ>;TITLE=Cat DLL Project;'
stem.pszTargetFolder = pszTarDir'\DOG';
SAY stem.pszTargetProjectSetup;
rc = IwfCreateProjectFromProject(stem)
SAY 'Returned Cat DLL project path name: 'stem.pszTargetFile
if (rc <> RC_OK) then call Abort("Error creating project.");
CatPrjPath = stem.pszTargetFile;


/* Create and set the Animal DLL project. */
stem.usPercent     = 75;
stem.pszStatusText = "Creating the Animal DLL project.";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
stem.pszSourceProject = ShellPath'\DTSAnim';
stem.pszTargetProject = 'Animal DLL Project';
stem.pszTargetFolder = pszTarDir'\CAT';
stem.pszTargetProjectSetup = 'TARGETNAME=animal.dll;MAKEFILENAME=animal.mak;PAMLOCATION:IWFBPAM='animTargetDir';PAMDEFAULT:IWFBPAM='animTargetDir';INHERITLIST=<CPPDFTPRJ>;TITLE=Animal DLL Project;'
SAY stem.pszTargetProjectSetup;
rc = IwfCreateProjectFromProject(stem)
if (rc <> RC_OK) then call Abort("Error creating project.");
SAY 'Returned Help project path name: 'stem.pszTargetFile


/* Done! */
stem.usPercent     = 100
stem.pszStatusText = "Installation successful."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The installation is complete and was successful."
rc = RxMessageBox("The WorkFrame project has been created.", "Done!", "OK", "Information");

/* We are done. */
call Done(0);


Cancel:
rcCancel = RxMessageBox("Do you really want to cancel?", , "YesNo", "Query")
if (rcCancel = 6) Then
   call Done(8)
return

Abort:
parse arg abortMessage
rcAbort = RxMessageBox(abortMessage, , "OK", "Error")
call Done(16)

Done:
arg exitRc
/* Close the installation console. */
rcDone = IwfCloseConsole(stem);
/* Unload the environment profile functions */
exit(exitRc)




