/*REXX*/

/*   DAXSCR.CMD   Project Smarts install script for a Data Access Builder project
 *
 *   Licensed Materials - Property of IBM
 *
 *   "Restricted Materials of IBM"
 *
 *   IBM WorkFrame
 *
 *   (C) Copyright IBM Corp. 1995. All Rights Reserved.
 *
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with
 *   IBM Corp.
 *
 */


/* Initialize - use a global stem variable. */
stem = "stem"
RC_OK     = 0
RC_CANCEL = 95

/* Open the installation console. */
rc = IwfOpenConsole(stem);

/* Load the REXX utility functions. */
rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs');
rc = SysLoadFuncs();


/* Extract the passed parameters. */
if (Arg() <> 3) Then
   call Abort("Error in parameter list.");
Parse Arg Proj,Src,Cat;

SAY Cat

/* Initialize the progress, status, and log. */
stem.usPercent     = 0
stem.pszStatusText = "Initializing..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Initializing the Project Smarts install..."
SAY " "

/* Present disclaimers. */
stem.usPercent     = 10
stem.pszStatusText = "Presenting disclaimers..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
line1 = 'DISCLAIMER OF WARRANTIES.  The code that will be installed is '
line2 = 'template code created by IBM Corporation. This code is not '
line3 = 'part of any standard or IBM product and is provided to you solely '
line4 = 'for  the purpose of assisting you in the development of your '
line5 = 'applications.  The code is provided "AS IS", without '
line6 = 'warranty of any kind.  IBM shall not be liable for any damages '
line7 = 'arising out of your use of the sample code, even if they have been '
line8 = 'advised of the possibility of such damages.'
SAY line1||line2||line3||line4||line5||line6||line7||line8
SAY " "

/* Query the target location for the install. */
stem.usPercent     = 30
stem.pszStatusText = "Querying the install location..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Enter the project name, target directory, and folder for the installation."
/* Set defaults for Location dialog */
env='OS2ENVIRONMENT';                  /* Default target directory */
tmploc = VALUE('tmp',,env)             /* is on TMP variable dir   */  
tmploc = STRIP(tmploc,Trailing,'\');   /* Strip any backslashes at end of path */
Locn = tmploc||'\daxprj';
stem.pszTargetProject   = Proj
stem.pszTargetDirectory = Locn
stem.pszTargetFolder    = "Desktop"
do until (rc = RC_OK)
   rc = IwfQueryLocation(stem);
   if (rc  = RC_CANCEL) then call Cancel
   else
   if (rc <> RC_OK) then call Abort("Error querying target information.");
end


/* Set up default variable settings for the installation. */
stem.usPercent     = 40
stem.pszStatusText = "Confirming variable settings..."
stem.usVariableCount = 8

stem.pszVariableName.1        = "Your_Name"
stem.pszVariableDescription.1 = "Your name for the source code prolog."
stem.pszVariableValue.1       = "Your name"
stem.pszVariableName.2        = "Date"
stem.pszVariableDescription.2 = "The date for the source code prolog."
stem.pszVariableValue.2       = Date()
stem.pszVariableName.3        = "Application_Type"
stem.pszVariableDescription.3 = "The type of DAX application you want to create: \n1 for C++ \n2 for SOM IDL"
stem.pszVariableValue.3       = "1"
stem.pszVariableName.4        = "File_name"
stem.pszVariableDescription.4 = "The file name for the generated application files, for example, DAXBASIC.\n"
stem.pszVariableValue.4       = "daxbasic"
stem.pszVariableName.5        = "Prolog" 
stem.pszVariableDescription.5 = "The prolog that appears at the head of all the generated source files." 
stem.pszVariableValue.5       = "/* %FILE_NAME%.  This file was created for %YOUR_NAME% by Project Smarts on %DATE%. */"
stem.pszVariableName.6        = "Datastore_Name"
stem.pszVariableDescription.6 = "The name of an existing DB2/2 datastore whose data to access. A connection is established to this datastore in the generated application. "
stem.pszVariableValue.6       = "DATASTOR"
stem.pszVariableName.7        = "DAX_Class"
stem.pszVariableDescription.7 = "Name of the Data Access class to be generated by the Data Access Builder tool."
stem.pszVariableValue.7       = "DAX_Class"
stem.pszVariableName.8        = "DAX_File"
line1 = "File stem of the data access source files to be generated by the Data Access Builder tool.  For a C++ application, a 'v' is "
line2 = "appended to this value to form the generated header file name.  For a SOM application, an 'i' is appended."
stem.pszVariableDescription.8 = line1||line2;
stem.pszVariableValue.8       = "daxfile"
stem.pszVariableName.9        = "GenType"
stem.pszVariableDescription.9 = ""
stem.pszVariableValue.9       = "Parts"
stem.pszVariableName.10        = "IDLNote"
stem.pszVariableDescription.10 = ""
stem.pszVariableValue.10       = ""
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Confirm the settings of variables used to customize the installation."
/* Restore any saved variable settings */
stem.pszCatalog = Cat;
stem.pszApplication = 'VAPSDAX';
rc = IwfRestoreVariables(stem);
if (rc <> RC_OK) then SAY ("Could not restore variable settings. Will use defaults.");
/* Restore date to current date */
stem.pszVariableValue.2 = Date()
/* Display variable settings window */
do until (rc = RC_OK)
   rc = IwfQueryVariables(stem);
   if (rc  = RC_CANCEL) then call Cancel
   else
   if (rc <> RC_OK) then call Abort("Error querying variable settings.");
   call CheckVars;
end
/* Save variable settings */
rc = IwfSaveVariables(stem);
if (rc <> RC_OK) then SAY ("Error saving variable settings.");


/* Process variable settings */
stem.usVariableCount = 10
if stem.pszVariableValue.3 = "1" then stem.pszVariableValue.9 = "Parts"
                                 else stem.pszVariableValue.9 = "IDL"

IDLNote = "\nNote: You also need to generate the .xh files for the Data Access SOM Class \nLibrary, if you have not already done so.\n "
if stem.pszVariableValue.3 = "1" then stem.pszVariableValue.10 = " "
                                 else stem.pszVariableValue.10 = IDLNote

/* Copy the files over, substituting the variable settings. */
stem.usPercent     = 50
stem.pszStatusText = "Copying files, with substitution."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
/* Copy the readme file over */
stem.pszSourceFileMask = Src
rc = IwfCopyWithSubstitution(stem);
if (rc <> RC_OK) then call Abort("Error copying readme file.");
/* Copy source files from the correct directory */
if (DAXType="1") then stem.pszSourceFileMask = Src'\DAXCPP'
                 else stem.pszSourceFileMask = Src'\DAXSOM';
SAY "The project source files in" stem.pszSourceFileMask "are being copied to" stem.pszTargetDirectory"."
rc = IwfCopyWithSubstitution(stem);
if (rc <> RC_OK) then call Abort("Error performing copy with substitution.");


/* Renaming files */
stem.usPercent     = 60
stem.pszStatusText = "Renaming files."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
curdir = DIRECTORY();
newdir = DIRECTORY(stem.pszTargetDirectory);
SAY "Renaming files in "newdir" to "stem.pszVariableValue.4;
rename 'daxbasic.* 'stem.pszVariableValue.4'.*'
if (rc <> RC_OK) then call Abort("Error renaming files. The specified file name may be invalid or the disk is full. Please delete any created files and start over.");
call DIRECTORY curdir;


/* Create the WorkFrame project */
stem.usPercent     = 90;
stem.pszStatusText = "Creating the Workframe/2 project.";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The project will be created in "stem.pszTargetFolder;
/* Get the path of the shell projects */
ShellPath = VALUE('CPPMAIN',,env);   /* on CPPMAIN variable path */
if ShellPath='' then call Abort("Error obtaining Project Smarts path.");
ShellPath = ShellPath'\smarts\projects';
if (DAXType="1") then stem.pszSourceProject = ShellPath'\DAXCPP';
if (DAXType="2") then stem.pszSourceProject = ShellPath'\DAXSOM';
SAY "Shell project: "stem.pszSourceProject;
pszTarDir = stem.pszTargetDirectory;
stem.pszTargetProjectSetup = 'TARGETNAME='stem.pszVariableValue.4'.dll;MAKEFILENAME='stem.pszVariableValue.4'.mak;PAMLOCATION:IWFBPAM='pszTarDir';PAMDEFAULT:IWFBPAM='pszTarDir';INHERITLIST=<CPPDFTPRJ>;TITLE='stem.pszTargetProject';'
SAY stem.pszTargetProjectSetup;
rc = IwfCreateProjectFromProject(stem)
if (rc <> RC_OK) then call Abort("Error creating project.");


/* Done! */
stem.usPercent     = 100
stem.pszStatusText = "Installation successful."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The installation is complete and was successful."
rc = RxMessageBox("The WorkFrame project has been created.", "Done!", "OK", "Information");

/* We are done. */
call Done(0);


CheckVars:
/**** Process variable settings ****/
/* Take only an 8-character file name */
/* stem.pszVariableValue.4 = SUBSTR(stem.pszVariableValue.4,1,8); */
/* stem.pszVariableValue.4 = STRIP(stem.pszVariableValue.4);      */
SAY "New file name is: "stem.pszVariableValue.4;
/* stem.pszVariableValue.8 = SUBSTR(stem.pszVariableValue.8,1,8); */
/* stem.pszVariableValue.8 = STRIP(stem.pszVariableValue.8);      */
SAY "Include file name is: "stem.pszVariableValue.8;
/* Strip any backslashes from the end of the specified target path */
stem.pszTargetDirectory = STRIP(stem.pszTargetDirectory,Trailing,'\');
/* Strip any leading or trailing spaces from numeric variable values */
stem.pszVariableValue.3 = STRIP(stem.pszVariableValue.3);
DAXType = stem.pszVariableValue.3
/* Check for invalid values */
if \((DAXType = "1") | (DAXType = "2")) then
DO
 call ErrorMsg("Invalid application type specified.");
 stem.pszVariableValue.3 = "1"
 rc = RC_NOTOK
END
return;


Cancel:
rcCancel = RxMessageBox("Do you really want to cancel?", , "YesNo", "Query")
if (rcCancel = 6) Then
   call Done(8)
return;

Abort:
parse arg abortMessage
rcAbort = RxMessageBox(abortMessage, , "OK", "Error")
call Done(16);

ErrorMsg:
parse arg errorMsg
rcMsg = RxMessageBox(errorMsg, , "OK", "Error")
return

Done:
arg exitRc
/* Close the installation console. */
rcDone = IwfCloseConsole(stem);
exit(exitRc);



