/*REXX*/

/*   CPDLLSCR.CMD   Project Smarts install script for C++ DLL project
 *
 *   Licensed Materials - Property of IBM
 *
 *   "Restricted Materials of IBM"
 *
 *   IBM WorkFrame
 *
 *   (C) Copyright IBM Corp. 1995. All Rights Reserved.
 *
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with
 *   IBM Corp.
 *
 */


/* Initialize - use a global stem variable. */
stem = "stem"
RC_OK     = 0
RC_NOTOK  = 94
RC_CANCEL = 95


/* Open the installation console. */
rc = IwfOpenConsole(stem);


/* Load the REXX utility functions. */
rc = RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs');
rc = SysLoadFuncs();

/* Extract the passed parameters. */
if (Arg() <> 3) Then
   call Abort("Error in parameter list.");
Parse Arg Proj,Src,Cat;

SAY Cat

/* Initialize the progress, status, and log. */
stem.usPercent     = 0
stem.pszStatusText = "Initializing..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Initializing the Project Smarts install..."
SAY " "

/* Present disclaimers. */
stem.usPercent     = 10
stem.pszStatusText = "Presenting disclaimers..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
line1 = 'DISCLAIMER OF WARRANTIES.  The code that will be installed is '
line2 = 'template code created by IBM Corporation. This code is not '
line3 = 'part of any standard or IBM product and is provided to you solely '
line4 = 'for  the purpose of assisting you in the development of your '
line5 = 'applications.  The code is provided "AS IS", without '
line6 = 'warranty of any kind.  IBM shall not be liable for any damages '
line7 = 'arising out of your use of the sample code, even if they have been '
line8 = 'advised of the possibility of such damages.'
SAY line1||line2||line3||line4||line5||line6||line7||line8
SAY " "

/* Query the target location for the install. */
stem.usPercent     = 30
stem.pszStatusText = "Querying the install location..."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Enter the project name, target directory, and folder for the installation."
/* Set defaults for Location dialog */
env='OS2ENVIRONMENT';                  /* Default target directory */
tmploc = VALUE('tmp',,env)             /* is on TMP variable dir   */  
tmploc = STRIP(tmploc,Trailing,'\');   /* Strip any backslashes at end of path */
Locn = tmploc||'\cpdllprj';
stem.pszTargetProject   = Proj
stem.pszTargetDirectory = Locn
stem.pszTargetFolder    = "Desktop"
do until (rc = RC_OK)
   rc = IwfQueryLocation(stem);
   if (rc  = RC_CANCEL) then call Cancel
   else
   if (rc <> RC_OK) then call Abort("Error querying target information.");
end


/* Set up default variable settings for the installation. */
stem.usPercent     = 40
stem.pszStatusText = "Confirming variable settings..."
stem.usVariableCount = 7
stem.pszVariableName.1        = "Your_Name"
stem.pszVariableDescription.1 = "Your name for the source file prolog."
stem.pszVariableValue.1       = "Your name"
stem.pszVariableName.2        = "Date"
stem.pszVariableDescription.2 = "The date for the source file prolog."
stem.pszVariableValue.2       = Date()
stem.pszVariableName.3        = "File_name"
stem.pszVariableDescription.3 = "The file name for the generated files, for example, CPPDLL."
stem.pszVariableValue.3       = "cppdll"
stem.pszVariableName.4        = "Export_Method"
stem.pszVariableDescription.4 = "Specify the export method you want use:\n1 to export by ordinal \n2 to export by assigned name and ordinal \n3 to export by mangled name"
stem.pszVariableValue.4       = "2";
stem.pszVariableName.5        = "Runtime_library"
stem.pszVariableDescription.5 = "Specify the runtime libraries you want to use:\n1 for single-threaded \n2 for multi-threaded"
stem.pszVariableValue.5       = "1";
stem.pszVariableName.6        = "Custom_Init_Term"
stem.pszVariableDescription.6 = "Specify whether you want to provide your own custom initialization and termination entry point for the DLL:\n1 to use the default \n2 for custom (a template source file is created for you)"
stem.pszVariableValue.6       = "1";
stem.pszVariableName.7        = "Prolog"
stem.pszVariableDescription.7 = "The prolog that appears at the head of all the generated source files."
stem.pszVariableValue.7       = "/* \n * This file was created for %YOUR_NAME% \n * by Project Smarts on %DATE%. \n */";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Confirm the settings of variables used to customize the installation."
/* Restore any saved variable settings */
stem.pszCatalog = Cat;
stem.pszApplication = 'VAPSCPDLL';
rc = IwfRestoreVariables(stem);
if (rc <> RC_OK) then SAY ("Could not restore variable settings. Will use defaults.");
/* Restore date to current date */
stem.pszVariableValue.2 = Date()
/* Display variable settings window */
do until (rc = RC_OK)
   rc = IwfQueryVariables(stem);
   if (rc  = RC_CANCEL) then call Cancel
   else
   if (rc <> RC_OK) then call Abort("Error querying variable settings.");
   call CheckVars;
end
/* Save variable settings */
rc = IwfSaveVariables(stem);
if (rc <> RC_OK) then SAY ("Error saving variable settings.");


/* Strip any backslashes from the end of the specified target path */
stem.pszTargetDirectory = STRIP(stem.pszTargetDirectory,Trailing,'\');

/* Copy the files over, substituting the variable settings. */
stem.usPercent     = 50
stem.pszStatusText = "Copying files, with substitution."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The project source files in" Src "are being copied to" stem.pszTargetDirectory"."
/* Copy the general files */
stem.pszSourceFileMask = Src;
rc = IwfCopyWithSubstitution(stem);
if (rc <> RC_OK) then call Abort("Error performing copy with substitution.");
/* Copy method-specific files */
if (Method = '1') then stem.pszSourceFileMask = Src'\EXPORT'
if (Method = '2') then stem.pszSourceFileMask = Src'\PRAGMA'
if (Method = '3') then stem.pszSourceFileMask = Src'\CPPFILT'
rc = IwfCopyWithSubstitution(stem);
if (rc <> RC_OK) then call Abort("Error performing copy with substitution.");


/* Renaming files */
stem.usPercent     = 60
stem.pszStatusText = "Renaming files."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
curdir = DIRECTORY();
newdir = DIRECTORY(stem.pszTargetDirectory);
rename 'cppdll.* 'stem.pszVariableValue.3'.*'
if (rc <> RC_OK) then call Abort("Error renaming files. The specified file name may be invalid or the disk is full. Please delete any created files and start over.");
/* Delete INITTERM.C if not required */
if (InitTerm <> "2") then 
del 'initterm.c'
/* Restore current directory */
call DIRECTORY curdir;


/* Create the WorkFrame project */
stem.usPercent     = 90;
stem.pszStatusText = "Creating the Workframe/2 project.";
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "The project will be created in "stem.pszTargetFolder;
/* Get the path of the shell projects */
ShellPath = VALUE('CPPMAIN',,env);   /* on CPPMAIN variable path */
if ShellPath='' then call Abort("Error obtaining Project Smarts path.");
ShellPath = ShellPath'\smarts\projects';
if (Library="1") then
DO
  if (Method="3") then stem.pszSourceProject = ShellPath'\CDLL_SDF'
                  else stem.pszSourceProject = ShellPath'\CDLL_SD'
END
if (Library="2") then
DO
  if (Method="3") then stem.pszSourceProject = ShellPath'\CDLL_MDF'
                  else stem.pszSourceProject = ShellPath'\CDLL_MD'
END
SAY "Shell project: "stem.pszSourceProject;
/* If CPPFILT method, must rename def file to BASICDEF */
if (Method='3') then
DO
  curdir = DIRECTORY();
  newdir = DIRECTORY(stem.pszTargetDirectory);
  rename '*.def basicdef'
  /* Restore current directory */
  call DIRECTORY curdir;
END
/* Set up target directory */
pszTarDir = stem.pszTargetDirectory;
stem.pszTargetProjectSetup = 'TARGETNAME='stem.pszVariableValue.3'.dll;MAKEFILENAME='stem.pszVariableValue.3'.mak;PAMLOCATION:IWFBPAM='pszTarDir';PAMDEFAULT:IWFBPAM='pszTarDir';INHERITLIST=<CPPDFTPRJ>;TITLE='stem.pszTargetProject';'
SAY stem.pszTargetProjectSetup;
rc = IwfCreateProjectFromProject(stem)
if (rc <> RC_OK) then call Abort("Error creating project.");


/* Done! */
stem.usPercent     = 100
stem.pszStatusText = "Installation successful."
rc = IwfUpdateConsoleProgress(stem);
rc = IwfUpdateConsoleStatus(stem);
SAY "Done!"
SAY "The installation is complete and was successful."
rc = RxMessageBox("The WorkFrame project has been created.", "Done!", "OK", "Information");


/* We are done. */
call Done(0);



CheckVars:
/**** Process variable settings ****/
/* Take only an 8-character file name */
/* stem.pszVariableValue.3 = SUBSTR(stem.pszVariableValue.3,1,8); */
/* stem.pszVariableValue.3 = STRIP(stem.pszVariableValue.3);      */
SAY "New file name is: "stem.pszVariableValue.3;
/* Strip any leading or trailing spaces from numeric variable values */
stem.pszVariableValue.4 = STRIP(stem.pszVariableValue.4);
stem.pszVariableValue.5 = STRIP(stem.pszVariableValue.5);
stem.pszVariableValue.6 = STRIP(stem.pszVariableValue.6);
Method = stem.pszVariableValue.4;
Library = stem.pszVariableValue.5;
InitTerm = stem.pszVariableValue.6;
/* Check for invalid values */
if \( (Method = "1") | (Method = "2") | (Method = "3") ) then
DO
 call ErrorMsg("Invalid export method specified.");
 stem.pszVariableValue.4 = "2"
 rc = RC_NOTOK
END
if \((library = "1") | (library = "2")) then
DO
 call ErrorMsg("Invalid runtime library choice specified.");
 stem.pszVariableValue.5 = "1"
 rc = RC_NOTOK
END
if \((InitTerm = "1") | (InitTerm = "2")) then
DO
 call ErrorMsg("Invalid Init/Term DLL choice specified.");
 stem.pszVariableValue.6 = "1"
 rc = RC_NOTOK
END  
return;


Cancel:
rcCancel = RxMessageBox("Do you really want to cancel?", , "YesNo", "Query")
if (rcCancel = 6) Then
   call Done(8)
return

Abort:
parse arg abortMessage
rcAbort = RxMessageBox(abortMessage, , "OK", "Error")
call Done(16)

ErrorMsg:
parse arg errorMsg
rcMsg = RxMessageBox(errorMsg, , "OK", "Error")
return

Done:
arg exitRc
/* Close the installation console. */
rcDone = IwfCloseConsole(stem);
exit(exitRc)



