
%PROLOG%

/***************************************************************************/
/*                                                                         */
/* %FILE_NAME% - Skeleton of a basic PM application.  It can serve as a        */
/*           starting point for a program that uses Presentation Manager   */
/*           services.                                                     */
/*                                                                         */
/***************************************************************************/


/*---------------*/
/* Include files */
/*---------------*/
#define INCL_WIN
#define INCL_DOS
#define INCL_DOSFILEMGR
#define INCL_DOSMEMMGR
#define INCL_DOSPROCESS
#define INCL_DOSSESMGR
#define INCL_WINSTDFILE
#define INCL_WINACCELERATORS
#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include "%FILE_NAME%.h"


/***************************************************************************/
/* Main - sets up Presentation Manager services; handles command-line      */
/* arguments.                                                              */
/***************************************************************************/
int main(int argc, char * argv[])

{
 HAB       hab;                                  /* Anchor block handle */
 HMQ       hmq;                                  /* Message queue handle */
 ULONG     flCreateFlags = FCF_TITLEBAR      |   /* Window creation flags  */
                           FCF_SYSMENU       |
                           FCF_SIZEBORDER    |
                           FCF_MINMAX        |
                           FCF_SHELLPOSITION |
                           FCF_TASKLIST      |
                           FCF_MENU          |
                           FCF_ICON          |
                           FCF_ACCELTABLE;           

 QMSG      qmsg;                                 /* Message data structure */
 HWND      hwndClient, hwndFrame;                /* Frame and client window handles */
 TID       tidOpen;                              /* Thread ID of thread to handle file open */
 char      szWinTitle[BUFFERSIZE];               /* String to hold window title */
 PWINDOWINFO pWindowInfo;                        /* Window words */


/*------------------------------------------------------------------*/
/* Standard PM window creation, message loop, and termination.      */
/*------------------------------------------------------------------*/
 hab = WinInitialize (0);

 hmq = WinCreateMsgQueue (hab, 0);

 if (!WinRegisterClass (hab, 
                        WIN_CLASS_NAME,        /* Window class name */
                        fnClientWndProc, 
                        CS_SIZEREDRAW,
                        sizeof (PWINDOWINFO))) /* Window instance data */
      exit(EXIT_FAILURE);

 WinLoadString (hab,        /* Use Desktop's hab */
                NULLHANDLE, /* Use own resources file */
                IDS_TITLE,
                BUFFERSIZE,
                szWinTitle);
 WinSetWindowText (hwndFrame, szWinTitle);

 if (!(hwndFrame = WinCreateStdWindow (HWND_DESKTOP, 
                                       WS_VISIBLE,       /* Frame window style */
                                       &flCreateFlags,   /* window style */
                                       WIN_CLASS_NAME,   /* Class name */
                                       szWinTitle,      /* Window title */
                                       0,                /* Default client style */
                                       NULLHANDLE,       /* Resources in EXE file */
                                       IDW_FRAME_WINDOW, /* Resource/Window ID */
                                       &hwndClient)))    /* Window handle returned */
      exit(EXIT_FAILURE);


 SetupHelp (hwndFrame, hab);      /* Call function to do all help setup */

 if (argc == 2)       /* If user entered the filename on the command line */
    {
     pWindowInfo = (PWINDOWINFO) malloc (sizeof (WINDOWINFO));  /* Allocate window words */

     strcpy (pWindowInfo -> szFileName, argv[1]);   /* Store filename in window words */
     pWindowInfo -> hwnd = hwndClient;              /* Store client window handle */

     /* Create secondary thread to handle file open operation */  
     tidOpen = _beginthread (fnOpenThread,         /* Thread function */
                             NULL,                 /* Reserved */
                             THREAD_STACK_SIZE,
                             (PVOID) pWindowInfo); /* Thread argument pointer */

    }

 while (WinGetMsg (hab, &qmsg, 0, 0, 0))        /* Start message loop */
    WinDispatchMsg (hab, &qmsg);

 if (WinIsWindow (hab, hwndFrame))
    WinDestroyWindow (hwndFrame);

 WinDestroyMsgQueue (hmq);

 WinTerminate (hab);

 return 0;
}


/***************************************************************************/
/* Client window procedure - kicks off a thread to load the user-requested */
/* file.  Also records writes any selected commands to the client area.    */
/* Add other processing as necessary.                                      */
/***************************************************************************/
MRESULT EXPENTRY fnClientWndProc (HWND hwnd, ULONG msg, MPARAM   mp1, MPARAM   mp2)
{
 MRESULT     mr = (MRESULT) FALSE;
 PWINDOWINFO pWindowInfo;    

 switch (msg)
 {
     case WM_CREATE:
     /*--------------------------------------------------------------------*/
     /* Upon creation of the window, allocate, initialize, and store the   */
     /* instance data in window words.  Every message case that uses the   */
     /* instance data must retrieve the address first.                     */
     /*--------------------------------------------------------------------*/
        {
         char      szString[BUFFERSIZE];

         pWindowInfo = (PWINDOWINFO) malloc (sizeof (WINDOWINFO));

         pWindowInfo->hwnd = hwnd;
         strcpy (pWindowInfo->szFileName,"*.*");  /* No file opened yet */

         /* Load string resource for general description text */
         WinLoadString (pWindowInfo->hab, NULLHANDLE, IDS_GENERAL_DESC, BUFFERSIZE, szString);
         strcpy (pWindowInfo->szText, szString);

         WinSetWindowPtr (hwnd, 0, pWindowInfo);
         break;
        }

     case WM_PAINT:
     /*--------------------------------------------------------------------*/
     /* Use this message case to update the window when it needs to be     */    
     /* repainted. Always remember to issue a WinBeginPaint and            */
     /* WinEndPaint. Force this message to be issued by issuing a          */
     /* WinInvalidateRect.                                                 */
     /*--------------------------------------------------------------------*/
        {
         HPS hps;
         RECTL rectClientWindow;

         /* Retrieve instance data */
         pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);

         hps = WinBeginPaint (hwnd, 
                              NULLHANDLE,          /* Get a cache presentation space */
                              &rectClientWindow);  /* Receive update rectangle */

         WinQueryWindowRect (hwnd, &rectClientWindow);  /* Get window rectangle */

         /*======================================================*/
         /* Place program-specific window update processing here */
         /*======================================================*/

         /* Draw background colour */   
         WinFillRect (hps,              
                      &rectClientWindow, 
                      SYSCLR_WINDOW);     /* System window color */

         /* Draw text */
         WinDrawText (hps, 
                      -1,                  /* NULL-terminated string */
                      pWindowInfo->szText,
                      &rectClientWindow,
                      SYSCLR_WINDOWTEXT,   /* System foreground color */
                      SYSCLR_WINDOW,       /* System background color */       
                      DT_CENTER | DT_VCENTER | DT_ERASERECT);        

         WinEndPaint (hps);
         break;
        }

     case WM_COMMAND:

        switch (SHORT1FROMMP(mp1))
        {
            case IDM_FILE_OPEN:
            /*-------------------------------------------------------------*/
            /* When the user selects the File->Open menu item to open a    */
            /* file, display the standard "File open" dialog using         */
            /* WinFileDlg. This accepts a FILEDLG structure, which is      */
            /* initialized to contain the most previous values of the file */
            /* dialog.  This data is kept in the instance data of the      */
            /* window.  Then, a thread is started to open the file and     */
            /* and perform any other program-specific file processing.     */
            /* The name of the file and the client window's handle is      */
            /* passed to the thread to enable communication via messages.  */
            /*-------------------------------------------------------------*/
               {
                PFILEDLG  pFileDlgInfo;
                TID       tidOpen;
                char      szString[BUFFERSIZE];

                /* Retrieve instance data */
                pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);

                /* Load string resources */
                WinLoadString (pWindowInfo->hab, 
                               NULLHANDLE, IDS_FILE_OPEN, BUFFERSIZE,
                               szString);

                /* Allocate and initialize file dialog structure */
                pFileDlgInfo = (PFILEDLG) malloc (sizeof (FILEDLG));

                pFileDlgInfo->cbSize = sizeof(FILEDLG);  /* Size of structure */
                pFileDlgInfo->fl = FDS_CENTER |          /* Behavior flags */
                                   FDS_HELPBUTTON | 
                                   FDS_OPEN_DIALOG;
                pFileDlgInfo->ulUser = 0;                /* No user data */
                pFileDlgInfo->lReturn = 0;               /* Result code - returned */
                pFileDlgInfo->lSRC = 0;                  /* System return code */
                pFileDlgInfo->pszTitle = szString;       /* Dialog title string */

                WinLoadString (pWindowInfo->hab,
                               NULLHANDLE, IDS_OPEN, BUFFERSIZE,
                               szString);
                pFileDlgInfo->pszOKButton = szString;    /* "Open" is OK pushbutton text */

                pFileDlgInfo->pfnDlgProc = (PFNWP)fnFileOpenDlgProc; /* Name of subclassing dialog procedure */
                pFileDlgInfo->pszIType = NULL;           /* No extended attribute type filters */
                pFileDlgInfo->papszITypeList = NULL;
                pFileDlgInfo->pszIDrive = NULL;          /* Initial drive */
                pFileDlgInfo->papszIDriveList = NULL;    /* No specified list of drives */
                pFileDlgInfo->hMod = (HMODULE) NULL;     /* No custom dialog resources */

                /* Specify the initial fully-qualified file name here; */
                /* selected filename is also returned here  */
                strcpy (pFileDlgInfo->szFullFile, pWindowInfo->szFileName);

                pFileDlgInfo->papszFQFilename = NULL;    /* No multiple-file selection */
                pFileDlgInfo->ulFQFCount = 0;            /* Number of files selected */
                pFileDlgInfo->usDlgId = 0;               /* No custom dialog id */
                pFileDlgInfo->x = FDS_CENTER;            /* Display in center of parent */
                pFileDlgInfo->y = FDS_CENTER;
                pFileDlgInfo->sEAType = 0;               /* Not used in Open dialog */

                WinFileDlg (HWND_DESKTOP, hwnd, pFileDlgInfo);

                if (pFileDlgInfo->lReturn == DID_OK)  /* If user pressed "OK" */
                   {
                    strcpy (pWindowInfo->szFileName,     /* Store selected file in window words */
                            pFileDlgInfo->szFullFile);

                    pWindowInfo->hwnd = hwnd;            /* Store hwnd in window words */

                    /* Store text */

                    WinLoadString (pWindowInfo->hab,
                                   NULLHANDLE, /* Use own resources file */
                                   IDS_OPEN_FILE,
                                   BUFFERSIZE,
                                   szString);

                    sprintf (pWindowInfo->szText, szString, pWindowInfo->szFileName);

                    WinInvalidateRect (hwnd, NULL, FALSE);  /* Force a repaint */

                    WinSetWindowPtr (hwnd, 0, pWindowInfo); /* Set window words */


                    /* Create secondary thread to handle file open operation */
                    tidOpen = _beginthread (fnOpenThread,        /* Thread function */
                                            NULL,                /* Reserved */
                                            THREAD_STACK_SIZE,
                                            (PVOID) pWindowInfo); /* Thread argument pointer */
                   }
                free (pFileDlgInfo);
               }
               break;


            case IDM_FILE_CLOSE:
            /*-------------------------------------------------------------*/
            /* User chooses to exit by selecting the File->Close menu item.*/
            /* Post WM_CLOSE to get the message box for confirmation.      */
            /*-------------------------------------------------------------*/
               WinPostMsg (hwnd, WM_CLOSE, 0, 0);
               break;


            case IDM_FILE_SAVE:
            {
               /* Retrieve instance data */
               pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
               WriteText (hwnd, pWindowInfo, IDS_SAVE_FILE, FALSE);
               break;
            }


            case IDM_FILE_SAVEAS:
            /*-------------------------------------------------------------*/
            /* When the user selects the File->Save as menu item to save a */
            /* file, display the standard "Save as" dialog using           */
            /* WinFileDlg. This accepts a FILEDLG structure, which is      */
            /* initialized to contain the currently open file.             */
            /*-------------------------------------------------------------*/
               {
                PFILEDLG  pSaveDlgInfo;
                TID       tidOpen;
                char      szString[BUFFERSIZE];

                /* Retrieve instance data */
                pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);

                /* Allocate and initialize file dialog structure */
                pSaveDlgInfo = (PFILEDLG) malloc (sizeof (FILEDLG));

                pSaveDlgInfo->cbSize = sizeof(FILEDLG);  /* Size of structure */
                pSaveDlgInfo->fl = FDS_CENTER |          /* Behavior flags */
                                   FDS_HELPBUTTON |
                                   FDS_SAVEAS_DIALOG;
                pSaveDlgInfo->ulUser = 0;                /* No user data */
                pSaveDlgInfo->lReturn = 0;               /* Result code - returned */
                pSaveDlgInfo->lSRC = 0;                  /* System return code */

                /* Load string resource for dialog title */                             
                WinLoadString (pWindowInfo->hab,                        
                               NULLHANDLE, /* Use own resources file */ 
                               IDS_SAVEAS,                              
                               BUFFERSIZE,                         
                               szString);                               
                pSaveDlgInfo->pszTitle = szString;       /* Dialog title string */
                /* Load string resource for OK button text */                             
                WinLoadString (pWindowInfo->hab,                        
                               NULLHANDLE, /* Use own resources file */ 
                               IDS_SAVE,                              
                               BUFFERSIZE,                         
                               szString);                               
                pSaveDlgInfo->pszOKButton = szString;    /* Default OK pushbutton text */
                pSaveDlgInfo->pfnDlgProc = fnSaveasDlgProc;   /* Use subclassing dialog procedure */
                pSaveDlgInfo->pszIType = NULL;           /* No extended attribute type filters */
                pSaveDlgInfo->papszITypeList = NULL;
                pSaveDlgInfo->pszIDrive = NULL;          /* Initial drive */
                pSaveDlgInfo->papszIDriveList = NULL;    /* No specified list of drives */
                pSaveDlgInfo->hMod = (HMODULE) NULL;     /* No custom dialog resources */

                /* Specify the fully-qualified name of the loaded file here; */
                /* the selected filename is also returned here.              */
                strcpy (pSaveDlgInfo->szFullFile, pWindowInfo->szFileName);

                pSaveDlgInfo->papszFQFilename = NULL;    /* No multiple-file selection */
                pSaveDlgInfo->ulFQFCount = 0;            /* Number of files selected - returned */
                pSaveDlgInfo->usDlgId = 0;               /* No custom dialog id */
                pSaveDlgInfo->x = FDS_CENTER;            /* Display in center of parent */
                pSaveDlgInfo->y = FDS_CENTER;
                pSaveDlgInfo->sEAType = 0;               /* Not used in Open dialog */

                WinFileDlg (HWND_DESKTOP, hwnd, pSaveDlgInfo);

                if (pSaveDlgInfo->lReturn == DID_OK)  /* If user pressed "OK", i.e. "Save" */
                   {
                    
                    /*================================================*/
                    /* Place processing to save file here.            */
                    /*================================================*/

                    WinLoadString (pWindowInfo->hab,
                                   NULLHANDLE, /* Use own resources file */
                                   IDS_FILE_SAVED,
                                   BUFFERSIZE,
                                   szString);

                    sprintf (pWindowInfo->szText, szString, pWindowInfo->szFileName);

                    WinInvalidateRect (hwnd, NULL, FALSE);  /* Force a repaint */
                   }

                free (pSaveDlgInfo);
               }
               break;


            case IDM_FILE_PRINT:
            {
               /* Retrieve instance data */
               pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
               WriteText (hwnd, pWindowInfo, IDS_PRINT_FILE, FALSE);
               break;
            }


            case IDM_EDIT_UNDO:       
             {
               /* Retrieve instance data */
               pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
               WriteText (hwnd, pWindowInfo, IDS_UNDO, FALSE);
               break;
             }


            case IDM_EDIT_COPY:
             {
               /* Retrieve instance data */
               pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
               WriteText (hwnd, pWindowInfo, IDS_COPY, FALSE);
               break;
             }


            case IDM_EDIT_CUT:        
             {
               /* Retrieve instance data */
               pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
               WriteText (hwnd, pWindowInfo, IDS_CUT, FALSE);
               break;
             }


            case IDM_EDIT_PASTE:
             {
               /* Retrieve instance data */
               pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
               WriteText (hwnd, pWindowInfo, IDS_PASTE, FALSE);
               break;
             }


            case IDM_EDIT_FIND:
             {
               /* Retrieve instance data */
               pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
               WriteText (hwnd, pWindowInfo, IDS_FIND, FALSE);
               break;
             }


            case IDM_EDIT_FINDNEXT:
             {
               /* Retrieve instance data */
               pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
               WriteText (hwnd, pWindowInfo, IDS_FINDNEXT, FALSE);
               break;
             }


            case IDM_HELP_PRODINFO:
            /*------------------------------------------------------------*/
            /* User requests product information by selecting the Product */
            /* Information item from the help pull-down menu.  Display a  */
            /* dialog box with the information.                           */ 
            /*------------------------------------------------------------*/
               WinDlgBox (HWND_DESKTOP,    
                          hwnd,            
                          fnProdInfoWndProc, /* Dialog procedure, below */
                          NULLHANDLE,        /* Resource in EXE */          
                          IDD_PROD_INFO,     /* Dialog id */
                          NULL);             /* No add'l data */

              /* Retrieve instance data */
              pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
              WriteText (hwnd, pWindowInfo, IDS_HELP_PRODINFO, TRUE);
              break;


            case IDM_HELP_INDEX:
            /*------------------------------------------------------------*/
            /* Catch "Help index" message and pass the request on to      */
            /* the help window.                                           */
            /*------------------------------------------------------------*/
            {
              HWND hwndHelp;
        
              hwndHelp = WinQueryHelpInstance (hwnd);
              WinSendMsg (hwndHelp, HM_HELP_INDEX, 0L, 0L);

              /* Retrieve instance data */
              pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
              WriteText (hwnd, pWindowInfo, IDS_HELP_INDEX, TRUE);
              break;
            }


            case IDM_HELP_GENERAL:
            /*------------------------------------------------------------*/
            /* Catch "General help" message and pass the request on to    */
            /* the help window.                                           */
            /*------------------------------------------------------------*/
            {
              HWND hwndHelp;
              USHORT genHelp = IDH_GENHELP_RESNO;

              hwndHelp = WinQueryHelpInstance (hwnd);

              WinSendMsg (hwndHelp, 
                          HM_DISPLAY_HELP, 
                          MPFROMSHORT(genHelp), 
                          MPFROMSHORT(HM_RESOURCEID));

              /* Retrieve instance data */
              pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
              WriteText (hwnd, pWindowInfo, IDS_HELP_GENERAL, TRUE);
              break;
            }


            case IDM_HELP_USING:
            /*------------------------------------------------------------*/
            /* Catch "Using help" message and pass the request on to      */
            /* the help window.                                           */
            /*------------------------------------------------------------*/
            {
              HWND hwndHelp;
 
              hwndHelp = WinQueryHelpInstance (hwnd);
              WinSendMsg (hwndHelp, HM_DISPLAY_HELP, 0L, 0L);

              /* Retrieve instance data */
              pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
              WriteText (hwnd, pWindowInfo, IDS_HELP_USING, TRUE);
              break;
            }



            case IDM_HELP_TUTORIAL:
            /*------------------------------------------------------------*/
            /* Send a message to the help manager to handle the tutorial  */
            /* request so that if the Tutorial is requested from the IPF  */
            /* Help window, the same code to invoke the tutorial is       */
            /* called.                                                    */
            /*------------------------------------------------------------*/
             {
               WinSendMsg (hwnd, HM_TUTORIAL, 0L, 0L);
               break;
             }

          }  /* end switch WM_COMMAND */

          break;  /* WM_COMMAND */


     case UM_FILEERROR:
     /*--------------------------------------------------------------------*/
     /* UM_FILEERROR is posted by the file thread if the file could        */
     /* not be loaded for whatever reason. Notify the user that an error   */
     /* occurred.                                                          */
     /*--------------------------------------------------------------------*/
     {
       char      szString[BUFFERSIZE];
       char      szError[BUFFERSIZE];
       char      szTitle[BUFFERSIZE];

       /* Retrieve instance data */
       pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);

       /* Load string resources */
       WinLoadString (pWindowInfo->hab, NULLHANDLE, IDS_ERROR_OPENING_FILE, 
                      BUFFERSIZE, szString);
       WinLoadString (pWindowInfo->hab, NULLHANDLE, IDS_TITLE,
                      BUFFERSIZE, szTitle);
       sprintf (szError, szString, pWindowInfo->szFileName);

       /* Display message box */
       WinMessageBox (HWND_DESKTOP,
                      hwnd,
                      szError,
                      szTitle,
                      IDW_MESSAGE_BOX,
                      MB_OK | MB_ICONEXCLAMATION | MB_MOVEABLE);
        break;
     }



     case HM_TUTORIAL:
     /*--------------------------------------------------------------------*/
     /* This case handles Help manager's, or this program's own request    */
     /* for tutorial.  If the tutorial program is not already running,     */
     /* start it. A message can be sent to this window, from any part of   */
     /* this program, or from another program, requesting that the tutorial*/
     /* be started.                                                        */
     /*--------------------------------------------------------------------*/
      {
       HAB   hab;

       hab = WinQueryAnchorBlock(hwnd);
       StartTutorial (hwnd, hab);

       /* Retrieve instance data */
       pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
       WriteText (hwnd, pWindowInfo, IDS_HELP_TUTORIAL, TRUE);

       break;
      }


     case UM_FILEOPENED:
     {
       CHAR szString[BUFFERSIZE];

       /* Retrieve instance data */
       pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);

       /* Save text to display in instance data */
       WinLoadString (pWindowInfo->hab, NULLHANDLE, IDS_FILE_OPENED, BUFFERSIZE, szString);
       sprintf (pWindowInfo->szText, szString, pWindowInfo->szFileName);
       WinInvalidateRect (hwnd, NULL, FALSE);  /* Force a repaint */

       break;
     }      


     case WM_CLOSE:
     /*--------------------------------------------------------------------*/
     /* Under WM_CLOSE, pop up a message box confirming that the user      */
     /* wants to end the program. Then post WM_QUIT to terminate.          */
     /*--------------------------------------------------------------------*/
     {
       HAB   hab;
       char  szExit[BUFFERSIZE];
       char  szTitle[BUFFERSIZE];

       hab = WinQueryAnchorBlock(hwnd);

       /* Load string resources */
       WinLoadString (hab, NULLHANDLE, IDS_EXIT, BUFFERSIZE, szExit);
       WinLoadString (hab, NULLHANDLE, IDS_TITLE, BUFFERSIZE, szTitle);

       if (WinMessageBox (HWND_DESKTOP, 
                          hwnd,
                          szExit,
                          szTitle,
                          IDW_MESSAGE_BOX,
                          MB_YESNO | MB_ICONQUESTION | MB_MOVEABLE)
             == MBID_YES)
              WinPostMsg (hwnd, WM_QUIT, 0, 0);

        break;
     }

     case WM_DESTROY:
     /*====================================================================*/
     /* Perform any final clean up work here.                              */
     /*====================================================================*/
     {
        /* Destroy and disassociate help instance */
        HWND hwndHelp;

        hwndHelp = WinQueryHelpInstance (hwnd);
        WinDestroyHelpInstance (hwndHelp);
        WinAssociateHelpInstance (NULLHANDLE, hwnd);

        /* Retrieve and free memory allocated for instance data */
        pWindowInfo = (PWINDOWINFO) WinQueryWindowPtr (hwnd, 0);
        free (pWindowInfo);

        break;
      }

     default:

        mr = WinDefWindowProc (hwnd, msg, mp1, mp2);
        break;
    }   /* Endswitch msg */ 

 return mr;
}   /* End of function */



/***************************************************************************/
/* fnOpenThread is the file-open routine. It opens the file, and returns   */
/* with an error if the file could not be opened.  You could add further   */
/* processing like querying the file information, or loading the file into */
/* memory here.  Any file information can be returned to the main thread   */
/* via a message.                                                          */
/* Parameters:                                                             */
/*     PVOID pInfo - Pointer to client window instance data. Thread        */
/*                   function parameters must always be PVOID.             */
/***************************************************************************/
VOID fnOpenThread (PVOID pInfo)
{
 HFILE        hFile;                  /* File handle of file opened */
 ULONG        ulAction;               /* Action taken by DosOpen */
 CHAR         szFileName[CCHMAXPATH]; /* File to open */
 HWND         hwnd;
 ULONG        ulmsg;                  /* Message to send to client window */
 APIRET       rc;                     /* Return code for DosOpen */
 PWINDOWINFO  pOpenInfo;   

 pOpenInfo = (PWINDOWINFO)pInfo;
 strcpy (szFileName, pOpenInfo->szFileName); /* Get file name to open */
 hwnd = pOpenInfo->hwnd;                     /* Get calling thread's hwnd */

 ulmsg = UM_FILEERROR;                         /* Set message error flag */

 /* Open file */

 rc = DosOpen (szFileName, 
               &hFile, 
               &ulAction, 
               0L,                         
               0L,
               OPEN_ACTION_FAIL_IF_NEW |    /* Open flags */
               OPEN_ACTION_OPEN_IF_EXISTS,
               OPEN_SHARE_DENYWRITE |       /* Access flags */
               OPEN_ACCESS_READONLY,        
               0L);                /* No extended attributes buffer */
 if (rc) 
    ulmsg = UM_FILEERROR;    /* DosOpen failed. Send error msg to main thread */
 else
 {
    /*==================================*/
    /* Add any further processing here  */
    /*==================================*/

    ulmsg = UM_FILEOPENED;   /* DosOpen successful. Send success msg to main thread */
    DosClose (hFile);        /* Close file for now */
 }

 /* Post msg to main thread. A pointer to encoded */          
 /* info could be passed as a msg parameter       */          
 WinPostMsg (hwnd, ulmsg, 0, 0);  
                                          
 _endthread();
}



/****************************************************************************/
/* Dialog procedure for the Product Information dialog.  It processes the   */
/* OK push button to dismiss the dialog.  The rest of the messages go to    */
/* default processing.                                                      */
/****************************************************************************/
MRESULT APIENTRY fnProdInfoWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
 MRESULT mr = 0;      /* Result code */
 HWND hwndOK;         /* Window handle of OK push button */
 BOOL fSucc;

 switch (msg)
    {
    /* If the user hits OK, use WinDismissDlg to return TRUE to the main      */
    /* window procedure.  Otherwise, return FALSE.  This value is picked up   */
    /* as the return value of WinDlgBox.                                      */

     case WM_COMMAND:

        switch (SHORT1FROMMP (mp1))
           {
            case IDP_PRODINFO_OK:

               WinDismissDlg (hwnd,   /* Dialog Window Handle */
                              TRUE);  /* OK button is TRUE */  
               break;

            default:
               mr = WinDefDlgProc(hwnd, msg, mp1, mp2);
               break;
           }
        break;

     /* Let the default dialog box window procedure handle any other messages  */
     /* for this dialog.                                                       */
     default:
        mr = WinDefDlgProc (hwnd, msg, mp1, mp2);
        break;
    }
 return (mr);
}



/********************************************************************/
/* Writes text on the window giving feedback for selected commands  */
/* Parameters:                                                      */
/*     HWND        hwnd        - Window handle of client window     */
/*     PWINDOWINFO pWindowInfo - Instance data for client window    */
/*     ULONG       ulStringID  - Resource ID of string to display   */
/*     BOOL        fHelp       - TRUE if command is a Help command  */
/*                               FALSE otherwise                    */ 
/********************************************************************/
VOID WriteText (HWND hwnd, PWINDOWINFO pWindowInfo, ULONG ulStringID, BOOL fHelp)
{
  CHAR szString[BUFFERSIZE];     /* String buffer to hold loaded string resource */
  RECTL rectClientWindow;

  /*---------------------------------------------------------------------------*/ 
  /* If the selected command is a help command, write the text unconditionally.*/
  /* Otherwise, check first whether a file has been loaded before writing the  */
  /* text.  Display an error message if no file has been loaded.               */ 
  /*---------------------------------------------------------------------------*/
  if (strcmp(pWindowInfo->szFileName,"*.*") || fHelp)
   {
     WinLoadString (pWindowInfo->hab,
                    NULLHANDLE, /* Use own resources file */
                    ulStringID,
                    BUFFERSIZE,
                    szString);

     sprintf (pWindowInfo->szText, szString, pWindowInfo->szFileName);

     WinQueryWindowRect (hwnd, &rectClientWindow);        /* Get window rectangle */
     WinInvalidateRect (hwnd, &rectClientWindow, FALSE);  /* Force a repaint */
    }
   else
    /* Procedure to display error dialog */
    DlgFileNotLoaded (hwnd, pWindowInfo);
}



/*****************************************************************/
/* Display "File not loaded" message box.                        */
/* Parameters:                                                   */
/*     HWND        hwnd        - Window handle of client window  */
/*     PWINDOWINFO pWindowInfo - Instance data for client window */
/*****************************************************************/
VOID DlgFileNotLoaded (HWND hwnd, PWINDOWINFO pWindowInfo)
{
  CHAR  szError[BUFFERSIZE];
  CHAR  szTitle[BUFFERSIZE];

  /* Load string resources */
  WinLoadString (pWindowInfo->hab,
                 NULLHANDLE, /* Use own resources file */
                 IDS_ERROR_NO_FILE_LOADED,
                 BUFFERSIZE,
                 szError);

  WinLoadString (pWindowInfo->hab,
                 NULLHANDLE, /* Use own resources file */
                 IDS_TITLE,
                 BUFFERSIZE,
                 szTitle);

  /* Display message box */
  WinMessageBox (HWND_DESKTOP,
                 hwnd,
                 szError,
                 szTitle,
                 IDW_MESSAGE_BOX,
                 MB_OK | MB_ICONEXCLAMATION | MB_MOVEABLE);
}



/**************************************************************************/     
/* Help manager initialization and preparation. Set up the HELPINIT       */     
/* structure.                                                             */     
/* Parameters:                                                            */
/*   HWND hwnd - Window handle of client window                           */
/*   HAB  hab  - Anchor block handle                                      */
/**************************************************************************/     
VOID SetupHelp (HWND hwnd, HAB hab)
{                                                                                  
 HWND     hwndHelp;
 HELPINIT mainHelp;
 CHAR     szString[BUFFERSIZE];
 CHAR     szTitle[BUFFERSIZE];

 mainHelp.cb = sizeof (HELPINIT);      /* Standard size of structure */             
 mainHelp.ulReturnCode = 0;            /* Return code - indicates error if non-zero */
 mainHelp.pszTutorialName = NULL;      /* Tutorial commmand */
 mainHelp.phtHelpTable = (PHELPTABLE)MAKEULONG (IDH_MAIN_HELPTABLE, 0xFFFF); /* Help table ID in resources */ 
 mainHelp.hmodHelpTableModule = NULLHANDLE;  /* Help table resource in EXE */
 mainHelp.hmodAccelActionBarModule = NULLHANDLE; /* No add'l help resources */
 mainHelp.idAccelTable = 0;         /* No add'l help accelerator */
 mainHelp.idActionBar = 0;          /* Use default action bar */
                                                                                  
 WinLoadString (hab, NULLHANDLE, IDS_TITLE, BUFFERSIZE, szTitle); 
 mainHelp.pszHelpWindowTitle = szTitle;     /* Help manager window title */
                                                                                  
 mainHelp.fShowPanelId = CMIC_HIDE_PANEL_ID; /* Don't show panel res numbers */
 mainHelp.pszHelpLibraryName = HELP_FILE_NAME;  /* Name of HLP file */
                                                                                  
 /* Create the help window for this program. If it could not be created,   */     
 /* or if another help error occurred, notify the user.  A failure would   */     
 /* not be fatal; an application can function without help.                */     
                                                                                  
 hwndHelp = WinCreateHelpInstance (hab, &mainHelp);                                 

 if (!hwndHelp)   /* Couldn't create help window */
 {
    WinLoadString (hab, NULLHANDLE, IDS_ERROR_CREATING_HELP, BUFFERSIZE, szString);
    WinMessageBox (HWND_DESKTOP, 
                   hwnd, 
                   szString,                      
                   szTitle,
                   IDW_MESSAGE_BOX, 
                   MB_OK | MB_MOVEABLE);                         
 }
 else                                                                             
 {
    if (mainHelp.ulReturnCode)   /* Couldn't initialize help */
       {                                                                          
        WinLoadString (hab, NULLHANDLE, IDS_ERROR_NO_HELP, BUFFERSIZE, szString);
        WinMessageBox (HWND_DESKTOP, 
                       hwnd, 
                       szString,
                       szTitle,
                       IDW_MESSAGE_BOX, 
                       MB_OK | MB_MOVEABLE);                     

        WinDestroyHelpInstance (hwndHelp);                                        
        hwndHelp = NULLHANDLE;                                                            
       }                                                                          
    else                                                                          
       WinAssociateHelpInstance (hwndHelp, hwnd);                            
 }                                                                                 
}



/**************************************************************************/
/* Start the tutorial program VIEW.EXE to view the tutorial INF file      */
/* using DosStartSession().                                               */
/* Parameters:                                                            */
/*   HWND hwnd - Window handle of client window                           */
/*   HAB  hab  - Anchor block handle                                      */
/**************************************************************************/
VOID StartTutorial(HWND hwnd, HAB hab)
{
  STARTDATA StartData;                           /* Start session data structure */
  ULONG     SessID;                              /* Session ID - returned */
  PID       PID;                                 /* Process ID - returned */
  CHAR      szString[BUFFERSIZE];                /* String buffer */
  CHAR      szTitle[BUFFERSIZE];                 /* Buffer to hold application title */
  CHAR      bResultBuf[BUFFERSIZE];               /* Result buffers for searches */
  CHAR      bPathBuf1[BUFFERSIZE];                
  CHAR      bPathBuf2[BUFFERSIZE];                
  CHAR      szObjectBuffer[BUFFERSIZE];                /* Object buffer */
  CHAR      szHelpTutorialBuffer[BUFFERSIZE] = {'\0'}; /* Used to build tutorial path for VIEW */

  WinLoadString (hab, NULLHANDLE, IDS_TITLE, BUFFERSIZE, szTitle);

  /* Check whether tutorial viewer program, VIEW.EXE, and its supporting program, */
  /* VIEWDOC.EXE is present along the PATH.                                       */
  _searchenv (TUTORIAL_PROGRAM, "PATH", bPathBuf1);
  _searchenv (TUTORIAL_PROGRAM2,"PATH", bPathBuf2);
 
  if ( !(strcmp (bPathBuf1,"") && strcmp (bPathBuf2,"")) )
   {
      WinLoadString (hab, NULLHANDLE, IDS_ERROR_VIEW_NOT_FOUND, BUFFERSIZE, szString);
      WinMessageBox (HWND_DESKTOP,
                     hwnd,
                     szString,
                     szTitle,
                     IDW_MESSAGE_BOX,
                     MB_OK | MB_MOVEABLE);
      return;
   }

  /* Check whether tutorial INF file is present along the HELP path */
  _searchenv (TUTORIAL_FILE, "HELP", bResultBuf);
  if (!strcmp(bResultBuf, "")) 
   {
      WinLoadString (hab, NULLHANDLE, IDS_ERROR_NO_TUTORIAL, BUFFERSIZE, szString);
      WinMessageBox (HWND_DESKTOP,
                     hwnd,
                     szString,
                     szTitle,
                     IDW_MESSAGE_BOX,
                     MB_OK | MB_MOVEABLE);
      return;
   }

  /* Initialize the start session structure */
  StartData.Length   = sizeof(STARTDATA);   /* Length of STARTDATA structure */
  StartData.Related  = SSF_RELATED_CHILD;   /* Child session */
  StartData.FgBg     = SSF_FGBG_FORE;       /* Start child session in foreground */
  StartData.TraceOpt = SSF_TRACEOPT_NONE;   /* Do not trace session */
  WinLoadString (hab, NULLHANDLE, IDS_TUTORIAL_TITLE, BUFFERSIZE, szString);
  StartData.PgmTitle = (PSZ)szString;       /* Session Title string */
  StartData.PgmName  = TUTORIAL_PROGRAM;    /* Tutorial program path name */

  /*-----------------------------------------------------------------------------*/
  /* Pass the tutorial INF file name as input arguments to the VIEW program.     */
  /* Single and then double quote the filename in case the file name is specified*/
  /* as a list of files concatenated with plus (+) signs.  Otherwise the VIEW    */
  /* program interprets the file name as one long file name with plus signs.     */
  /*-----------------------------------------------------------------------------*/
  strcpy(szHelpTutorialBuffer,"\'\"");	   /* Single followed by double quote */
  strcat(szHelpTutorialBuffer,bResultBuf); /* Fully-qualified tutorial filename found above */
  strcat(szHelpTutorialBuffer,"\"\'");     /* Double followed by single quote */
  StartData.PgmInputs   = (PBYTE)szHelpTutorialBuffer;

  StartData.TermQ       = 0;               /* Assume no termination queue  */
  StartData.Environment = 0;               /* Assume no environment string */

  /* Inherit environment and open file handles from parent */
  StartData.InheritOpt  = SSF_INHERTOPT_PARENT;

  StartData.SessionType = SSF_TYPE_DEFAULT;    /* Let Shell establish session type */
  StartData.IconFile    = 0;                   /* No specific icon file provided */
  StartData.PgmHandle   = 0;                   /* Do not use the installation file */
  StartData.PgmControl  = SSF_CONTROL_VISIBLE; /* Start program visible and maximized */

  /* Initial window coordinates and size */
  StartData.InitXPos    = 30;
  StartData.InitYPos    = 40;
  StartData.InitXSize   = 0;
  StartData.InitYSize   = 0;

  StartData.Reserved      = 0;                     /* Reserved, must be zero */
  StartData.ObjectBuffer  = (PSZ)szObjectBuffer;   /* Buffer to hold failure causes */
  StartData.ObjectBuffLen = sizeof(szObjectBuffer);

  /*----------------------------------------------------------------------*/
  /* On successful return, the variable SessID contains the session ID    */
  /* of the new session, and the variable PID contains the process ID     */
  /* of the new process.                                                  */
  /*----------------------------------------------------------------------*/
  if (DosStartSession(&StartData, &SessID, &PID))
  {
    WinLoadString (hab, NULLHANDLE, IDS_ERROR_STARTING_TUTORIAL, BUFFERSIZE, szString);

    WinMessageBox (HWND_DESKTOP,
                   hwnd,
                   szString,
                   szTitle,
                   IDW_MESSAGE_BOX,
                   MB_OK | MB_MOVEABLE);
    return;
  }
}



/***************************************************************************/
/* Custom window procedure for FileOpen dialog.  This subclassed procedure */
/* captures the Help pushbutton message and displays the appropriate help. */
/***************************************************************************/
MRESULT EXPENTRY fnFileOpenDlgProc (HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{ 
  MRESULT mr = (MRESULT) TRUE;  /* Result code for dialog procedure */

  switch (msg) 
  {
     case WM_HELP:
     {
       HWND   hwndHelp;                      /* Help instance window handle */
       HWND   hwndOwner;                     /* Window handle of main window */
       USHORT usResNo = IDH_FILEOPEN_RESNO;  /* Help panel res ID for file open dialog */

       hwndOwner = WinQueryWindow (hwndDlg, QW_OWNER);  /* Get parent's window handle */
       hwndHelp = WinQueryHelpInstance (hwndOwner);     /* Get help instance */

       if (WinAssociateHelpInstance (hwndHelp, hwndDlg))
          WinSendMsg (hwndHelp,
                      HM_DISPLAY_HELP,
                      MPFROMSHORT(usResNo),
                      MPFROMSHORT(HM_RESOURCEID));
       else
       {
          CHAR szString[BUFFERSIZE];   /* Buffer for message box text */
          CHAR szTitle[BUFFERSIZE];    /* Buffer for message box title */
          HAB hab;

          hab = WinQueryAnchorBlock(hwndDlg);
          WinLoadString (hab, NULLHANDLE, IDS_ERROR_HELP_ASSOC, BUFFERSIZE, szString);
          WinLoadString (hab, NULLHANDLE, IDS_FILE_OPEN, BUFFERSIZE, szTitle);
          WinMessageBox (HWND_DESKTOP,
                         hwndDlg,
                         szString,
                         szTitle,
                         IDW_MESSAGE_BOX,
                         MB_OK | MB_MOVEABLE);
       }
       break;
     }

     default: 
     {
       mr = WinDefFileDlgProc(hwndDlg, msg, mp1, mp2);  /* Let default dlg proc handle the rest */
       break;
     }
  } /* endswitch */

  return mr;
}    



/****************************************************************************/
/* Custom window procedure for "Save as" dialog.  This subclassed procedure */
/* captures the Help pushbutton message and displays the appropriate help.  */
/****************************************************************************/
MRESULT EXPENTRY fnSaveasDlgProc (HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  MRESULT mr = (MRESULT) TRUE;      /* Result code for dialog procedure */

  switch (msg)
  {
     case WM_HELP:
     {
       HWND   hwndHelp;                   /* Help instance window handle */
       HWND   hwndOwner;                  /* Window handle of main window */
       USHORT usResNo = IDH_SAVEAS_RESNO; /* Help panel res ID for file open dialog */

       hwndOwner = WinQueryWindow (hwndDlg, QW_OWNER);  /* Get parent's window handle */
       hwndHelp = WinQueryHelpInstance (hwndOwner);     /* Get help instance */

       if (WinAssociateHelpInstance (hwndHelp, hwndDlg))
          WinSendMsg (hwndHelp,
                      HM_DISPLAY_HELP,
                      MPFROMSHORT(usResNo),
                      MPFROMSHORT(HM_RESOURCEID));
       else
       {
          CHAR szString[BUFFERSIZE];   /* Buffer for message box text  */
          CHAR szTitle[BUFFERSIZE];    /* Buffer for message box title */
          HAB hab; 

          hab = WinQueryAnchorBlock(hwndDlg);
          WinLoadString (hab, NULLHANDLE, IDS_ERROR_HELP_ASSOC, BUFFERSIZE, szString);
          WinLoadString (hab, NULLHANDLE, IDS_SAVEAS, BUFFERSIZE, szTitle);
          WinMessageBox (HWND_DESKTOP,
                         hwndDlg,
                         szString,
                         szTitle,
                         IDW_MESSAGE_BOX,
                         MB_OK | MB_MOVEABLE);
       }
       break;
     }
     default:
     {
       mr = WinDefFileDlgProc(hwndDlg, msg, mp1, mp2);  /* Let default dlg proc handle the rest */
       break;
     }
  } /* endswitch */

  return mr;
}


