
%PROLOG%

#include "prodinfo.hpp"
#include "%FILE_NAME%.h"

/****************** ProdInfoDialog Implementation *******************/


/***********************************************************/
/* Constructor for the product information dialog class.   */
/***********************************************************/
ProdInfoDialog :: ProdInfoDialog (IWindow *owner) 
   : IFrameWindow( IResourceId(IDD_PROD_INFO), owner)
{
   // Set self as command event handler
   handleEventsFor(this);

   // Show the dialog
   setFocus();               
   show();                  

}


/***********************************************************/
/* Destructor for the product information dialog class.    */
/***********************************************************/
ProdInfoDialog :: ~ProdInfoDialog()
{
   stopHandlingEventsFor(this);
}



/***********************************************************/
/* Command handler function for the product information    */
/* dialog. There is only one control to handle.            */
/***********************************************************/
Boolean ProdInfoDialog :: command( ICommandEvent& cmdevt)
{
  switch ( cmdevt.commandId() ) 
  {
     case IDP_PRODINFO_OK:
        dismiss(IDP_PRODINFO_OK);
        return true;
  } 

  return false;
}


