
%PROLOG%

#include "openfile.hpp"
#include "%FILE_NAME%.hpp"

/****************** AppOpenFileFn Implementation **********************/


/***********************************************************/
/* Constructor for the file open thread function class. It */
/* takes a single AppWindow argument and simply stores a   */
/* pointer to the AppWindow as private data.               */
/***********************************************************/
AppOpenFileFn :: AppOpenFileFn (AppWindow *window)
{
  appWindow = window;
}


/***********************************************************/
/* Overriding run() method for the file open thread        */
/* function class.  This function is called implicitly     */
/* when a thread to open a file is dispatched.             */
/***********************************************************/
void AppOpenFileFn :: run()
{
  appWindow->openFile();
}

