
%PROLOG%

class AppWindow;
class IMsgBox;

/*************************************************/
/* Class: AppMessageBox                          */
/*                                               */
/* Purpose: Emulates IMessageBox to use a        */
/*          consistent title and so that the     */
/*          application doesn't trap when a      */
/*          message box with a help button is    */
/*          displayed and there is no help       */
/*          available.                           */
/*************************************************/
class AppMessageBox 
{
  public:

    // Constructor simply takes an AppWindow class pointer 
    //------
    AppMessageBox (AppWindow *window);
    ~AppMessageBox ();


    // Override the show overloaded function so that the message
    // box is shown whether or not help is available.
    //------
    IMessageBox::Response show( const char *aMessage,
                                const IMessageBox::Style &aStyle,
                                unsigned long aHelpId = 0);
    
    IMessageBox::Response show( const char *aMessage,
                                const IMessageBox::Severity aSeverity,
                                unsigned long aHelpId = 0);
    
    IMessageBox::Response show( const IResourceId &aResId,
                                const IMessageBox::Severity aSeverity,
                                unsigned long aHelpId = 0);
    
    IMessageBox::Response show( const IResourceId &resId,
                                const IMessageBox::Style aStyle,
                                unsigned long aHelpId = 0);
    
    IMessageBox::Response show( const IException &aException,
                                unsigned long aHelpId = 0);
    
    IMessageBox::Response show( const IErrorInfo &aError,
                                unsigned long aHelpId = 0);
    
  private:
  
    AppWindow*    appWindow;
    IMessageBox*  msgBox;
};

