
%PROLOG%

#include <imsgbox.hpp>
#include <ireslib.hpp>

#include "msgbox.hpp"
#include "%FILE_NAME%.hpp"
#include "%FILE_NAME%.h"


/****************** AppMessageBox Implementation **********************/


/***********************************************************/
/* Constructor for own message box class.  It takes an     */
/* application window as its only argument, then creates a */
/* message box that contains the standard application title*/
/***********************************************************/
AppMessageBox :: AppMessageBox (AppWindow *window)
{
  appWindow = window;
  msgBox = new IMessageBox( appWindow);
  msgBox->setTitle( IResourceId(IDW_FRAME_WINDOW));
}


/***********************************************************/
/* Destructor for own message box class.  It deletes the   */
/* allocated message box object.                           */
/***********************************************************/
AppMessageBox :: ~AppMessageBox ()
{
  delete msgBox;
}


/***********************************************************/
/* Emulates the show method of IMessage box, only it       */
/* checks whether help is available and calls it           */
/* appropriately.                                          */
/***********************************************************/
IMessageBox::Response AppMessageBox :: show ( const char *aMessage,
                                              const IMessageBox::Style &aStyle,
                                              unsigned long aHelpId)
{
  if ( appWindow->isHelpAvailable() )
    return ( msgBox->show( aMessage, aStyle, aHelpId) );
  else 
    return ( msgBox->show( aMessage, aStyle) );
}


/***********************************************************/
/* Emulates the show method of IMessage box, only it       */
/* checks whether help is available and calls it           */
/* appropriately.                                          */
/***********************************************************/
IMessageBox::Response AppMessageBox :: show( const char *aMessage,
                                             const IMessageBox::Severity aSeverity,
                                             unsigned long aHelpId)
{
  if ( appWindow->isHelpAvailable() )
    return ( msgBox->show( aMessage, aSeverity, aHelpId) );
  else 
    return ( msgBox->show( aMessage, aSeverity) );
}


/***********************************************************/
/* Emulates the show method of IMessage box, only it       */
/* checks whether help is available and calls it           */
/* appropriately.                                          */
/***********************************************************/
IMessageBox::Response AppMessageBox :: show( const IResourceId &aResId,
                                             const IMessageBox::Severity aSeverity,
                                             unsigned long aHelpId)
{
  if ( appWindow->isHelpAvailable() )
    return ( msgBox->show( aResId, aSeverity, aHelpId) );
  else 
    return ( msgBox->show( aResId, aSeverity) );
}


/***********************************************************/
/* Emulates the show method of IMessage box, only it       */
/* checks whether help is available and calls it           */
/* appropriately.                                          */
/***********************************************************/
IMessageBox::Response AppMessageBox :: show( const IResourceId &aResId,
                                             const IMessageBox::Style aStyle,
                                             unsigned long aHelpId)
{
  if ( appWindow->isHelpAvailable() )
    return ( msgBox->show( aResId, aStyle, aHelpId) );
  else 
    return ( msgBox->show( aResId, aStyle) );
}


/***********************************************************/
/* Emulates the show method of IMessage box, only it       */
/* checks whether help is available and calls it           */
/* appropriately.                                          */
/***********************************************************/
IMessageBox::Response AppMessageBox :: show( const IException &aException,
                                             unsigned long aHelpId)
{
  if ( appWindow->isHelpAvailable() )
    return ( msgBox->show( aException, aHelpId) );
  else 
    return ( msgBox->show( aException) );
}
    

/***********************************************************/
/* Emulates the show method of IMessage box, only it       */
/* checks whether help is available and calls it           */
/* appropriately.                                          */
/***********************************************************/
IMessageBox::Response AppMessageBox :: show( const IErrorInfo &aError,
                                             unsigned long aHelpId)
{
  if ( appWindow->isHelpAvailable() )
    return ( msgBox->show( aError, aHelpId) );
  else 
    return ( msgBox->show( aError) );
}



