
%PROLOG%

#include <iframe.hpp>
#include <icmdhdr.hpp>
#include <istring.hpp>
#include <imenubar.hpp>
#include <icanvas.hpp>
#include <istattxt.hpp>

#include "helphdlr.hpp"

class IHelpWindow;

/*************************************************/
/* Class: AppWindow                              */
/*                                               */
/* Purpose: Main window for an ICLUI application */
/*          It is a subclass of IFrameWindow     */
/*          and ICommandHandler.                 */
/*************************************************/
class AppWindow : public IFrameWindow, 
                  public ICommandHandler
{

  // Declare friendship with the AppOpenFileFn class which encapsulates
  // a thread function that executes a member function of this class
  //-------
  friend class AppOpenFileFn;


  public:

    // Constructor and destructor
    //------
    AppWindow( unsigned long windowId);
    ~AppWindow();

    // Returns true if help is available
    //------
    virtual Boolean isHelpAvailable() const;


  protected:

    // Command event handler function
    //------
    Boolean command(ICommandEvent& cmdevt);

    // Opens the requested file and returns true if the file 
    // was opened successfully
    //------
    virtual Boolean openFile();

    // Returns true if a file has already been opened
    //------
    virtual Boolean isFileOpen() const;

  private:

    // Shows product information dialog  
    //------
    virtual void productInfo();

    // Overloaded function.  Checks whether a file has been opened 
    // then displays an error message or writes text to the status line.
    // Returns true if no error message was displayed.
    //------
    virtual Boolean writeStatus( const IResourceId status,  
                                 const Boolean isHelpCmd = false);
    virtual Boolean writeStatus( const IString &status, 
                                 const Boolean isHelpCmd = false);
    
    IString         openFileName; // Name of file opened

    IMenuBar        menuBar;      // Window menu bar

    ICanvas         canvas;       // Client area canvas.  You can change
                                  // this to any other canvas class
                                  // (like ISplitCanvas) or client
                                  // area control (like a container).

    IStaticText     statusLine;   // Status information text
 
    IHelpWindow*    help;         // Help window

    AppHelpHandler* helpHdlr;     // Help events handler

    Boolean         hasHelp;      // Help available flag

    /*=====================================================*/
    /*  Add any other window controls here.                */
    /*=====================================================*/

 };



