
%PROLOG%

#include <ihelphdr.hpp>
#include <ihelp.hpp>

#define INCL_WINHELP        //  For WM_HELP message
#include <os2.h>

class IHelpTutorialEvent;

/*************************************************/
/* Class: AppHelpHandler                         */
/*                                               */
/* Purpose: Subclass of IHelpHandler so that the */
/*          correct tutorial can be displayed    */
/*          when tutorial help is requested from */
/*          the Help pulldown menu of AppWindow. */
/*************************************************/
class AppHelpHandler : public IHelpHandler
 {

  protected:

     // Override this handler function to display the tutorial
     //------
     virtual Boolean showTutorial( IHelpTutorialEvent &tutorialEvent);

  };


/*************************************************/
/* Class: FileDlgHelpHandler                     */
/*                                               */
/* Purpose: Subclass of IHelpHandler. This is    */
/*          so that the correct help is displayed*/
/*          from the File open and Save as       */
/*          dialogs.  It is only active when     */
/*          one of these dialogs is up.  It      */
/*          should be constructed just before    */
/*          showing an IFileDialog window with   */
/*          the resource ID of the correct help  */
/*          to show (depending on whether the    */
/*          window is a File open or Save as     */
/*          dialog.                              */
/*************************************************/
class FileDlgHelpHandler : public IHelpHandler
 {
  public:

     // Constructor
     FileDlgHelpHandler ( IHelpWindow* h, unsigned long r)
       : help(h), resId(r) { }

  protected:
 
     // Override the dispatcher function to display the correct help
     // panel when help is requested to an IFileDialog window.
     //------
     virtual Boolean dispatchHandlerEvent( IEvent &evt)
     {
        if ( evt.eventId() == WM_HELP ) 
        {
           help->show( IResourceId( resId ) );
           return true;
        }
        else 
           return false;        // Pass on to next handler
     }

  private:
 
     IHelpWindow* help;         // Help window instance
     unsigned long resId;       // Resource Id of help panel to show.
                                // (Specified at construction time.)

  };




