
%PROLOG%

#include <ihelphdr.hpp>
#include <ireslib.hpp>
#include <imsgbox.hpp>

#define INCL_DOSSESMGR      //  For DosStartSession
#define INCL_WINHELP        //  For HM_TUTORIAL message
#include <os2.h>

#include "helphdlr.hpp"
#include "%FILE_NAME%.h"

/****************** AppHelpHandler Implementation **********************/


/***********************************************************/
/* This function handles the show Tutorial request by      */
/* using DosStartSession to start VIEW.EXE on the tutorial */
/* INF file.                                               */
/***********************************************************/
Boolean AppHelpHandler :: showTutorial( IHelpTutorialEvent &tutorialEvent )
{
  IResourceLibrary resLib;           /* Resource library */

  STARTDATA StartData;               /* Start session data structure */
  ULONG     SessID;                  /* Session ID - returned */
  PID       PID;                     /* Process ID - returned */
  CHAR      bResultBuf[BUFFERSIZE];  /* Result buffers for searches */
  CHAR      bPathBuf1[BUFFERSIZE];                
  CHAR      bPathBuf2[BUFFERSIZE];                
  CHAR      szObjectBuffer[BUFFERSIZE];                /* Object buffer */
  CHAR      szHelpTutorialBuffer[BUFFERSIZE] = {'\0'}; /* Tutorial path name */

  /* Check whether tutorial viewer program, VIEW.EXE, and its supporting program, */
  /* VIEWDOC.EXE is present along the PATH.                                       */
  _searchenv (TUTORIAL_PROGRAM, "PATH", bPathBuf1);
  _searchenv (TUTORIAL_PROGRAM2,"PATH", bPathBuf2);
 
  if ( !(strcmp (bPathBuf1,"") && strcmp (bPathBuf2,"")) )
   {
      /* Display error message - can't find VIEW.EXE */
      IMessageBox errorMsg( tutorialEvent.window() );
      errorMsg.setTitle( IResourceId(IDW_FRAME_WINDOW));
      errorMsg.show( IResourceId(IDS_ERROR_VIEW_NOT_FOUND),
                     IMessageBox::catastrophic);
      return true;
   }

  /* Check whether tutorial INF file is present along the HELP path */
  _searchenv (TUTORIAL_FILE, "HELP", bResultBuf);
  if (!strcmp(bResultBuf, "")) 
   {
      /* Display error message - can't find tutorial file */
      IMessageBox errorMsg( tutorialEvent.window() );
      errorMsg.setTitle( IResourceId(IDW_FRAME_WINDOW));
      errorMsg.show( IResourceId(IDS_ERROR_NO_TUTORIAL),
                     IMessageBox::catastrophic);
      return true;
   }

  /* Initialize the start session structure */
  StartData.Length   = sizeof(STARTDATA);   /* Length of STARTDATA structure */
  StartData.Related  = SSF_RELATED_CHILD;   /* Child session */
  StartData.FgBg     = SSF_FGBG_FORE;       /* Start child session in foreground */
  StartData.TraceOpt = SSF_TRACEOPT_NONE;   /* Do not trace session */
  StartData.PgmTitle = (PSZ)(resLib.loadString(IDS_OPEN_FILE));  
                                            /* Session Title string */
  StartData.PgmName  = TUTORIAL_PROGRAM;    /* Tutorial program path name */

  /*-----------------------------------------------------------------------------*/
  /* Pass the tutorial INF file name as input arguments to the VIEW program.     */
  /* Single and then double quote the filename in case the file name is specified*/
  /* as a list of files concatenated with plus (+) signs.  Otherwise the VIEW    */
  /* program interprets the file name as one long file name with plus signs.     */
  /*-----------------------------------------------------------------------------*/
  strcpy(szHelpTutorialBuffer,"\'\"");	    /* Single followed by double quote */
  strcat(szHelpTutorialBuffer,bResultBuf); /* Fully-qualified tutorial filename found above */
  strcat(szHelpTutorialBuffer,"\"\'");     /* Double followed by single quote */
  StartData.PgmInputs   = (PBYTE)szHelpTutorialBuffer;

  StartData.TermQ       = 0;               /* Assume no termination queue  */
  StartData.Environment = 0;               /* Assume no environment string */

  /* Inherit environment and open file handles from parent */
  StartData.InheritOpt  = SSF_INHERTOPT_PARENT;

  StartData.SessionType = SSF_TYPE_DEFAULT;    /* Let Shell establish session type */
  StartData.IconFile    = 0;                   /* No specific icon file provided */
  StartData.PgmHandle   = 0;                   /* Do not use the installation file */
  StartData.PgmControl  = SSF_CONTROL_VISIBLE; /* Start program visible and maximized */

  /* Initial window coordinates and size */
  StartData.InitXPos    = 30;
  StartData.InitYPos    = 40;
  StartData.InitXSize   = 0;
  StartData.InitYSize   = 0;

  StartData.Reserved      = 0;                     /* Reserved, must be zero */
  StartData.ObjectBuffer  = (PSZ)szObjectBuffer;   /* Buffer to hold failure causes */
  StartData.ObjectBuffLen = sizeof(szObjectBuffer);

  /*----------------------------------------------------------------------*/
  /* On successful return, the variable SessID contains the session ID    */
  /* of the new session, and the variable PID contains the process ID     */
  /* of the new process.                                                  */
  /*----------------------------------------------------------------------*/
  if (DosStartSession(&StartData, &SessID, &PID))
  {
    /* Display error message - can't find VIEW.EXE */
    IMessageBox errorMsg( tutorialEvent.window() );
    errorMsg.setTitle( IResourceId(IDW_FRAME_WINDOW));
    errorMsg.show( IResourceId(IDS_ERROR_STARTING_TUTORIAL),
                   IMessageBox::catastrophic);
    return true;
  }

  return true;   // Set event result to true (handled!)
}





