%PROLOG%

#include <stdio.h>
#include "animal.hh"
#include "cat.hh"

/*
 * Statically load the DLLs that implement the Animal
 * base class and the Cat derived class.
 * The Dog class DLL will be dynamically loaded using one of the
 * SOM Class Manager APIs.
 */

void Annoy(Animal*);
void countThem();

int main()
{
   Animal animal1;
   Cat	  cat1("Snookums");

   countThem();

   // Set buffering off for standard out stream 
   setbuf (stdout, NULL);

   Annoy(&animal1);
   Annoy(&cat1);

   /*
    * Load DOG.DLL and find the dynamic class object representing
    * the Dog class.  It's SOM name is SOMDog.
    */
   SOMClass *c = SOMClassMgrObject->somFindClsInFile(
		   somIdFromString("SOMDog"), 0, 0, "DOG");


   /*
    * Check that the previous call succeeded and that the class
    * we found is descended from Animal.
    */
   if(c && c->somDescendedFrom(Animal::__ClassObject))
   {
      // Create an instance of the dynamically loaded class.
      Animal *ap = (Animal*) c->somNew();

      countThem();
      Annoy(ap);

      delete ap;
      countThem();
   }
   return 0;
}

void Annoy(Animal *ap)
{
   printf("Now let us vex mightily a %s named %s\n",
	   ap->somGetClassName(), ap->name);
   ap->reactTo(Animal::vex_mightily);
   printf("\n");
}

void countThem()
{
   printf("%d Animals.\n", Animal::numberOfAnimals);
}
