%PROLOG%

#include <som.hh>

#ifndef ANIMAL_HH
#define ANIMAL_HH
/*
 * Declare the Animal base class and the methods and instance
 * data that it introduces.  The class uses the _Export keyword
 * because, like most SOM classes, its implementation will be in a DLL.
 * When applied to a DTS class, _Export causes all the right
 * external symbols to be exported without naming them in a DEF file.
 *
 * The public interface is
 *  a nested type  "enum provocation"
 *  an overridable method reactTo(provocation)
 *  a public data member  name
 *  a constructor with a single char* parameter.
 *  a destructor
 *  an instance counter.  It will count instances of Animal and
 *     all its subclasses.
 *
 * Since the constructor has default values for all its (one) parameters,
 * it doubles as a default constructor.
 *
 * Public instance data is supported by DTS, and clients can directly
 * access the "name" instance variable of an Animal, as long as the
 * object involved is not a remote (DSOM) object.
 * DSOM only supports method invocation but not direct data access.
 *
 * To allow for that case, we tell the compiler to create a public attribute
 * (pair of get/set methods) for "name", and to let the actual instance data
 * (or "backing data") also be public.  In DSOM programs, this header
 * should be wrapped by
 *	    #pragma SOMNoDataDirect(on)
 *	    #include "animal.hh"
 *	    #pragma SOMNoDataDirect(pop)
 * which will force use of the get/set methods.  In non-DSOM programs, the
 * public data is directly accessed.
 */

class _Export Animal : public SOMObject {
   public:
	enum provocation { pet, tickle, pinch, vex_mightily };

	virtual void reactTo(provocation p);
	char* name;
	Animal(char* name = "theBeast");
	virtual ~Animal();

   private:
	short timesProvoked;
   public:
	static int numberOfAnimals;

   #pragma SOMAttribute(name, publicdata)
};
#endif
