# %FILE_NAME%.mak
#
# The actions included in this makefile are:
#  Compile::SOM Compiler
#  Compile::SQL Precompile
#  Compile::C++ Compiler
#  Link::Linker

.SUFFIXES: .CPP .IDL .SQC .c .obj

.all: \
    %FILE_NAME%.exe

.IDL.xh:
    @echo " Compile::SOM Compiler "
    sc.exe -sxh %DAX_FILE%i.idl

.IDL.xih:
    @echo " Compile::SOM Compiler "
    sc.exe -sxih %DAX_FILE%i.idl

.SQC.c:
    @echo " Compile::SQL Precompile "
    sqlprep.exe %DAX_FILE%i.sqc %DATASTORE_NAME% /P

.CPP.obj:
    @echo " Compile::C++ Compiler "
    icc.exe /Fo"%|dpfF.OBJ" /C %s

.c.obj:
    @echo " Compile::C++ Compiler "
    icc.exe /Fo"%|dpfF.OBJ" /C %s

%FILE_NAME%.exe: \
    %FILE_NAME%.obj \
    %DAX_FILE%X.obj \
    %DAX_FILE%I.obj
    @echo " Link::Linker "
    icc.exe @<<
     /Fe%FILE_NAME%.exe
     %FILE_NAME%.obj
     %DAX_FILE%X.obj
     %DAX_FILE%I.obj
     somtk.lib  upm.lib
<<

%DAX_FILE%I.xh %DAX_FILE%I.xih: \
    %DAX_FILE%I.IDL

%DAX_FILE%I.c: \
    %DAX_FILE%I.SQC

%FILE_NAME%.obj: \
    %FILE_NAME%.CPP \
    {$(INCLUDE);}sdsmcon.xh \
    %DAX_FILE%i.xh

%DAX_FILE%I.obj: \
    %DAX_FILE%I.c

%DAX_FILE%X.obj: \
    %DAX_FILE%X.CPP \
    %DAX_FILE%I.XIH
