
%PROLOG%

/***************************************************************************/
/*                                                                         */
/* %FILE_NAME% - Skeleton of a basic DAX SOM application.                  */
/*           It can serve as a starting point for a program that uses      */
/*           Data Access services.                                         */
/*                                                                         */
/***************************************************************************/

#include <iostream.h>
#include "sdsmcon.xh"
#include "%DAX_FILE%i.xh"

static int exceptionCheck(void);
Environment                *ev        = somGetGlobalEnvironment();
DatastoreFactory           *pidFactDSObject = DatastoreNewClass (0,0);
%DAX_CLASS%Factory         *DAXMgrObject = %DAX_CLASS%NewClass(0,0);

void main()
{
  Datastore           *DSObject     = pidFactDSObject->create_object(ev);
  %DAX_CLASS%         *DAXObject    = DAXMgrObject->create_object(ev);

  _IDL_SEQUENCE_PersistentObject DAXObjectList;
  int rc;

  // Establish connection to a datastore
  DSObject->connect(ev, "%DATASTORE_NAME%", "USERID", "PASSWORD");
  rc = exceptionCheck();

  // Add a row
  // Take away the comment and set the values of all the fields for the add.
  // Replace <Attribute> with the attribute name you use in the DAX IDL.
  // Please make sure that the value for the key field is unique.
  // DAXObject->_set_<Attribute>(ev, value);
  DAXObject->add(ev);
  rc = exceptionCheck();

  // Update a row
  // Take away the comment and set the values of all the fields for the update.
  // Replace <Attribute> with the attribute name you use in the DAX IDL.
  // You should do a retrieve to refresh the values kept in the object with the
  // row you want to update. 
  // WARNING: Do not change the values of the key fields. If you do, you will
  // update a wrong row.
  // DAXObject->_set_<Attribute>(ev, value);
  DAXObject->update(ev);
  rc = exceptionCheck();

  // Update a row
  // Take away the comment and set the values of all the fields for the update.
  // Replace <Attribute> with the attribute name you use in the DAX IDL.
  // You should do a retrieve to refresh the values kept in the object with the
  // row you want to update. 
  // WARNING: Do not change the values of the key fields. If you do, you will
  // update a wrong row.
  // DAXObject->_set_<Attribute>(ev, value);
  DAXObject->update(ev);
  rc = exceptionCheck();

  // Retrieve a row
  // Take away the comment and set the value of the key field for the retrieve
  // Replace <Attribute> with the attribute name you use in the DAX IDL.
  // If you have more than one key attributes, you need to set them all.
  // DAXObject->_set_<Attribute>(ev, value);
  DAXObject->retrieve(ev);
  rc = exceptionCheck();
  // Get the attribute value by using _get method.
  // Replace <Attribute> with the attribute name you use in the DAX IDL.
  // temp = DAXObject->_get_<Attribute>(ev);

  // Delete a row
  // Take away the comment and set the value of the key field for the delete.
  // Replace <Attribute> with the attribute name you use in the DAX Class.
  // If you have more than one key attribute, you need to set them all.
  // DAXObject->_set_<Attribute>(ev, value);
  DAXObject->del(ev);
  rc = exceptionCheck();

  // Retrieve all the rows from a table
  DAXObjectList = DAXMgrObject->retrieveAll(ev);
  rc = exceptionCheck();
  if (rc == 0) {

    // Process all the rows in a for loop
    for (int j=0; j < sequenceLength(DAXObjectList); j++) {
      // Get the item from the sequence
      DAXObject = (%DAX_CLASS% *) sequenceElement(DAXObjectList,j);

      // Process the DAXObject ...

    }
  } /* endif */

  // select some rows from a table
  char selectArg[100];

  // Put the SQL where clause in the selectArg before calling select.
  DAXObjectList = DAXMgrObject->select(ev, selectArg);
  rc = exceptionCheck();
  if (rc == 0) {
    // Process all the selected rows in a for loop
    for (int j=0; j < sequenceLength(DAXObjectList); j++) {
      // Get the item from the sequence
      DAXObject = (%DAX_CLASS% *) sequenceElement(DAXObjectList,j);

      // Process the DAXObject ...
    } /* endfor */
  } /* endif */

  // commit the work by calling transact with OCLI_COMMIT
  DSObject->commit(ev);
  rc = exceptionCheck();

  // commit the work by calling transact with OCLI_ROLLBACK
  DSObject->rollback(ev);
  rc = exceptionCheck();

  // disconnect from a datastore
  DSObject->disconnect(ev);
  rc = exceptionCheck();

}

int exceptionCheck(void ) {
   char *exId;                                                        
   int rc = 0;
                                                                      
   switch (ev->_major) {                                                                  
   case SYSTEM_EXCEPTION:                                        
      cout << "system exception" << endl;
      rc = 1;
      break;                                                
   case USER_EXCEPTION:                                          
      rc ++;
      exId = somExceptionId(ev);                            
      cout << "Exception ID: " << somExceptionId(ev) << endl;
      somExceptionFree(ev);                              
      break;                                                
   case NO_EXCEPTION:
      break;
   }
   return rc;
}


