
%PROLOG%

/***************************************************************************/
/*                                                                         */
/* %FILE_NAME% - Skeleton of a basic DAX application.  It can serve as a        */
/*           starting point for a program that uses Data Access            */
/*           services.                                                     */
/*                                                                         */
/***************************************************************************/

#include <iostream.h>

#include "idsmcon.hpp"
#include "%DAX_FILE%v.hpp"

void main()
{
  // Create an instance of a datastore object
  IDatastore DSObject;

  // Create a DAX object and DAX manager object
  %DAX_CLASS% DAXObject;
  %DAX_CLASS%Manager DAXMgrObject;

  // You need a cursor object to go through each DAX object in the sequence.
  IVSequence<%DAX_CLASS% *>::Cursor cursor(*(DAXMgrObject.items()));
  
  // Establish connection to a datastore
  try {
    DSObject.connect("%DATASTORE_NAME%", "USERID", "PASSWORD");
  } catch (IException &exc) {
    cout << "Failed: Exception occurs" << endl;
    cout << "Error id: " << exc.errorId() << endl;
    for (unsigned long i = 0; i < exc.textCount(); i++)
      cout << "Error Text: " << exc.text(i) << endl;
    cout << "Error Class: " << exc.name() << endl;
  }

  // Add a row
  try {
    // Take away the comment and set the values of all the fields for the add.
    // Replace <Attribute> with the attribute name you use in the DAX Class.
    // Please make sure that the value for the key field is unique.
    // DAXObject.set<Attribute>(value);
    DAXObject.add();
  } catch (IException &exc) {
    cout << "Error id: " << exc.errorId() << endl;
    for (unsigned long i = 0; i < exc.textCount(); i++)
      cout << "Error Text: " << exc.text(i) << endl;
    cout << "Error Class: " << exc.name() << endl;
  }

  // Update a row
  try{ 
    // Take away the comment and set the valued for all the fields for the update.
    // Replace <Attribute> with the attribute name you use in the DAX Class.
    // You should do a retrieve to refresh the values kept in the object with the
    // row you want to update. 
    // WARNING: Do not change the values of the key fields. If you do, you will
    // update a wrong row.
    // DAXObject.set<Attribute>(value);
    DAXObject.update();
  } catch (IException &exc) {
    cout << "Error id: " << exc.errorId() << endl;
    for (unsigned long i = 0; i < exc.textCount(); i++)
      cout << "Error Text: " << exc.text(i) << endl;
    cout << "Error Class: " << exc.name() << endl;
  }                                                              

  // Retrieve a row
  try {
    // Take away the comment and set the value of the key field for the retrieve
    // Replace <Attribute> with the attribute name you use in the DAX Class.
    // If you have more than one key attributes, you need to set them all.
    // DAXObject.set<Attribute>(value);
    DAXObject.retrieve();
    // Get the attribute value by calling the function. 
    // Replace <Attribute> with the attribute name you use in the DAX Class.
    // temp = DAXObject.<Attribute>();
  } catch (IException &exc) {
    cout << "Error id: " << exc.errorId() << endl;
    for (unsigned long i = 0; i < exc.textCount(); i++)
      cout << "Error Text: " << exc.text(i) << endl;
    cout << "Error Class: " << exc.name() << endl;
  }

  // Delete a row
  try {
    // Take away the comment and set the value for the key field for the delete.
    // Replace <Attribute> with the attribute name you use in the DAX Class.
    // If you have more than one key attribute, you need to set them all.
    // DAXObject.set<Attribute>(value);
    DAXObject.del();
  } catch (IException &exc) {
    cout << "Error id: " << exc.errorId() << endl;
    for (unsigned long i = 0; i < exc.textCount(); i++)
      cout << "Error Text: " << exc.text(i) << endl;
    cout << "Error Class: " << exc.name() << endl;
  }

  // Retrieve all the rows from a table
  try {
    DAXMgrObject.refresh();
 
    // Process all the rows in a for loop
    for (cursor.setToFirst();cursor.isValid();cursor.setToNext()) {
       //Get the item from the sequence
       DAXObject = *(DAXMgrObject.items()->elementAt(cursor));

       // Process the DAXObject ...

    } /* endfor */
  } catch (IException &exc) {
    cout << "Error id: " << exc.errorId() << endl;
    for (unsigned long i = 0; i < exc.textCount(); i++)
      cout << "Error Text: " << exc.text(i) << endl;
    cout << "Error Class: " << exc.name() << endl;
  }                                                              

  // select some rows from a table
  try {
    char selectArg[100];
    // Put the SQL where clause in the selectArg before calling select.

    DAXMgrObject.select(selectArg);

    // Process all the selected rows in a for loop
    for (cursor.setToFirst();cursor.isValid();cursor.setToNext()) {
      //Get the item from the sequence
      DAXObject = *(DAXMgrObject.items()->elementAt(cursor));

     // Process the DAXObject ...

    } /* endfor */
  } catch (IException &exc) {
    cout << "Error id: " << exc.errorId() << endl;
    for (unsigned long i = 0; i < exc.textCount(); i++)
      cout << "Error Text: " << exc.text(i) << endl;
    cout << "Error Class: " << exc.name() << endl;
  }                                                              

  // Commit the work by calling transact with OCLI_COMMIT
  try{
    DSObject.commit();
  } catch (IException &exc) {
    cout << "Error id: " << exc.errorId() << endl;
    for (unsigned long i = 0; i < exc.textCount(); i++)
      cout << "Error Text: " << exc.text(i) << endl;
    cout << "Error Class: " << exc.name() << endl;
  }                                                              
  
  // Rollback the work by calling transact with OCLI_ROLLBACK
  try{
    DSObject.rollback();
  } catch (IException &exc) {
    cout << "Error id: " << exc.errorId() << endl;
    for (unsigned long i = 0; i < exc.textCount(); i++)
      cout << "Error Text: " << exc.text(i) << endl;
    cout << "Error Class: " << exc.name() << endl;
  }                                                              

  // disconnect from a datastore
  try {
    DSObject.disconnect();
  } catch (IException &exc) {
    cout << "Error id: " << exc.errorId() << endl;
    for (unsigned long i = 0; i < exc.textCount(); i++)
      cout << "Error Text: " << exc.text(i) << endl;
    cout << "Error Class: " << exc.name() << endl;
  }                                                              

} /* endmain */


