
%PROLOG%

//-------------------------------------------
// %FILE_NAME%.h - Header file for a C++ DLL
//-------------------------------------------


/*-----------------------------------------------------------------*/
/* This file defines 3 classes, area, rectangle, and triangle and  */
/* marks them with the _Export keyword.  When a class is exported  */
/* using the _Export keyword, all the public symbols in the class  */
/* are exported by ordinal only.  When the DLL is updated, the     */
/* compiler may assign different ordinals to the symbols.          */
/*-----------------------------------------------------------------*/


/*--------------------------*/
/* Define a base class      */
/*--------------------------*/
class _Export area
   {
   private:
      double dim1, dim2;
   public:
      static int   objectCount;
      void setarea(double d1 , double d2);
      void getDim(double &d1, double &d2);
      virtual double getArea();
      area::area(void);
   };


/*-----------------------------*/
/* Define a derived class      */
/*-----------------------------*/
class _Export rectangle : public area
   {
   public:
      static int objectCount ;
      double getArea();
      rectangle::rectangle(void);
   };


/*------------------------------*/
/* Define another derived class */
/*------------------------------*/
class _Export triangle : public area
   {
   public:
      static int objectCount;
      double getArea();
      triangle::triangle(void);
   };



