
%PROLOG%

//-------------------------------------------
// %FILE_NAME%.h - Header file for a C++ DLL
//-------------------------------------------


/*-----------------------------------------------------------------*/
/* This file defines 3 classes, area, rectangle, and triangle.     */
/* No symbol or class is marked with the _Export keyword or        */
/* exported via the #pragma export directive.  Exporting is done   */
/* using a .DEF file created with the help of the CPPFILT utility  */
/* that creates an EXPORT entry for every public symbol.  The      */
/* symbols are thus exported by their mangled names.               */
/*-----------------------------------------------------------------*/


/*--------------------------*/
/* Define a base class      */
/*--------------------------*/
class area
   {
   private:
      double dim1, dim2;
   public:
      static int   objectCount;
      void setarea(double d1 , double d2);
      void getDim(double &d1, double &d2);
      virtual double getArea();
      area::area(void);
   };


/*-----------------------------*/
/* Define a derived class      */
/*-----------------------------*/
class rectangle : public area
   {
   public:
      static int objectCount ;
      double getArea();
      rectangle::rectangle(void);
   };


/*------------------------------*/
/* Define another derived class */
/*------------------------------*/
class triangle : public area
   {
   public:
      static int objectCount;
      double getArea();
      triangle::triangle(void);
   };



