
%PROLOG%

/*-------------------------------------------------------------------*/
/* %FILE_NAME%.c Source file for a C DLL                             */
/*-------------------------------------------------------------------*/

#include <stdio.h>
#include "%FILE_NAME%.h"


/*-------------------------------------------------------------------*/
/* Export function3 explicitly using the #pragma export statement.   */
/*                                                                   */
/* Exporting by "#pragma export" exports the symbol by ordinal only, */
/* but you can optionally choose the ordinal and keep the assignment */
/* when you update the DLL.  You can also specify a different name   */
/* for the symbol to be used outside the DLL.                        */
/*-------------------------------------------------------------------*/
#pragma export(function3,,1)


/*-------------------------------------------------------------------*/
/* Export data3 explicitly using the _Export keyword.                */
/*                                                                   */
/* Exporting using the _Export keyword exports the symbol by ordinal */
/* only.  You cannot control the ordinal assignments.  When the DLL  */
/* is updated, the compiler may assign different a ordinal to the    */
/* exported symbol.                                                  */
/*-------------------------------------------------------------------*/
int _Export data3;


/* Declare global variables */
int data1;
int data2;


/* Define function1 */
int function1()
{
   return data1;
}

/* If we are statically linking to the runtime libraries, we should */
/* register the exception handler for each function.                */
#ifdef   STATIC_LINK
#pragma  handler( function1 )
#endif



/* Define function2 */
int function2()
{
   return data2;
}

#ifdef   STATIC_LINK
#pragma  handler(      insertion )
#endif



/* Define function3 */
int function3()
{
   return data3;
}

#ifdef   STATIC_LINK
#pragma  handler(      selection )
#endif


