
/*****************************************************************************\
*
*  Module Name:  SSNDREXX.C
*
*  Rexx Interface for BocaSoft System Sounds
*
*  Copyright (c) BocaSoft Incorporated 1993
*
*  Entry Points:
*
*       FindSystemSounds
*	PlaySound 
*
\*****************************************************************************/

#define  INCL_WIN                        
#define  INCL_PM                         
#define  INCL_WINHELP                    
#define  INCL_WINWINDOWMGR
#define  INCL_MMIO                       
#define  INCL_DOS
#define  INCL_COMMON

#include	<os2.h>
#include	<os2me.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<math.h>
#include	<bsememf.h>
#include	<bseerr.h>	
#include	<rexxsaa.h>


#define	SSND_SUCCESS			0
#define	SSND_ERROR_NOT_PM		1
#define	SSND_ERROR_SSND_NOT_FOUND	2
#define	SSND_ERROR_INVALID_HANDLE	3


#define	SSND_PROG_NAME	"System Sounds for OS/2"
#define	SSND_WM_PLAY	0x5000

ULONG	FindSystemSounds (PSZ, LONG, PRXSTRING, PSZ, PRXSTRING);
ULONG	PlaySound (PSZ, LONG, PRXSTRING, PSZ, PRXSTRING);

HWND	hwndSSnd;
HAB	hab;

/*****************************************************************************\
*
*  Subroutine Name:  FindSystemSounds
*
*  Function:  Get the window handle for BocaSoft System Sounds.
*
*  Returns:
*              0 - Success
*              1 - Not a PM Session
*              2 - System Sounds not Found
*
\*****************************************************************************/

ULONG	FindSystemSounds (PSZ pszFuncName,
	LONG lArgc,
	RXSTRING Argv[], 
	PSZ QueueName,
	PRXSTRING pRetStr)
{
 	HWND  	hwndParent;     /* whose child windows are enumed */ 
	HWND  	hwndNext;	/* current enumeration handle     */
	HMQ	hmq;
 	HENUM  	henum; 		/* enumeration handle		  */
	CHAR	szWinName[50];  /* window text */
	BOOL	bFound = FALSE;
	ULONG	ulRc = 0;

	/* Enumerate all desktop windows and search for 
	BocaSoft System Sounds */

	hab = WinInitialize ( 0 );

	if (!(hmq = WinCreateMsgQueue( hab, 0 )))
	{
		sprintf (pRetStr->strptr, "%d", SSND_ERROR_NOT_PM);
		pRetStr->strlength = strlen(pRetStr->strptr);
		return (0);
	}

	hwndParent = HWND_DESKTOP;
 
	henum = WinBeginEnumWindows (hwndParent);
 
	while ((hwndNext = WinGetNextWindow (henum)) != NULLHANDLE)
	{
		ulRc = WinQueryWindowText (hwndNext, sizeof(szWinName), szWinName);
		if (!(strcmp(szWinName, SSND_PROG_NAME)))
		{
			bFound = TRUE;
			break;
		}
	}
	WinEndEnumWindows (henum);

	if (bFound)
	{
		hwndSSnd = hwndNext;
		sprintf (pRetStr->strptr, "%d", SSND_SUCCESS);
	}
	else
		sprintf (pRetStr->strptr, "%d", SSND_ERROR_SSND_NOT_FOUND);
	
	pRetStr->strlength = strlen(pRetStr->strptr);

	return (0);
}



/*****************************************************************************\
*
*  Subroutine Name:  PlaySound
*
*  Function:  Post a window message to BocaSoft System Sounds with
*             a sound index.
*
*  Returns:
*              0 - Success
*              3 - Invalid Window Handle 
*
\*****************************************************************************/

ULONG	PlaySound (PSZ pszFuncName,
	LONG lArgc,
	RXSTRING Argv[], 
	PSZ QueueName,
	PRXSTRING pRetStr)
{
	ULONG	ulRc = 0;

	/* Send a message to System Sounds */

	if (hwndSSnd)
	{
		ulRc = WinPostMsg (hwndSSnd,
			SSND_WM_PLAY,
			0,
			(MPARAM)atoi(Argv[0].strptr));

		sprintf (pRetStr->strptr, "%d", SSND_SUCCESS);
		pRetStr->strlength = strlen(pRetStr->strptr);
	}
	else	
	{
		sprintf (pRetStr->strptr, "%d", SSND_ERROR_INVALID_HANDLE);
		pRetStr->strlength = strlen(pRetStr->strptr);
	}
	return (0);
}




