#define INCL_SPL
#define	INCL_SPLDOSPRINT
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ARG_DRIVER  1
#define ARG_QUEUE   2
#define ARG_PRINTER 3
#define ARG_PORT    4
#define ARG_DEVICE  5

char textbuf [2048];

void usage (void)
{
    puts ("Usage: spl [driver|queue|printer|port|device] {name} {/d} {//node}");
    exit (0);
}

BOOL NonNull (PSZ psz)
{
    return psz && strlen(psz) > 0;
}

int Enumerate (int iArg, PSZ pszComp)
{
int rc;
ULONG cRet;
ULONG cAvail;
ULONG cNeeded;
int i;

    switch (iArg)
	{
	case ARG_DRIVER:
	    {
	    PRDRIVINFO *pinfo;

	    pinfo = (PRDRIVINFO *) textbuf;
	    rc = SplEnumDriver (pszComp, 0, textbuf, sizeof textbuf,
		&cRet, &cAvail, &cNeeded, NULL);

	    if (rc)
		{
		printf ("Error code %d\n", rc);
		return rc;
		}
	    else if (cRet == 0)
		puts ("No drivers");
	    else
		for (i = 0 ; i < cRet ; i++)
		    puts (pinfo[i].szDrivName);
	    }
	    break;

	case ARG_QUEUE:
	    {
	    PSZ *pinfo;

	    pinfo = (PSZ *) textbuf;
	    rc = SplEnumQueue (pszComp, 5, textbuf, sizeof textbuf,
		&cRet, &cAvail, &cNeeded, NULL);

	    if (rc)
		{
		printf ("Error code %d\n", rc);
		return rc;
		}
	    else if (cRet == 0)
		puts ("No queues");
	    else
		for (i = 0 ; i < cRet ; i++)
		    puts (pinfo[i]);
	    }
	    break;

	case ARG_PRINTER:
	    {
	    PRINTERINFO *pinfo;
	    ULONG flType = SPL_PR_QUEUE | SPL_PR_DIRECT_DEVICE |
		SPL_PR_QUEUED_DEVICE | SPL_PR_LOCAL_ONLY;
	    PSZ psz;

	    pinfo = (PRINTERINFO *) textbuf;
	    rc = SplEnumPrinter (pszComp, 0, flType, textbuf, sizeof textbuf,
		&cRet, &cAvail, &cNeeded, NULL);

	    if (rc)
		{
		printf ("Error code %d\n", rc);
		return rc;
		}
	    else if (cRet == 0)
		puts ("No printers");
	    else
		for (i = 0 ; i < cRet ; i++)
		    {
		    switch (pinfo[i].flType)
			{
			case SPL_PR_QUEUE:
			    psz = "Queue";		    break;
			case SPL_PR_QUEUED_DEVICE:
			    psz = "Queued-Device";	    break;
			case SPL_PR_DIRECT_DEVICE:
			    psz = "Direct-Device";	    break;
			default:
			    psz = "Unknown";
			}
		    printf ("%s, Type=%s", pinfo[i].pszPrintDestinationName,
				psz);
		    psz = pinfo[i].pszComputerName;
		    if (NonNull(psz))
			printf (", Computer=%s", psz);
		    psz = pinfo[i].pszLocalName;
		    if (NonNull(psz))
			printf (", LocalName=%s", psz);
		    psz = pinfo[i].pszDescription;
		    if (NonNull(psz))
			printf (", Description=\"%s\"\n", psz);
		    else
			putchar ('\n');

		    }
	    }
	    break;

	case ARG_PORT:
	    {
	    PRPORTINFO *pinfo;

	    pinfo = (PRPORTINFO *) textbuf;
	    rc = SplEnumPort (pszComp, 0, textbuf, sizeof textbuf,
		&cRet, &cAvail, &cNeeded, NULL);

	    if (rc)
		{
		printf ("Error code %d\n", rc);
		return rc;
		}
	    else if (cRet == 0)
		puts ("No ports");
	    else
		for (i = 0 ; i < cRet ; i++)
		    puts (pinfo[i].szPortName);
	    }
	    break;

	case ARG_DEVICE:
	    {
	    PRDINFO3 *pinfo;
	    PSZ psz;

	    pinfo = (PRDINFO3 *) textbuf;
	    rc = SplEnumDevice (pszComp, 3, textbuf, sizeof textbuf,
		&cRet, &cAvail, &cNeeded, NULL);

	    if (rc)
		{
		printf ("Error code %d\n", rc);
		return rc;
		}
	    else if (cRet == 0)
		puts ("No devices");
	    else
		for (i = 0 ; i < cRet ; i++)
		    {
		    psz = pinfo[i].pszLogAddr;
		    if (psz && strcmp(psz,""))
			printf ("%s (%s)\n", pinfo[i].pszPrinterName, psz);
		    else
			puts (pinfo[i].pszPrinterName);
		    }
	    }
	    break;
	}
    return 0;
}

int Query (int iArg, PSZ pszName, PSZ pszComp)
{
int rc;
ULONG cNeeded;

    switch (iArg)
	{
	case ARG_DRIVER:
	case ARG_PRINTER:
	case ARG_PORT:
	    printf ("You can only query devices or queues\n");
	    return 1;

	case ARG_QUEUE:
	    #define info MAKETYPE(textbuf, PRQINFO6)

	    rc = SplQueryQueue (pszComp, pszName, 6, textbuf,
		sizeof textbuf, &cNeeded);

	    if (rc)
		{
		printf ("Error code %d\n", rc);
		return rc;
		}
	    else
		{
		printf ("Priority = %d\n", info.uPriority);
		printf ("StartTime = %d\n", info.uStartTime);
		printf ("UntilTime = %d\n", info.uUntilTime);
		if (info.fsType == PRQ3_TYPE_RAW)
		    puts ("Type = RAW");
		else if (info.fsType == PRQ3_TYPE_BYPASS)
		    puts ("Type = QP_BYPASS");
		else
		    puts ("Type = STANDARD");
		if (NonNull(info.pszSepFile))
		    printf ("Separator = %s\n", info.pszSepFile);
		if (NonNull(info.pszPrProc))
		    printf ("QPROC = %s\n", info.pszPrProc);
		if (NonNull(info.pszParms))
		    printf ("Queue Parms = %s\n", info.pszParms);
		if (NonNull(info.pszComment))
		    printf ("Comment = %s\n", info.pszComment);
		fputs (info.fsStatus & PRQ3_PAUSED ? "Held" : "Released",
			    stdout);
		if (info.fsStatus & PRQ3_PENDING)
		    fputs (", Pending deletion", stdout);
		printf ("\nNumber of jobs = %d\n", info.cJobs);
		printf ("Printers = %s\n", info.pszPrinters);
		printf ("Driver = %s\n", info.pszDriverName);
		if (NonNull(info.pszRemoteComputerName))
		    printf ("Remote Computer = %s\n", info.pszRemoteComputerName);
		if (NonNull(info.pszRemoteQueueName))
		    printf ("Remote Queue = %s\n", info.pszRemoteQueueName);
		}
	    #undef info
	    break;

	case ARG_DEVICE:
	    #define info MAKETYPE(textbuf, PRDINFO3)

	    rc = SplQueryDevice (pszComp, pszName, 3, textbuf,
		sizeof textbuf, &cNeeded);

	    if (rc)
		{
		printf ("Error code %d\n", rc);
		return rc;
		}
	    else
		{
		if (NonNull (info.pszLogAddr))
		    printf ("Logical Address = %s\n", info.pszLogAddr);
		switch (info.fsStatus & PRD_STATUS_MASK)
		    {
		    case PRD_ACTIVE:
			puts ("Processing");			break;
		    case PRD_PAUSED:
			puts ("Not processing, or paused");	break;
		    }
		if (info.fsStatus & PRJ_COMPLETE)
		    puts ("Job complete");
		if (info.fsStatus & PRJ_INTERV)
		    puts ("Intervention required");
		if (info.fsStatus & PRJ_ERROR)
		    puts ("Error occurred");
		if (info.fsStatus & PRJ_DESTOFFLINE)
		    puts ("Device offline");
		if (info.fsStatus & PRJ_DESTPAUSED)
		    puts ("Device paused");
		if (info.fsStatus & PRJ_NOTIFY)
		    puts ("Raise alert");
		if (info.fsStatus & PRJ_DESTNOPAPER)
		    puts ("No paper");
		if (NonNull (info.pszStatus))
		    printf ("Status = %s\n", info.pszStatus);
		if (NonNull (info.pszComment))
		    printf ("Description = %s\n", info.pszComment);
		if (NonNull (info.pszDrivers))
		    printf ("Drivers = %s\n", info.pszDrivers);
		printf ("Time = %d\n", info.time);
		printf ("Timeout = %d\n", info.usTimeOut);
		}
	    #undef info
	    break;

	}
    return 0;
}


int Delete (int iArg, PSZ pszName, PSZ pszComp)
{
int rc;

    switch (iArg)
	{
	case ARG_DRIVER:
	case ARG_PRINTER:
	case ARG_PORT:
	    printf ("You can only delete devices or queues\n");
	    return 1;

	case ARG_QUEUE:
	    rc = SplDeleteQueue (pszComp, pszName);
	    if (rc)
		{
		printf ("Error code %d\n", rc);
		return rc;
		}
	    break;

	case ARG_DEVICE:
	    rc = SplDeleteDevice (pszComp, pszName);
	    if (rc)
		{
		printf ("Error code %d\n", rc);
		return rc;
		}
	    break;

	}
    return 0;
}



int OpKind (char *arg)
{

    if (stricmp (arg, "driver") == 0)
	return ARG_DRIVER;
    else if (stricmp (arg, "queue") == 0)
	return ARG_QUEUE;
    else if (stricmp (arg, "printer") == 0)
	return ARG_PRINTER;
    else if (stricmp (arg, "port") == 0)
	return ARG_PORT;
    else if (stricmp (arg, "device") == 0)
	return ARG_DEVICE;
    else
	return 0;
}

int main (int argc, char **argv)
{
int i;

int iArg = 0;
BOOL fDelete = FALSE;
PSZ pszComp = NULL;
PSZ pszName = NULL;

    if (argc < 2)
	usage ();

    for (i = 1 ; i < argc ; i++)
	if (argv[i][0] == '/')
	    {
	    if (stricmp (argv[i]+1, "d") == 0)
		{
		if (fDelete)
		    usage ();
		else
		    fDelete = TRUE;
		}
	    else
		usage ();
	    }
	else if ( argv[i][0] == '\\' && argv[i][1] == '\\' )
	    {
	    if (pszComp)
		usage ();
	    else
		pszComp = argv[i];
	    }
	else if (iArg == 0)
	    {
	    iArg = OpKind (argv[i]);
	    if (iArg == 0)
		usage ();
	    }
	else if (pszName == 0)
	    pszName = argv[i];
	else
	    usage ();

    if (pszName == NULL)
	{
	if (fDelete == TRUE)
	    usage ();
	else
	    return Enumerate (iArg, pszComp);
	}
    else if (fDelete)
	return Delete (iArg, pszName, pszComp);
    else
	return Query (iArg, pszName, pszComp);

    return 0;
}
