/*  alloc.h

    memory management functions and variables.

*/

/*
 *      C/C++ Run Time Library - Version 1.5
 *
 *      Copyright (c) 1987, 1994 by Borland International
 *      All Rights Reserved.
 *
 */

#if !defined(__ALLOC_H)
#define __ALLOC_H

#if !defined(___DEFS_H)
#include <_defs.h>
#endif

#ifndef NULL
#include <_null.h>
#endif


#if !defined(RC_INVOKED)

#if defined(__STDC__)
#pragma warn -nak
#endif

#endif  /* !RC_INVOKED */




#ifndef _STDDEF
#  define _STDDEF
#  ifndef _PTRDIFF_T
#    define _PTRDIFF_T
     typedef int ptrdiff_t;
#  endif
#  ifndef _SIZE_T
#    define _SIZE_T
     typedef unsigned size_t;
#  endif
#endif

#if !defined(__STDC__)
struct heapinfo
{
  void *    ptr;
  unsigned  size;
  int       in_use;
};
#endif

#ifdef __cplusplus
extern "C" {
#endif

void *_RTLENTRY _EXPFUNC calloc  (size_t __nitems, size_t __size);
void  _RTLENTRY _EXPFUNC free    (void * __block);
void *_RTLENTRY _EXPFUNC malloc  (size_t  __size);
void *_RTLENTRY _EXPFUNC realloc (void * __block, size_t __size);

int   _RTLENTRY _EXPFUNC heapcheck    (void);
int   _RTLENTRY _EXPFUNC heapfillfree (unsigned int __fillvalue);
int   _RTLENTRY _EXPFUNC heapcheckfree(unsigned int __fillvalue);
int   _RTLENTRY _EXPFUNC heapchecknode(void *__node);
int   _RTLENTRY _EXPFUNC heapwalk     (struct heapinfo *__hi);
#ifdef __cplusplus
}
#endif

/* Values returned by heap??? and _heap??? functions */

#define _HEAPEMPTY      1
#define _HEAPOK         2
#define _FREEENTRY      3
#define _USEDENTRY      4
#define _HEAPEND        5
#define _HEAPCORRUPT    -1
#define _BADNODE        -2
#define _BADVALUE       -3
#define _HEAPBADBEGIN   -4
#define _HEAPBADNODE    -5
#define _HEAPBADPTR     -6




#if !defined(RC_INVOKED)

#if defined(__STDC__)
#pragma warn .nak
#endif

#endif  /* !RC_INVOKED */


#endif  /* __ALLOC_H */


