/* sets date and pack files */

parse arg target source

if target = '' | source = '' then do
	say 'Set date/time on files in <target> according to files in <source>'
	say 'Packs touched files using PACK2'
	say 'The utility TOUCH should be in the PATH'
	say ''
	say 'Example: datepack c:\fpk\done c:\fpk\todo'
	exit
end

rc = RxFuncAdd('SysFileTree', 'RexxUtil', 'SysFileTree')
rc = SysFileTree(target||'\*', "tfp.", "FSO") 
rc = SysFileTree(source||'\*', "sfp.", "FSO") 

do i=1 to tfp.0
	pos1=lastpos('\', tfp.i)
	pos2=lastpos('.', tfp.i)
	tfp.short.i = substr(tfp.i, pos1+1, pos2-pos1+2)
	tfp.short2.i = substr(tfp.i, pos1+1)

	found = 0
	do j=1 to sfp.0
		pos3=lastpos('\', sfp.j)
		pos4=lastpos('.', sfp.j)
		sfp.short.j = substr(sfp.j, pos3+1, pos4-pos3+2)
		sfp.short2.j = substr(sfp.j, pos3+1)
		if translate(tfp.short.i) = translate(sfp.short.j) then do
			found = 1
			datetime = stream(sfp.j, 'c', 'query datetime')
			parse var datetime d t
			d = space(d) 
			d = substr(d, 7, 2)'.'substr(d, 1, 2)'.'substr(d, 4, 2)
			if substr(d, 1, 2) > 70 then d = '19'||d
			else d = '20'||d
			t = substr(space(t), 1, 5)
			/* say tfp.short.i sfp.short.j '/D'd '/T't */
			rc = directory(substr(tfp.i, 1, pos1-1))
			'TOUCH 'tfp.short2.i' /D'd '/T't
			'pack2 'tfp.short2.i sfp.short2.j
			'del 'tfp.short2.i
			leave
		end
	end

	if found = 0 then say 'not found 'tfp.i
		
end
