/* Burn bootable OS/2 CD-ROM using CDRECORD/2                                */
/* Version 1.4                                                               */
/* 11.25.2000: added code of Fred Leggett to automate the boot img creation  */
/* NOTE: Since this script uses Albert Shan's SVDISK to circumvent having    */
/*       to use a floppy for the boot img creation process, it helps to have */
/*       SVDISK registered.                                                  */
/* 12.13.2000: addes some code to align with the PM interface                */
/* 02.19.2001: fixed problem with label disk 2                               */
/* 02.27.2001: added new menupoint (6)                                       */
/* 03.04.2001: fixed problem with flag file                                  */
/* 03.19.2001: some cosmethic changes                                        */
/* 04.10.2001: solved incomplete do end bug                                  */
/* 05.10.2001: added support for VFDISK 2.0 or higher                        */

/* get some parameters */
parse arg n.errors n.warnings
if n.errors   = '' then n.errors   = '?'
if n.warnings = '' then n.warnings = '?'

IF RxFuncQuery('SysLoadFuncs') THEN DO
  CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  CALL SysLoadFuncs
END

/* read paramaters from updcd.cfg */
cfgfile = 'updcd.cfg'
DO WHILE LINES(cfgfile)
  l = LINEIN(cfgfile)
  INTERPRET l
END
call lineout cfgfile

/* remember we were started */
'@echo record.cmd busy > record.bsy'
cdir = directory()

/* reset */
boot = ""
key = ""
flag1 = " "
flag2 = " "
flag3 = " "
flag4 = " "
flag5 = " "
'@mode 80,25 >nul'
'@ansi on >NUL'
say '1B'x || '[36;44m'
say '1B'x || '[1m'
'@cls'

/* start menu */
begin:

text.1 = "Update CD - Imagefile & CD Burn Script"
text.1 = overlay("Update CD - Imagefile & CD Burn Script", "  :                                                                         :", trunc((74-length(text.1))/2))
text.2 = "The build procedure has ended with "n.errors" errors and "n.warnings" warnings."
text.2 = overlay("The build procedure has ended with "n.errors" errors and "n.warnings" warnings.", "  :                                                                         :", trunc((74-length(text.2))/2))
text.3 = "See ["log"] for output details."
text.3 = overlay("See ["log"] for output details.", "  :                                                                         :", trunc((74-length(text.3))/2))

DO WHILE (key \= 0)

	'@cls'
  SAY "  ---------------------------------------------------------------------------"
  SAY text.1
  SAY "  ---------------------------------------------------------------------------"
  SAY text.2
  SAY text.3
  SAY "  ---------------------------------------------------------------------------"
  SAY "  :                                                                         :"
  SAY "  :  * = Process done.                                                      :"
  SAY "  :                                                                         :"
  SAY "  :  0 - Quit.                                                              :"
  SAY "  :                                                                         :"
  SAY "  :  1 - View burn log.                                                     :"
  SAY "  : "flag1"2 - Make boot image files.                                             :"
  SAY "  : "flag2"3 - Make CD imagefile.                                                 :"
  SAY "  : "flag3"4 - Blank CD-RW (necessary prior to burning if using CD-RW media).     :"
  SAY "  : "flag4"5 - Burn CD-R or CD-RW.                                                :"
  SAY "  :                                                                         :"
  SAY "  : "flag5"6 - Perform step 2, 3, 4, and 5 automatically.                         :"
  SAY "  :                                                                         :"
  SAY "  ---------------------------------------------------------------------------"
  SAY

  key = ""
  DO WHILE (key < 0) | (key > 6)
    key = SysGetKey('NOECHO')
  END
  SAY

  SELECT

    WHEN (key == 1) THEN call view_log
    WHEN (key == 2) THEN call make_bootimage
    WHEN (key == 3) THEN call make_cdimage
    WHEN (key == 4) THEN call blank_cd
    WHEN (key == 5) THEN call burn_cd
    WHEN (key == 6) THEN do 
												 call make_bootimage Q
												 call make_cdimage Q
												 call blank_cd Q
												 call burn_cd Q
										end
  	OTHERWISE DO

      SAY "You may re-run this script by typing RECORD.CMD from "rootdir
      SAY
      SAY "Bye bye!"
      SAY
			/* we are ready */
			'@del 'cdir'\record.bsy >nul 2>>&1'
    END

  END

END

EXIT


/* A simple Y/N keypress procedure. */

GetKeyYN: procedure

  DO WHILE (key1 <> "Y") & (key1 <> "N")
    key1 = SysGetKey('NOECHO')
    PARSE UPPER VAR key1 key1
  END

  SAY
  RETURN key1


/* Common error text to print to screen. */

PrintError:

  SAY "There was an error.  This process has not been completed!"
  SAY "Please re-run this option when the problem is fixed."
  SAY

  RETURN


/* procedure view log */
view_log:

      DO
        IF STREAM(burnlog,"C","query EXISTS") == "" THEN
          DO
            SAY burnlog" does not exist!"
            SAY
            SAY "A process has not yet been run or an error has occurred while trying"
            SAY "to write to "burnlog"."
            SAY
            SAY "Hit any key to return to the menu."
            SysGetKey('NOECHO')

          END
				ELSE viewer burnlog
      END

return

/* procedure build boot image */
make_bootimage:

			parse arg option

      DO
        /* make boot image files */
        SAY "Making boot image, please wait!"
        IF STREAM(source'\DISK_*.IMG',"C","query EXISTS") \= "" THEN DO
					if option = 'Q' then do
            CALL SysFileDelete(source'\DISK_0_1.IMG')
            CALL SysFileDelete(source'\DISK_2.IMG')
					end
					else do
	        	SAY "Boot image files already exist.  Overwrite? (Y/N)"
          	IF (GetKeyYN(k) == "N") THEN
            	DO
              	flag1 = "*"
              	CALL begin
            	END
          	ELSE DO
            	CALL SysFileDelete(source'\DISK_0_1.IMG')
            	CALL SysFileDelete(source'\DISK_2.IMG')
          	END
					end
        END

				'@echo Trying to insert a 2.88MB virtual disk in drive 'svdc_drive' > 'burnlog
				/* first try vfdisk */
				'@vfctrl 'svdc_drive' 4     >>'burnlog' 2>>&1'
				/* try svdisk if it did not work */
				if rc <> 0 then do
	        '@SVDC /ef '    svdc_drive'  >'burnlog' 2>>&1'
	        '@SVDC /r:2.88 'svdc_drive' >>'burnlog' 2>>&1'
	        '@SVDC /i:2.88 'svdc_drive' >>'burnlog' 2>>&1'
				end
				if rc <> 0 then do
					say 'Error inserting a 2.88MB virtual floppy in drive 'svdc_drive
					exit 9
				end
        '@cd 'source'\UpdCD\bootimg\DISK_0_1.IMG >>'burnlog' 2>>&1'
        '@SYSINSTX 'svdc_drive' >>'burnlog' 2>>&1'
        '@XCOPY * 'svdc_drive' /H/O/T/R/V >>'burnlog' 2>>&1'
				'@..\..\..\..\cdboot.exe /drive 'substr(svdc_drive, 1, 1)' /timeout 10 >> 'burnlog' 2>>&1'
        '@cd 'source'\diskimgs >>'burnlog' 2>>&1'
        '@IMAGE 'svdc_drive' ..\DISK_0_1.IMG >>'burnlog' 2>>&1'

				'@echo Trying to insert a 1.44MB virtual disk in drive 'svdc_drive' >> 'burnlog
				/* first try vfdisk */
				'@vfctrl 'svdc_drive' 1     >>'burnlog' 2>>&1'
				/* try svdisk if it did not work */
				if rc <> 0 then do
	        '@SVDC /ef '    svdc_drive' >>'burnlog' 2>>&1'
	        '@SVDC /r:1.44 'svdc_drive' >>'burnlog' 2>>&1'
	        '@SVDC /i:1.44 'svdc_drive' >>'burnlog' 2>>&1'
				end
				if rc <> 0 then do
					say 'Error inserting a 1.44MB virtual floppy in drive 'svdc_drive
					exit 9
				end
        '@cd 'source'\UpdCD\bootimg\DISK_2.IMG >>'burnlog' 2>>&1'
        '@XCOPY * 'svdc_drive' /H/O/T/R/V >>'burnlog' 2>>&1'
        '@cd 'source'\diskimgs >>'burnlog' 2>>&1'
				'@label 'svdc_drive'DISK 2 >>'burnlog' 2>>&1'
        '@IMAGE 'svdc_drive' ..\DISK_2.IMG >>'burnlog' 2>>&1'

        '@cd .. >>'burnlog' 2>>&1'
        '@cd .. >>'burnlog' 2>>&1'
				'@echo Trying to insert a 2.88MB virtual disk in drive 'svdc_drive' >> 'burnlog
				/* first try vfdisk */
				'@vfctrl 'svdc_drive' 4     >>'burnlog' 2>>&1'
				/* try svdisk if it did not work */
				if rc <> 0 then do
	        '@SVDC /ef '    svdc_drive' >>'burnlog' 2>>&1'
	        '@SVDC /r:2.88 'svdc_drive' >>'burnlog' 2>>&1'
	        '@SVDC /i:2.88 'svdc_drive' >>'burnlog' 2>>&1'
				end
				if rc <> 0 then do
					say 'Error inserting a 2.88MB virtual floppy in drive 'svdc_drive
					exit 9
				end

        flag1 = "*"

      END

return

/* procedure build cd image */
make_cdimage:

			parse arg option

      DO
        /* make updated CD imagefile */
        SAY "Making CD image using "source" (source) and "tempraw" (target)."
        CALL SysFileTree tempdir, stem, "D"

        IF (STREAM(tempraw,"C","query EXISTS") \= "") THEN DO
     				if option <> 'Q' then SAY "["tempraw"] already exists.  Overwrite? (Y/N)"
          	IF option <> 'Q' then do
							if (GetKeyYN(k) == "N") THEN
            		DO
              		flag2 = "*"
              		CALL begin
            		END
							else CALL SysFileDelete(tempraw)
						end
          	ELSE CALL SysFileDelete(tempraw)
       	END

        IF (stem.0 < 1) THEN CALL SysMkDir tempdir
        IF STREAM(source'\*.IMG',"C","query EXISTS") \= "" THEN boot = '-bDISK_0_1.IMG -cboot.cat'
        '@cd burn'

        SAY
        SAY "This process is currently being run and may take a few minutes to"
        SAY "complete.  If no disk activity occurs for several seconds, press CTRL-C"
        SAY "to exit this script."
        '@'cdrdir'\mkisofs -f -v -J -D -U -o 'tempraw boot source' >>'burnlog' 2>>&1'
	
 	      IF (rc == 0) THEN flag2 = "*"
        SAY
        SAY "Completed with return code "rc
        if option <> 'Q' then SAY "Hit any key to return to menu."
        if option <> 'Q' then k = SysGetKey('NOECHO')
		END

return

/* procedure blank CDRW */
blank_cd:

			parse arg option

      DO
        /* erase CDRW */
				if option = 'Q' then do
          SAY "Blanking CD-RW media now.  Please wait."
          '@'cdrdir'\cdrecord dev='device' speed='speed' blank=fast >>'burnlog' 2>>&1'
          IF (rc \= 0) THEN CALL PrintError
          ELSE flag3 = "*"
				end
				else do
	        SAY "Is a blank CD-RW in your burner? (Y/N)"
	        IF (GetKeyYN(k) == "N") THEN
	          DO
	            SAY "Please insert a blank CD-RW and re-run this option.  Hit any key to return"
	            SAY "to the menu."
	            k = SysGetKey('NOECHO')
	          END
	        ELSE DO
	          SAY "Blanking CD-RW media now.  Please wait."
	          '@'cdrdir'\cdrecord dev='device' speed='speed' blank=fast >>'burnlog' 2>>&1'
	          IF (rc \= 0) THEN CALL PrintError
	          ELSE flag3 = "*"
	
	          SAY "Completed with return code "rc
	          SAY "Hit any key to return to menu."
	          k = SysGetKey('NOECHO')
	        END
				end
      END

return

/* procedure burn cd */
burn_cd:

			parse arg option

      DO
        /* burn CD */
        isize = STREAM(tempraw,"C","query SIZE")
        IF (isize == "") THEN
          DO
            SAY "The imagefile ["tempraw"] does not exist.  Please make the"
            SAY "imagefile first via process #3."
            SAY
            SAY "Hit any key to return to the menu."
            k = SysGetKey('NOECHO')
          END
        ELSE DO
          isizeK = isize / 1024
          isizeM = isize / 1048576
          itimeMIN = isize / (153600 * speed) % 60
          itimeSEC = isize / (153600 * speed) // 60

          SAY "About to burn updated Warp 4 CD using imagefile ["tempraw"]."
          SAY
          SAY "The imagefile size in kilobytes is:  "isizeK
          SAY "The imagefile size in megabytes is:  "FORMAT(isizeM,,2)
          SAY "(A megabyte is defined as 1,048,576 bytes {2^20 bytes}.)"
          SAY
          SAY "Burner device:  "device
          SAY "CD burner speed:  "speed "("150 * speed" kilobytes per second.)"
          SAY "This burn will complete in approximately "itimeMIN":"FORMAT(itimeSEC,,2)" minutes."
          SAY "The time now is "TIME('C')
          SAY
					if option = 'Q' then do
            SAY "Writing updated OS/2 installation CD-ROM.  Please wait."
            '@'cdrdir'\cdrecord dev='device' speed='speed' -v -eject -pad -data 'tempraw' >>'burnlog' 2>>&1'
            IF (rc \= 0) THEN CALL PrintError
            ELSE flag4 = "*"
					end
					else do
	          SAY "Is a blank CD-R or CD-RW in your burner? (Y/N)"

	          IF (GetKeyYN(k) == "N") THEN
	            DO
	              SAY
	              SAY "Please insert a blank CD-R or CD-RW and re-run this option."
	              k = SysGetKey('NOECHO')
	            END
	          ELSE DO
	            SAY "Writing updated Warp 4 CD.  Please wait."
	            '@'cdrdir'\cdrecord dev='device' speed='speed' -v -eject -pad -data 'tempraw' >>'burnlog' 2>>&1'
	            IF (rc \= 0) THEN CALL PrintError
	            ELSE flag4 = "*"

	            SAY "Completed with return code "rc
  	          SAY "Hit any key to return to menu."
    	        k = SysGetKey('NOECHO')
      	    END
					end
        END
      END

return
