/* 03.11.2001: automatic Warp 3 update procedure with support for the     */
/*             following components: Warp 3 Fixpak 43, MPTS FPK 8423+8525 */
/* 03.15.2001: added support for ddfp2, tons of fixes                     */
/* 03.17.2001: tons of fixes again                                        */
/* 03.18.2001: and again ;-)                                              */
/* 03.19.2001: added support for tcp/ip fixpaks 0959+0980                 */
/* 03.22.2001: added support for Warp Connect                             */
/* 03.23.2001: solved problem with laps and grpware/warpsrv directory     */
/* 03.31.2001: solved problem with missing xdfh.msg in warp connect       */
/* 04.07.2001: added paramaters to control dani and dummy drivers         */
/* 05.06.2001: added some cosmethic changes (no functional change)        */
/* 05.09.2001: improved language detection                                */

/* read command line parameters */
parse arg cddrive

/* load configuration file */
cfgfile = 'updcd.cfg'
do while lines(cfgfile)
	l = linein(cfgfile)
	interpret l
end
rc = lineout(cfgfile)

/* check cddrive value */
if substr(cddrive, 2) = ':' then w4cd = translate(cddrive)

/* make sure they exist */
'@mkdir 'burn' >nul 2>>&1'
'@mkdir 'fixes' >nul 2>>&1'
'@mkdir 'updates' >nul 2>>&1'

/* need to know absolute path */
cdir  	= directory()
burn 		= directory(burn)
cdir  	= directory(cdir)
fixes 	= directory(fixes)
cdir  	= directory(cdir)
updates = directory(updates)
cdir  	= directory(cdir)

/* log file */
if filespec('drive', log) = '' then log	= strip(cdir, 'T', '\')||'\'||log

/* updcd version */
ver = 1.6
n.errors = 0
n.warnings = 0
n.elapsed = time('E')

/* load rexxutil functions we need */
call rxfuncadd sysfiletree, rexxutil, sysfiletree
call rxfuncadd syscurstate, rexxutil, syscurstate

/* remember we were started */
'@echo go4it busy > go4it.bsy'

/* clean up things */
'@mode 80,25 >nul'
'@ansi on >NUL'
say '1B'x || '[36;44m'
say '1B'x || '[1m'
'@cls'
say
say ' Searching for components which can be integrated. Please wait!'
call syscurstate off

/* find fixpaks located in the subdirectory fixes */
say
startdir = fixes
fpk. = ''
rc = lineout(, " Fixpak:    Type:     Directory:")
rc = lineout(, " -------------------------------")
rc = SysFileTree(startdir'\srv_prod.*', ini., "FSO") 
do i = 1 to ini.0
	/* say ini.i */
	do while lines(ini.i)
		l=linein(ini.i)
		if pos('IBM OS/2 Base Operating System', l) > 0 & fpk.os2.fnd <> 1 then do
			fpk.os2.fnd = 1
			fpk.os2.typ = substr(l, pos('XR', l), 7)
			fpk.os2.num = substr(fpk.os2.typ, 5)
			fpk.os2.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.os2.dir = substr(fpk.os2.dir, 1, lastpos('\FIX\', fpk.os2.dir)-1)
			rc = lineout(, " "fpk.os2.typ"    OS/2      "fpk.os2.dir)
			fpk.os2.typ = 'XR'substr(fpk.os2.typ, 4)
			leave
		end
		if pos('IBM OS/2 Base Device Drivers', l) > 0 & fpk.dd.fnd <> 1 then do
			fpk.dd.fnd = 1
			fpk.dd.typ = substr(l, pos('XR', l), 7)
			fpk.dd.num = substr(fpk.dd.typ, 5)
			fpk.dd.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.dd.dir = substr(fpk.dd.dir, 1, lastpos('\FIX\', fpk.dd.dir)-1)
			rc = lineout(, " "fpk.dd.typ  "   Driver    "fpk.dd.dir)
			fpk.dd.typ = 'XR'substr(fpk.dd.typ, 4)
			leave
		end
		if (pos('IBM OS/2 TCP/IP Stack', l) > 0 | pos('IBM OS/2 Socket/Multi-Protocol Transport Services', l) > 0) & fpk.mpt.fnd <> 1 then do
			fpk.mpt.fnd = 1
			fpk.mpt.typ = substr(l, pos('WR', l), 7)
			fpk.mpt.num = substr(fpk.mpt.typ, 4)
			fpk.mpt.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.mpt.dir = substr(fpk.mpt.dir, 1, lastpos('\FIX\', fpk.mpt.dir)-1)
			rc = lineout(, " "fpk.mpt.typ"    MPTS      "fpk.mpt.dir)
			fpk.mpt.typ = 'WR'substr(fpk.mpt.typ, 4)
			leave
		end
		if pos('IBM TCP/IP for Warp', l) > 0 & fpk.tcp.fnd <> 1 then do
			fpk.tcp.fnd = 1
			fpk.tcp.typ = substr(l, pos('UN', l), 7)
			fpk.tcp.num = substr(fpk.tcp.typ, 4)
			fpk.tcp.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.tcp.dir = substr(fpk.tcp.dir, 1, lastpos('\FIX\', fpk.tcp.dir)-1)
			rc = lineout(, " "fpk.tcp.typ"    TCP/IP    "fpk.tcp.dir)
			fpk.tcp.typ = 'UN'substr(fpk.tcp.typ, 4)
			leave
		end
		if pos('IBM TCP/IP Version 3.', l) > 0 & fpk.tcp.fnd <> 1 then do
			fpk.tc2.fnd = 1
			fpk.tc2.typ = substr(l, pos('UN', l), 7)
			fpk.tc2.num = substr(fpk.tc2.typ, 4)
			fpk.tc2.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.tc2.dir = substr(fpk.tc2.dir, 1, lastpos('\FIX\', fpk.tc2.dir)-1)
			rc = lineout(, " "fpk.tc2.typ"    TCP/IP    "fpk.tc2.dir)
			fpk.tc2.typ = 'UN'substr(fpk.tc2.typ, 4)
			leave
		end
	end
	rc = lineout(ini.i)
end

/* find updated products located in the subdirectory updates */
say
startdir = updates
upd. = ''
rc = lineout(, " Update:    Type:     Directory:")
rc = lineout(, " -------------------------------")
rc = SysFileTree(startdir'\syslevel.*', ini., "FSO") 

do i = 1 to ini.0
	/* say ini.i */
	do while lines(ini.i)
		l=linein(ini.i)
		if (pos('IBM OS/2 TCP/IP Stack', l) > 0 | pos('IBM OS/2 Socket/Multi-Protocol Transport Services', l) > 0) & upd.mpt.fnd <> 1 then do
			upd.mpt.fnd = 1
			upd.mpt.typ = substr(l, pos('WR', l), 7)
			upd.mpt.num = substr(upd.mpt.typ, 4)
			upd.mpt.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			upd.mpt.dir = substr(upd.mpt.dir, 1, lastpos('\MPTN', upd.mpt.dir)-1)
			rc = lineout(, " "upd.mpt.typ"    MPTS      "upd.mpt.dir)
			leave
		end
		if pos('IBM TCP/IP', l) > 0 & upd.tcp.fnd <> 1 then do
			upd.tcp.fnd = 1
			upd.tcp.typ = substr(l, pos('UN', l), 7)
			upd.tcp.num = substr(upd.tcp.typ, 4)
			upd.tcp.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			upd.tcp.dir = substr(upd.tcp.dir, 1, lastpos('\INSTALL', upd.tcp.dir)-1)
			rc = lineout(, " "upd.tcp.typ"    TCP/IP    "upd.tcp.dir)
			leave
		end
/*
		if pos('Netscape Communicator 4.61', l) > 0 & upd.nsc.fnd <> 1 then do
			upd.nsc.fnd = 1
			upd.nsc.typ = substr(l, pos('XR', l), 7)
			upd.nsc.num = substr(upd.nsc.typ, 4)
			upd.nsc.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			rc = lineout(, " "upd.nsc.typ"    Netscape  "upd.nsc.dir)
			leave
		end
*/
	end
	rc = lineout(ini.i)
end

/* determining language to use */
ini = w4cd'\os2image\disk_1\syslevel.os2'
if stream(ini, 'c', 'query exists') <> '' then do
	do while lines(ini)
			l=linein(ini)
			if pos('IBM OS/2', l) > 0 then do
				lang = substr(l, pos('XR', l), 3)
				vers = substr(l, pos('XR', l)+3, 4)
			end
	end
	rc = lineout(ini)
end
else do
	Say
	Say ' No CD-ROM found! Exiting...'
	rc = lineout(log, 'Error: No CD-ROM found! Exiting...')
	'@del go4it.bsy >nul 2>>&1'
	exit 9
end

select
	when lang = 'XR0' then lang = 'EN (English)'
	when lang = 'XRG' then lang = 'DE (German)'
	when lang = 'XRN' then lang = 'NO (Norwegian)'
	when lang = 'XRV' then lang = 'TW (Thai)'
	when lang = 'XRF' then lang = 'FR (French)'
	when lang = 'XRI' then lang = 'IT (Italian)'
	when lang = 'XRJ' then lang = 'JP (Japanese)'
	when lang = 'XRK' then lang = 'KO (Korean)'
	when lang = 'XRB' then lang = 'BR (Brazilian)'
	when lang = 'XRC' then lang = 'CN (Chinese)'
	when lang = 'XRS' then lang = 'ES (Spanish)'
	when lang = 'XRD' then lang = 'DK (Danish)'
	when lang = 'XRL' then lang = 'FI (Finnish)'
	when lang = 'XRH' then lang = 'NL (Dutch)'
	when lang = 'XRY' then lang = 'HU (Hungarian)'
	when lang = 'XRR' then lang = 'RU (Russian)'
  when lang = 'XRA' then lang = 'AR (Arabic)'
	otherwise lang = 'Unknown (assuming English for universal products)'
end
rc = lineout(, " Detected language: "lang)

say
say ' Press any key to start the build process or CTRL-C to abort'
'@pause >nul'

/* switch off deldir if set */
ddir = value("DELDIR", , "OS2ENVIRONMENT")
if length(ddir) > 0 then do
	rc = lineout(log, 'Info: Switching off deldir...')
	ddir = value("DELDIR", "", "OS2ENVIRONMENT")
end

'@del 'log' >nul 2>>&1'
rc = lineout(log, 'Info: Searching for fixes and updates...')
rc = lineout(log, 'Info: Found fix 'fpk.os2.typ' OS/2 'fpk.os2.dir)
rc = lineout(log, 'Info: Found fix 'fpk.dd.typ' Driver 'fpk.dd.dir)
rc = lineout(log, 'Info: Found fix 'fpk.mpt.typ' MPTS 'fpk.mpt.dir)
rc = lineout(log, 'Info: Found fix 'fpk.tcp.typ' TCP/IP 'fpk.tcp.dir)
rc = lineout(log, 'Info: Found fix 'fpk.tc2.typ' TCP/IP 'fpk.tc2.dir)
rc = lineout(log, 'Info: Found update 'upd.mpt.typ' MPTS 'upd.mpt.dir)
rc = lineout(log, 'Info: Found update 'upd.tcp.typ' TCP/IP 'upd.tcp.dir)
/* rc = lineout(log, 'Info: Found update 'upd.nsc.typ' Netscape 'upd.nsc.dir) */
rc = lineout(log, 'Info: Detected language: 'lang)
rc = lineout(log)
parse var lang w1 w2
lang = space(w1)
if lang = 'HU' | lang = 'RU' | lang = 'AR' | lang = 'Unknown' then lang = 'EN'

/* check if we have at least the base fixpack */
if fpk.os2.dir = '' then do
	Say 'At least the base OS/2 fixes should be present! Exiting...'
	rc = lineout(log, 'Error: At least the base OS/2 fixes should be present! Exiting...')
	'@del go4it.bsy >nul 2>>&1'
	exit 9
end

/**********************/
/* Clean up old image */
/**********************/

'@cls'
say '1B'x || '[2;2HUpdate OS/2 installation CD-ROM, version 'ver
say '1B'x || '[4;2HTarget directory      : 'burn
say '1B'x || '[5;2HSource directory      : 'burn
say '1B'x || '[7;2HCurrent activity      : 'substr('Cleaning up directory: 'burn, 1, 50)
say '1B'x || '[8;2HTarget object         : 'substr('Searching...', 1, 50)
say '1B'x || '[9;2HSource object         : 'substr('Searching...', 1, 50)
say '1B'x || '[11;2HUpdate action         : 'substr('Searching...', 1, 50)
say '1B'x || '[12;2HUpdate return code    : 0'
say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
say '1B'x || '[15;2HNumber of errors      : 'n.errors
say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
say '1B'x || '[17;2HUpdate log            : 'log
say '1B'x || '[19;2H'

/* clean directories */
call execute '@attrib -r -s -h -a * /s'

/* del eadata */
'@del "'burn'\os2image\disk_0\ea data. sf" >nul 2>>&1'
'@del "'burn'\os2image\disk_1\ea data. sf" >nul 2>>&1'
'@del "'burn'\os2image\disk_2\ea data. sf" >nul 2>>&1'

call deldir burn'\fi' 
call deldir burn'\ecs' 
call deldir burn'\bootimgs' 
call deldir burn'\report' 
call deldir burn'\options' 
call deldir burn'\images' 
call deldir burn'\info'
call deldir burn'\books'
call deldir burn'\os2image'
call deldir burn'\ibminst'
call deldir burn'\cid'
call deldir burn'\diskimgs'
call deldir burn'\updcd'
call deldir burn'\warpsrv'
call deldir burn'\GRPWARE'
call deldir burn'\os2'
call deldir burn'\dos'
call deldir burn'\mmpm2'

/* clean our files in root */
rc = SysFileTree(burn'\*', ini., "FSO",,'**---')  
if stream(burn'\readme.1st',  'c', 'query exists') <> '' then call execute '@del 'burn'\readme.1st'
if stream(burn'\OS2SE20.SRC', 'c', 'query exists') <> '' then call execute '@del 'burn'\OS2SE20.SRC'
if stream(burn'\README.TXT',  'c', 'query exists') <> '' then call execute '@del 'burn'\README.TXT'
if stream(burn'\RSPINST.EXE', 'c', 'query exists') <> '' then call execute '@del 'burn'\RSPINST.EXE'
if stream(burn'\INSTALL.CMD', 'c', 'query exists') <> '' then call execute '@del 'burn'\INSTALL.CMD'
if stream(burn'\CDINST.CMD',  'c', 'query exists') <> '' then call execute '@del 'burn'\CDINST.CMD'
if stream(burn'\CDINST.BAT',  'c', 'query exists') <> '' then call execute '@del 'burn'\CDINST.BAT'
if stream(burn'\DMF_PS2.CMD', 'c', 'query exists') <> '' then call execute '@del 'burn'\DMF_PS2.CMD'
if stream(burn'\makedsks.cmd','c', 'query exists') <> '' then call execute '@del 'burn'\makedsks.CMD'
if stream(burn'\VCU.EXE',     'c', 'query exists') <> '' then call execute '@del 'burn'\VCU.EXE'
if stream(burn'\VCU.MSG',     'c', 'query exists') <> '' then call execute '@del 'burn'\VCU.MSG'
if stream(burn'\chkinst.exe', 'c', 'query exists') <> '' then call execute '@del 'burn'\chkinst.exe'
if stream(burn'\runtime.exe', 'c', 'query exists') <> '' then call execute '@del 'burn'\runtime.exe'
if stream(burn'\README',      'c', 'query exists') <> '' then call execute '@del 'burn'\README'
if stream(burn'\README.INS',  'c', 'query exists') <> '' then call execute '@del 'burn'\README.INS'
if stream(burn'\PRODDSKS.CMD','c', 'query exists') <> '' then call execute '@del 'burn'\PRODDSKS.CMD'
if stream(burn'\SAMPLE.RSP',  'c', 'query exists') <> '' then call execute '@del 'burn'\SAMPLE.RSP'

/* create some directories */
'@mkdir 'burn '>nul 2>&1'
call execute '@mkdir 'burn'\updcd'
call execute '@mkdir 'burn'\updcd\bootimg'
call execute '@mkdir 'burn'\updcd\bootimg\DISK_0_1.IMG'
call execute '@mkdir 'burn'\updcd\bootimg\DISK_2.IMG'

/*************************************/
/* Update installation floppy images */
/*************************************/
say '1B'x || '[4;26H'substr(burn, 1, 50)
say '1B'x || '[5;26H'substr(w4cd, 1, 50)
say '1B'x || '[7;26H'substr('Copying CD-ROM files', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
call execute '@mkdir 'burn'\diskimgs'
call execute '@xcopy 'w4cd'\diskimgs\* 'burn'\diskimgs\. /H/O/T/R/V'
call execute '@mkdir 'burn'\diskimgs\os2'
call execute '@mkdir 'burn'\diskimgs\os2\35'
call execute '@copy 'w4cd'\diskimgs\os2\35\disk0.dsk 'burn'\diskimgs\os2\35\.'
call execute '@copy 'w4cd'\diskimgs\os2\35\disk1_cd.dsk 'burn'\diskimgs\os2\35\.'

/* delete temp stuff from fix */
rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
do i = 1 to ini.0
	call execute '@del 'ini.i
end

/* first copy the stuff we need to the fix directory */
say '1B'x || '[7;26H'substr('Copying base OS/2 fixes', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)

call execute '@xcopy 'fpk.os2.dir'\fix\os2.1\* fix\.'
call execute '@xcopy 'fpk.os2.dir'\fix\os2.2\* fix\.'

if fpk.os2.num > 40 then do
	call execute '@xcopy 'fpk.os2.dir'\fix\mpm.4\* fix\.'
	call execute '@xcopy 'fpk.os2.dir'\fix\os2.5\* fix\.'
	if vers = '3006' then do
		'@rmdir fix\smp >nul 2>>&1'
		call execute '@mkdir fix\smp'
		call execute '@xcopy 'fpk.os2.dir'\fix\os2.3\* fix\smp\.'
	end
end
else do
	call execute '@xcopy 'fpk.os2.dir'\fix\os2.4\* fix\.'
	call execute '@xcopy 'fpk.os2.dir'\fix\mpm.6\* fix\.'
	call execute '@xcopy 'fpk.os2.dir'\fix\os2.7\* fix\.'
	call execute '@xcopy 'fpk.os2.dir'\fix\os2.8\* fix\.'
	if vers = '3006' then do
		'@rmdir fix\smp >nul 2>>&1'
		call execute '@mkdir fix\smp'
		call execute '@xcopy 'fpk.os2.dir'\fix\os2.5\* fix\smp\.'
	end
	if vers = '3002' | vers = '3004' then do
		call execute '@xcopy 'fpk.os2.dir'\fix\os2.3\* fix\.'
	end
end

if fpk.dd.dir <> '' then call execute '@xcopy 'fpk.dd.dir'\fix\bdd.1\*  fix\.'
if fpk.dd.dir <> '' then call execute '@xcopy 'fpk.dd.dir'\fix\bdd.4\*  fix\.'
if fpk.dd.num = 1   then call execute '@xcopy 'fpk.dd.dir'\fix\bdd.5\*  fix\.'

/* then prepare it */
'@del result.out >nul 2>&1'
'@call prpfp fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) ver log vers
res = linein('result.out')
rc = lineout('result.out')
parse var res n.errors n.warnings

/* Some versions of Warp3 does not have these directories */
/* Create them, otherwise we will get a lot of errors     */
'@mkdir 'burn'\os2image                        >nul 2>>&1'
'@mkdir 'burn'\os2image\DMPD2                  >nul 2>>&1'
'@mkdir 'burn'\os2image\SYM_2                  >nul 2>>&1'
'@mkdir 'burn'\os2image\SYM_2\OS2              >nul 2>>&1'
'@mkdir 'burn'\os2image\SYM_2\OS2\SYSTEM       >nul 2>>&1'
'@mkdir 'burn'\os2image\SYM_2\OS2\SYSTEM\TRACE >nul 2>>&1'

/* finally run update */
say '1B'x || '[7;26H'substr('Updating installation floppy images', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
'@del result.out >nul'
'@call updif 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver expert add_dani add_dummy vers
res = linein('result.out')
rc = lineout('result.out')
parse var res n.errors n.warnings 

/* update some drivers in the CD boot image */
call execute '@copy fix\aic7870.add 'burn'\updcd\bootimg\DISK_0_1.IMG'
call execute '@copy fix\BTSCSI.ADD  'burn'\updcd\bootimg\DISK_0_1.IMG'
call execute '@copy fix\DPT20XX.ADD 'burn'\updcd\bootimg\DISK_0_1.IMG'

/* do the rest */
say '1B'x || '[4;26H'substr(burn, 1, 50)
say '1B'x || '[5;26H'substr(w4cd, 1, 50)
say '1B'x || '[7;26H'substr('Copying CD-ROM files', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)

/* find out path to CID products */
cidpath = 'CID\SERVER'
if stream(w4cd'\'cidpath'\tcpapps\base1.zip', 'c', 'query exists') = '' then cidpath = 'CID\IMG'

call execute '@xcopy 'w4cd'\* 'burn'\. /H/O/T/R/V'

if stream(w4cd'\cid\SRVIFS\service.exe', 'c', 'query exists') <> '' then do
	call execute '@mkdir 'burn'\cid'
	call execute '@xcopy 'w4cd'\cid\* 'burn'\cid\. /H/O/T/S/R/V/E'
end

/* find out path to instdir */
instpath = 'warpsrv'
if stream(w4cd'\warpsrv\coninst.exe', 'c', 'query exists') = '' then instpath = 'grpware'
call execute '@mkdir 'burn'\'instpath
call execute '@xcopy 'w4cd'\'instpath'\* 'burn'\'instpath'\. /H/O/T/S/E/R/V'

if stream(w4cd'\info\ws', 'c', 'query exists') <> '' then do
	call execute '@mkdir 'burn'\info'
	call execute '@xcopy 'w4cd'\info\* 'burn'\info\. /H/O/T/S/E/R/V'
end

call execute '@mkdir 'burn'\books'
call execute '@xcopy 'w4cd'\books\* 'burn'\books\. /H/O/T/S/E/R/V'

call execute '@xcopy 'w4cd'\os2image\* 'burn'\os2image\. /H/O/T/S/R/V/E'

if stream(w4cd'\os2\client\install.cmd', 'c', 'query exists') <> '' then do
	call execute '@mkdir 'burn'\os2'
	call execute '@xcopy 'w4cd'\os2\* 'burn'\os2\. /H/O/T/S/R/V/E'
end

if stream(w4cd'\dos\client\install.exe', 'c', 'query exists') <> '' then do
	call execute '@mkdir 'burn'\dos'
	call execute '@xcopy 'w4cd'\dos\* 'burn'\dos\. /H/O/T/S/R/V/E'
end

call execute '@mkdir 'burn'\mmpm2'
call execute '@xcopy 'w4cd'\mmpm2\* 'burn'\mmpm2\. /H/O/T/S/R/V/E'

/* remove RO attribute */
rc = SysFileTree(burn'\*', ini., "FSO",,'**---')  
call execute '@attrib -r -s -h -a 'burn'\* /s'

/********************************************************************/
/* incorporate OS/2 and Device Driver fixpaks and Feature Installer */
/********************************************************************/

/* run update */
'@del result.out >nul'
'@copy basefpk.wp3 basefpk.pin >nul'
if stream('fix\fibase.rsp', 'c', 'query exists') <> '' then call execute '@del fix\fibase.rsp' /* this files seems to cause trouble */
'@call updcd 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver vers
res = linein('result.out')
rc = lineout('result.out')
parse var res n.errors n.warnings 

/* and delete temp stuff from fix */
rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
do i = 1 to ini.0
	call execute '@del 'ini.i
end
if vers = '3006' then call execute '@rmdir fix\smp'

if expert = 0 then do
	say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
	'@pause >nul'
	say '1B'x || '[19;2H                                            '
end

/******************************************/
/* incorporate MPTS replacement and fixes */
/******************************************/

/* find out path to CID products */
mptspath = 'MPTN'
if stream(w4cd'\'cidpath'\laps\mpts.exe', 'c', 'query exists') <> '' then mptspath = 'LAPS'

rc = SysFileTree(burn'\'cidpath'\'mptspath'\*', ini., "FSO",,'**---')  
if upd.mpt.dir <> '' & ini.0 > 0 then do
	/* delete old mpts */
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end

	/* copy replacement mpts */
	say '1B'x || '[7;26H'substr('Copying MPTS update', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@xcopy 'upd.mpt.dir'\* 'burn'\'cidpath'\'mptspath'\. /H/O/T/S/R/V/E'
end

/* add mpts fixpak */
if fpk.mpt.dir <> '' & ini.0 > 0 then do
		/* copy fix */
		say '1B'x || '[7;26H'substr('Copying MPTS fixpak', 1, 50)
		say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
		call execute '@xcopy 'fpk.mpt.dir'\fix\MPT.1\* fix\.'
		call execute '@xcopy 'fpk.mpt.dir'\fix\TRP.2\* fix\.'
		call execute '@xcopy 'fpk.mpt.dir'\fix\DHC.3\* fix\.'
		call execute '@xcopy 'fpk.mpt.dir'\fix\SIF.4\* fix\.'
		call execute '@xcopy 'fpk.mpt.dir'\fix\LCU.5\* fix\.'

		/* then prepare it */
		'@del result.out >nul'
		'@call prpfp fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) ver log
		res = linein('result.out')
		rc = lineout('result.out')
		parse var res n.errors n.warnings 

		/* finally run update */
		'@del result.out >nul'
		'@call updcd 'burn'\'cidpath'\'mptspath' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
		res = linein('result.out')
		rc = lineout('result.out')
		parse var res n.errors n.warnings 

		/* and delete temp stuff from fix */
		rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
		do i = 1 to ini.0
			call execute '@del 'ini.i
		end
end

/* update sniffer */
if stream(burn'\'cidpath'\'MPTSpath'\APPLETS\MPTSAPLT.ZIP', 'c', 'query exists') <> '' then do
	call execute '@unzip -jCo 'burn'\'cidpath'\'MPTSpath'\APPLETS\MPTSAPLT.ZIP APPLETS\OS2SNIFF.EXE  -d 'burn'\'instpath'\. '
	call execute '@unzip -jCo 'burn'\'cidpath'\'MPTSpath'\APPLETS\MPTSAPLT.ZIP APPLETS\NCD.DLL       -d 'burn'\'instpath'\. '
	call execute '@unzip -jCo 'burn'\'cidpath'\'MPTSpath'\APPLETS\MPTSAPLT.ZIP APPLETS\NCD.MSG       -d 'burn'\'instpath'\. '
	call execute '@copy 'burn'\'instpath'\os2sniff.exe 'burn'\'instpath'\clbsniff.exe'
	call execute '@copy 'burn'\'instpath'\ncd.dll 'burn'\'instpath'\clbncd.dll'
end

/* update files in \cid\nif with updated mpts */
if stream(burn'\'cidpath'\'MPTSpath'\ibmcom\protocol\protocol.ZIP', 'c', 'query exists') <> '' then do
	call deldir burn'\cid\nifs'
	call execute '@mkdir 'burn'\cid\nifs'
	call execute '@mkdir 'burn'\cid\nifs\macs'
	call execute '@mkdir 'burn'\cid\nifs\protocol'
	call execute '@unzip -jo 'burn'\'cidpath'\'mptspath'\ibmcom\protocol\protocol.zip -d 'burn'\cid\nifs'
	call execute '@unzip -jo 'burn'\'cidpath'\'mptspath'\ibmcom\protocol\protocol.zip -d 'burn'\cid\nifs\protocol'
	call execute '@unzip -jo 'burn'\'cidpath'\'mptspath'\ibmcom\macs\macs.zip         -d 'burn'\cid\nifs'
	call execute '@unzip -jo 'burn'\'cidpath'\'mptspath'\ibmcom\macs\macs.zip         -d 'burn'\cid\nifs\macs'
end

if expert = 0 & ini.0 > 0 then do
		say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
		'@pause >nul'
		say '1B'x || '[19;2H                                            '
end

/*****************************/
/* incorporate Netscape 4.61 */
/*****************************/

if upd.nsc.dir <> '' then do
	say '1B'x || '[7;26H'substr('Copying Netscape', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	/* delete old netscape but preserve fi plug-in */
	call execute '@copy 'burn'\'cidpath'\netscape\npfi.dll fix\.'
	rc = SysFileTree(burn'\'cidpath'\netscape\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end
	call execute '@copy fix\npfi.dll 'burn'\'cidpath'\netscape\.'
	call execute '@del fix\npfi.dll'

	/* copy files we need */
	call execute '@copy newinst\netscape.rsp 'burn'\'instpath'\tables'
	call execute '@xcopy 'upd.nsc.dir'\* 'burn'\'cidpath'\netscape /H/O/T/S/R/V/E'
end


/******************************/
/* incorporate 32-bits TCP/IP */
/******************************/

if upd.tcp.dir <> '' then do
	/* delete old TCP/IP */
	rc = SysFileTree(burn'\'cidpath'\tcpapps\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end

	/* copy new one */
	say '1B'x || '[7;26H'substr('Copying TCP/IP', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@xcopy 'upd.tcp.dir'\* 'burn'\'cidpath'\tcpapps /H/O/T/S/R/V/E'

	/* add new response file */
	call execute '@copy newinst\tcpip.rsp 'burn'\'instpath'\tables'

	/* add new mkrsp.cmd */
	call execute '@copy newinst\mkrsp.wsb 'burn'\'instpath'\mkrsp.cmd'
end

/*****************************/
/* incorporate TCP/IP fixpak */
/*****************************/

if fpk.tcp.dir <> '' then do

	/* apply 16-bits fixpaks on original Warp 3.x TCP/IP */
	if upd.tcp.dir = '' & stream(burn'\'cidpath'\tcpapps\base1.zip', 'c', 'query exists') <> '' then do
		/* copy fix */
		say '1B'x || '[7;26H'substr('Copying TCP/IP fixpak', 1, 50)
		say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
		call execute '@xcopy 'fpk.tc2.dir'\fix\TCP.1\* fix\.'
		select
			when lang = 'DK' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.5\* fix\.'
			end
			when lang = 'DE' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.6\* fix\.'
			end
			when lang = 'ES' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.7\* fix\.'
			end
			when lang = 'FI' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.8\* fix\.'
			end
			when lang = 'FR' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.9\* fix\.'
			end
			when lang = 'IT' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.10\* fix\.'
			end
			when lang = 'JP' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.11\* fix\.'
			end
			when lang = 'KO' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.12\* fix\.'
			end
			when lang = 'NL' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.13\* fix\.'
			end
			when lang = 'NO' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.14\* fix\.'
			end
			when lang = 'BR' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.15\* fix\.'
			end
			otherwise nop;
		end
		/* TCP.1 is always needed */
		call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.1\* fix\.'
	
		/* do not update rsp */
		call execute '@del fix\default.rs_'

		/* then prepare it */
		'@del result.out >nul'
		'@call prpfp fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) ver log
		res = linein('result.out')
		rc = lineout('result.out')
		parse var res n.errors n.warnings 
	
		/* finally run update */
		'@del result.out >nul'
		if cidpath = 'CID\SERVER' then '@copy tcppfpk.wps tcppfpk.pin >nul'
		else '@copy tcppfpk.wp3 tcppfpk.pin >nul'
		'@call updcd 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
		res = linein('result.out')
		rc = lineout('result.out')
		parse var res n.errors n.warnings 
	
		/* and delete temp stuff from fix */
		rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
		do i = 1 to ini.0
			call execute '@del 'ini.i
		end
	
		/* do some postprocessing for non English TCP/IP */
		if lang <> 'EN' then do
			/* copy language dependent DLL's to fix */
			select
				when lang = 'DK' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.5\cnb*.dl_ fix\.'
					path = 'MSG\DADK850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.5\srv_prod.??? fix\.'
				end
				when lang = 'DE' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.6\cnb*.dl_ fix\.'
					path = 'MSG\DEDE850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.6\srv_prod.??? fix\.'
				end
				when lang = 'ES' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.7\cnb*.dl_ fix\.'
					path = 'MSG\ESES850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.7\srv_prod.??? fix\.'
				end
				when lang = 'FI' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.8\cnb*.dl_ fix\.'
					path = 'MSG\FIFI850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.8\srv_prod.??? fix\.'
				end
				when lang = 'FR' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.9\cnb*.dl_ fix\.'
					path = 'MSG\FRFR850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.9\srv_prod.??? fix\.'
				end
				when lang = 'IT' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.10\cnb*.dl_ fix\.'
					path = 'MSG\ITIT850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.10\srv_prod.??? fix\.'
				end
				when lang = 'JP' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.11\cnb*.dl_ fix\.'
					path = 'MSG\JAJP932'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.11\srv_prod.??? fix\.'
				end
				when lang = 'KO' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.12\cnb*.dl_ fix\.'
					path = 'MSG\KOKR949'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.12\srv_prod.??? fix\.'
				end
				when lang = 'NL' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.13\cnb*.dl_ fix\.'
					path = 'MSG\NLNL850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.13\srv_prod.??? fix\.'
				end
				when lang = 'NO' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.14\cnb*.dl_ fix\.'
					path = 'MSG\NONO850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.14\srv_prod.??? fix\.'
				end
				when lang = 'BR' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.15\cnb*.dl_ fix\.'
					path = 'MSG\PTBR850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.15\srv_prod.??? fix\.'
				end
				otherwise nop;
			end
	
			/* then prepare it */
			'@del result.out >nul'
			'@call prpfp fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) ver log
			res = linein('result.out')
			rc = lineout('result.out')
			parse var res n.errors n.warnings 
		
			/* add them to base3.zip */
			call execute '@mkdir tmp'
			call execute '@unzip -o 'burn'\'cidpath'\tcpapps\base3.zip -d tmp'
			call execute '@cd tmp'
			call execute '@xcopy ..\fix\* 'path
			call execute '@..\zip.exe -mkr 'burn'\'cidpath'\tcpapps\base3.zip *'
			call execute '@cd ..'
			call execute '@rmdir tmp'
	
			/* and delete temp stuff from fix */
			rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
			do i = 1 to ini.0
				call execute '@del 'ini.i
			end
		end
	end
end

if expert = 0 then do
		say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
		'@pause >nul'
		say '1B'x || '[19;2H                                            '
end

/************************/
/* add UPDCD info to CD */
/************************/

call execute '@mkdir 'burn'\updcd\bin'
call execute '@copy *.cm? 'burn'\updcd\bin\.'
call execute '@copy *.exe 'burn'\updcd\bin\.'
call execute '@copy *.dll 'burn'\updcd\bin\.'
call execute '@copy *.msg 'burn'\updcd\bin\.'
call execute '@copy *.cfg 'burn'\updcd\bin\.'
call execute '@copy cd2boot   'burn'\updcd\bin\.'
call execute '@copy pmfaxlt.* 'burn'\updcd\bin\.'
call execute '@copy basefpk.* 'burn'\updcd\bin\.'
call execute '@copy mptsfpk.* 'burn'\updcd\bin\.'
call execute '@copy tcppfpk.* 'burn'\updcd\bin\.'
call execute '@copy peerfpk.* 'burn'\updcd\bin\.'
call execute '@mkdir 'burn'\updcd\doc'
call execute '@copy *.txt 'burn'\updcd\doc\.'
call execute '@copy readme.* 'burn'\updcd\doc\.'
call execute '@mkdir 'burn'\updcd\addons'
/* call execute '@xcopy addons\* 'burn'\updcd\addons\. /S/O/T/R/E/H' */
call execute '@mkdir 'burn'\updcd\log'
rc = lineout(log, 'Info: Total number of errors  : 'n.errors)
rc = lineout(log, 'Info: Total number of warnings: 'n.warnings)
rc = lineout(log)
'@copy *.log 'burn'\updcd\log\. >nul 2>>&1'

/***********/
/* burn CD */
/***********/

if stream(cdrprg, 'c', 'query exists') <> '' then do
	say '1B'x || '[7;26H'substr('Calling script 'cdrprg' to burn CD.', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	say '1B'x || '[19;2H'
	'@call 'cdrprg n.errors n.warnings
end

/***********************/
/* clean up and report */
/***********************/
'@del result.out >nul'

/* signal fatal errors */
if n.errors > 0 then 	say '1B'x || '[19;2HThere were one or more errors detected, Check 'log'!'
else say '1B'x || '[19;2HUpdate is completed succesfully!'

'@del go4it.bsy >nul 2>>&1'
exit


/* delete directory */
DelDir: procedure expose n. log

	parse arg Directory
	DirSpec = Directory || '\*'

	/* delete subdirectories */
	rc = SysFileTree(DirSpec, Subdirs, 'DO', '*****', '-*---')
	do i = 1 to Subdirs.0
   		call DelDir Subdirs.i
	end

	/* delete files */
	rc = SysFileTree(DirSpec, Files, 'FO', '*****', '-*---')
	do i = 1 to Files.0
      call execute '@del 'Files.i
  end

	/* delete directory */
	cdir = directory()
	d = directory(Directory)
	cdir = directory(cdir)
	if d <> '' then call execute '@rmdir 'Directory

return

/* execute command, display it and write to log */ 
execute: procedure expose log n. iddir

	parse arg comm 
	rcode = 0

	parse upper var comm comm1 comm2 comm3 comm4 rest
	/* do not copy or pack if file does not exist */
	rc = SysFileTree(comm2, 'tmp.', "FSO") 
	if (comm1 <> '@COPY' & comm1 <> '@PACK2' & comm1 <> '@DEL' & comm1 <> '@XCOPY') | (stream(comm2, 'c', 'query exists') <> '') | (tmp.0 > 0) then do
		comm' >nul 2>>&1'
		if rc <> 0 then rcode = rc
	end
	else do /* log warning */
		rc = lineout(log, 'Warning: 'comm2' does not exist!')
		n.warnings = n.warnings + 1
		call report_status
		return
	end
	comm = comm ||' rc='rcode

	if comm1 = '@..\ZIP.EXE' then do	
		say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(comm3), 1, 50))), 1, 50)
		say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(comm4), 1, 50))), 1, 50)
		say '1B'x || '[11;26HZip         '
	end
	else if comm1 = '@MKDIR' | comm1 = '@RMDIR' | comm1 = '@CD' then do	
		nop;
	end
	else if comm1 = '@UNZIP' then do	
		say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(rest), 1, 50))), 1, 50)
		say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(comm3), 1, 50))), 1, 50)
		say '1B'x || '[11;26HUnzip         '
	end
	else do 
		say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(comm3), 1, 50))), 1, 50)
		say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(comm2), 1, 50))), 1, 50)
		say '1B'x || '[11;26H'substr(comm1, 2, 50)
	end
	say '1B'x || '[12;26H'rcode' '

	if rcode <> 0 then do
		rc = lineout(log, 'Error: 'comm)
		rc = lineout(log)
		n.errors = n.errors + 1
	end
	else do
		rc = lineout(log, 'Info: 'comm)
		rc = lineout(log)
	end

	call report_status

return rcode

/* display status */
report_status: procedure expose n. 

	say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
	say '1B'x || '[15;2HNumber of errors      : 'n.errors
	say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
	say '1B'x || '[19;2H'

return

