/* 08.14.2000: automatic update procedure, version 0.1                       */
/* 09.01.2000: added netware support, floppy update, improved error logging  */
/* 09.10.2000: fixed problem with incorporating un_0980 for non English Warp */
/* 09.19.2000: fixed problem with java response file                         */
/* 09.24.2000: preliminary support bootable CD added                         */
/* 09.30.2000: few small improvements, bug fixing                            */
/* 10.01.2000: added support for printer driver fixes                        */
/* 10.07.2000: small bug fixes                                               */
/* 10.25.2000: added support for 32-bits tcp/ip fixpks                       */
/* 11.03.2000: added support for java 1.1.x fixes                            */
/* 11.08.2000: settings moved to configuration file                          */
/* 11.15.2000: NLS tcp/ip syslevel files updated now                         */
/* 11.17.2000: FI plug-in moved to netscape directory                        */
/* 12.04.2000: minor bug fixes                                               */
/* 12.08.2000: alignment with PM interface                                   */
/* 12.13.2000: added replacement of npconfig.exe                             */
/* 01.03.2001: Checking and switching off deldir                             */
/* 01.14.2001: added handling addons.cfg                                     */
/* 01.28.2001: fixed bug in handling log file name                           */
/* 02.24.2001: added code for handling new database.txt                      */
/*             fixed red-screen problem with installing from the CD-ROM      */
/* 02.27.2001: added support for updated boot disks and PMFax lite           */ 
/* 03.03.2001: added copying of tunecfg.cmd to ibminst                       */
/* 03.24.2001: changed calling record.cmd and added support for freetype.dll */
/* 03.25.2001: fixed problem with updating sniffer                           */
/* 03.31.2001: added updated printer list                                    */
/* 04.07.2001: added extra paramaters to control dani ide and dummy drivers  */
/* 04.26.2001: added support for the removal of java 1.0.2                   */
/* 04.29.2001: added improved version of tunecfg which uses a macro language */
/* 05.06.2001: fixes needed for IP08603 (LS fixpak for Wseb)                 */
/* 05.09.2001: improved language detection                                   */

/* read command line parameters */
parse arg cddrive

/* load configuration file */
cfgfile = 'updcd.cfg'
do while lines(cfgfile)
	l = linein(cfgfile)
	interpret l
end
rc = lineout(cfgfile)

/* check cddrive value */
if substr(cddrive, 2) = ':' then w4cd = translate(cddrive)

/* make sure they exist */
'@mkdir 'burn' >nul 2>>&1'
'@mkdir 'fixes' >nul 2>>&1'
'@mkdir 'updates' >nul 2>>&1'

/* need to know absolute path */
cdir  	= directory()
burn 		= directory(burn)
cdir  	= directory(cdir)
fixes 	= directory(fixes)
cdir  	= directory(cdir)
updates = directory(updates)
cdir  	= directory(cdir)

/* log file */
if filespec('drive', log) = '' then log	= strip(cdir, 'T', '\')||'\'||log

/* updcd version */
ver = 1.6
n.errors = 0
n.warnings = 0
n.elapsed = time('E')

/* load rexxutil functions we need */
call rxfuncadd sysfiletree, rexxutil, sysfiletree
call rxfuncadd syscurstate, rexxutil, syscurstate

/* remember we were started */
'@echo go4it busy > go4it.bsy'

/* clean up things */
'@mode 80,25 >nul'
'@ansi on >NUL'
say '1B'x || '[36;44m'
say '1B'x || '[1m'
'@cls'
say
say ' Searching for components which can be integrated. Please wait!'
call syscurstate off

/* find fixpaks located in the subdirectory fixes */
say
startdir = fixes
fpk. = ''
rc = lineout(, " Fixpak:    Type:     Directory:")
rc = lineout(, " -------------------------------")
rc = SysFileTree(startdir'\srv_prod.*', ini., "FSO") 
do i = 1 to ini.0
	/* say ini.i */
	do while lines(ini.i)
		l=linein(ini.i)
		if pos('IBM OS/2 Base Operating System', l) > 0 & fpk.os2.fnd <> 1 then do
			fpk.os2.fnd = 1
			fpk.os2.typ = substr(l, pos('XR', l), 7)
			fpk.os2.num = substr(fpk.os2.typ, 5)
			fpk.os2.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.os2.dir = substr(fpk.os2.dir, 1, lastpos('\FIX\', fpk.os2.dir)-1)
			rc = lineout(, " "fpk.os2.typ"    OS/2      "fpk.os2.dir)
			fpk.os2.typ = 'XR'substr(fpk.os2.typ, 4)
			leave
		end
		if pos('IBM OS/2 Base Device Drivers', l) > 0 & fpk.dd.fnd <> 1 then do
			fpk.dd.fnd = 1
			fpk.dd.typ = substr(l, pos('XR', l), 7)
			fpk.dd.num = substr(fpk.dd.typ, 5)
			fpk.dd.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.dd.dir = substr(fpk.dd.dir, 1, lastpos('\FIX\', fpk.dd.dir)-1)
			rc = lineout(, " "fpk.dd.typ  "   Driver    "fpk.dd.dir)
			fpk.dd.typ = 'XR'substr(fpk.dd.typ, 4)
			leave
		end
		if pos('IBM OS/2 LAN Requester', l) > 0 & fpk.per.fnd <> 1 then do
			fpk.per.fnd = 1
			fpk.per.typ = substr(l, pos('IP', l), 7)
			fpk.per.num = substr(fpk.per.typ, 4)
			fpk.per.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.per.dir = substr(fpk.per.dir, 1, lastpos('\FIX\', fpk.per.dir)-1)
			rc = lineout(, " "fpk.per.typ"    PEER      "fpk.per.dir)
			fpk.per.typ = 'IP'substr(fpk.per.typ, 4)
			leave
		end
		if (pos('IBM OS/2 TCP/IP Stack', l) > 0 | pos('IBM OS/2 Socket/Multi-Protocol Transport Services', l) > 0) & fpk.mpt.fnd <> 1 then do
			fpk.mpt.fnd = 1
			fpk.mpt.typ = substr(l, pos('WR', l), 7)
			fpk.mpt.num = substr(fpk.mpt.typ, 4)
			fpk.mpt.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.mpt.dir = substr(fpk.mpt.dir, 1, lastpos('\FIX\', fpk.mpt.dir)-1)
			rc = lineout(, " "fpk.mpt.typ"    MPTS      "fpk.mpt.dir)
			fpk.mpt.typ = 'WR'substr(fpk.mpt.typ, 4)
			leave
		end
		if pos('IBM TCP/IP for Warp', l) > 0 & fpk.tcp.fnd <> 1 then do
			fpk.tcp.fnd = 1
			fpk.tcp.typ = substr(l, pos('UN', l), 7)
			fpk.tcp.num = substr(fpk.tcp.typ, 4)
			fpk.tcp.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.tcp.dir = substr(fpk.tcp.dir, 1, lastpos('\FIX\', fpk.tcp.dir)-1)
			rc = lineout(, " "fpk.tcp.typ"    TCP/IP    "fpk.tcp.dir)
			fpk.tcp.typ = 'UN'substr(fpk.tcp.typ, 4)
			leave
		end
	end
	rc = lineout(ini.i)
end

/* find java fixpak */
rc = SysFileTree(startdir'\syslevel.jav', ini., "FSO") 
do i = 1 to ini.0
	do while lines(ini.i)
		l=linein(ini.i)
		if pos('Java Runtime', l) > 0 & fpk.jav.fnd <> 1 then do
			fpk.jav.fnd = 1
			fpk.jav.typ = substr(l, pos('XR', l), 7)
			fpk.jav.num = substr(fpk.jav.typ, 4)
			fpk.jav.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			fpk.jav.dir = translate(substr(fpk.jav.dir, 1, lastpos('\', fpk.jav.dir)-1))
			rc = lineout(, " "fpk.jav.typ"    JAVA      "fpk.jav.dir)
			leave
		end
	end
	rc = lineout(ini.i)
end

/* find netware fixpak (has no syslevel) */
rc = SysFileTree(startdir'\nwunpack.exe', ini., "FSO") 
do i = 1 to ini.0
		fpk.nwr.fnd = 1
		fpk.nwr.typ = '2.12'
		fpk.nwr.num = '212'
		fpk.nwr.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
		rc = lineout(, " "fpk.nwr.typ"       NWREQ     "fpk.nwr.dir)
		fpk.nwr.typ = '2.12'
		leave
end

/* find printer driver fixpak (has no syslevel) */
rc = SysFileTree(startdir'\*.sym', ini., "FSO") 
do i = 1 to ini.0
		fpk.pdd.fnd = 1
		fpk.pdd.typ = 'Printer'
		fpk.pdd.num = 0
		fpk.pdd.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
		rc = lineout(, " "fpk.pdd.typ"    Driver    "fpk.pdd.dir)
		leave
end

/* find updated products located in the subdirectory updates */
say
startdir = updates
upd. = ''
rc = lineout(, " Update:    Type:     Directory:")
rc = lineout(, " -------------------------------") 
rc = SysFileTree(startdir'\syslevel.*', ini., "FSO") 

do i = 1 to ini.0
	/* say ini.i */
	do while lines(ini.i)
		l=linein(ini.i)
		if (pos('IBM OS/2 TCP/IP Stack', l) > 0 | pos('IBM OS/2 Socket/Multi-Protocol Transport Services', l) > 0) & upd.mpt.fnd <> 1 then do
			upd.mpt.fnd = 1
			upd.mpt.typ = substr(l, pos('WR', l), 7)
			upd.mpt.num = substr(upd.mpt.typ, 4)
			upd.mpt.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			upd.mpt.dir = substr(upd.mpt.dir, 1, lastpos('\MPTN', upd.mpt.dir)-1)
			rc = lineout(, " "upd.mpt.typ"    MPTS      "upd.mpt.dir)
			leave
		end
		if pos('IBM TCP/IP', l) > 0 & upd.tcp.fnd <> 1 then do
			upd.tcp.fnd = 1
			upd.tcp.typ = substr(l, pos('UN', l), 7)
			upd.tcp.num = substr(upd.tcp.typ, 4)
			upd.tcp.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			upd.tcp.dir = substr(upd.tcp.dir, 1, lastpos('\INSTALL', upd.tcp.dir)-1)
			rc = lineout(, " "upd.tcp.typ"    TCP/IP    "upd.tcp.dir)
			leave
		end
		if (pos('Java Runtime', l) > 0 | pos('JDK Runtime', l) > 0) & upd.jav.fnd <> 1 then do
			upd.jav.fnd = 1
			upd.jav.typ = substr(l, pos('XR', l), 7)
			upd.jav.num = substr(upd.jav.typ, 4)
			upd.jav.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			rc = lineout(, " "upd.jav.typ"    JAVA      "upd.jav.dir)
			leave
		end
		if pos('IBM OS/2 Feature Install', l) > 0 & upd.fii.fnd <> 1 then do
			upd.fii.fnd = 1
			upd.fii.typ = substr(l, pos('XR', l), 7)
			upd.fii.num = substr(upd.fii.typ, 4)
			upd.fii.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			rc = lineout(, " "upd.fii.typ"    FI        "upd.fii.dir)
			leave
		end
		if pos('Netscape Communicator 4.61', l) > 0 & upd.nsc.fnd <> 1 then do
			upd.nsc.fnd = 1
			upd.nsc.typ = substr(l, pos('XR', l), 7)
			upd.nsc.num = substr(upd.nsc.typ, 4)
			upd.nsc.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
			rc = lineout(, " "upd.nsc.typ"    Netscape  "upd.nsc.dir)
			leave
		end
	end
	rc = lineout(ini.i)
end

/* find floppy update (has no syslevel) */
rc = SysFileTree(startdir'\config.sys', ini., "FSO") 
do i = 1 to ini.0
		upd.fd1.fnd = 1
		upd.fd1.typ = 'DISK1'
		upd.fd1.num = 0
		upd.fd1.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
		rc = lineout(, " "upd.fd1.typ"      BDISK     "upd.fd1.dir)
		leave
end
rc = SysFileTree(startdir'\sysinst2.exe', ini., "FSO") 
do i = 1 to ini.0
		upd.fd2.fnd = 1
		upd.fd2.typ = 'DISK2'
		upd.fd2.num = 0
		upd.fd2.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
		rc = lineout(, " "upd.fd2.typ"      BDISK     "upd.fd2.dir)
		leave
end

/* find pmfax lite update (has no syslevel) */
rc = SysFileTree(startdir'\FxPrint.drv', ini., "FSO") 
do i = 1 to ini.0
		upd.fax.fnd = 1
		upd.fax.typ = 'PMFAX'
		upd.fax.num = 0
		upd.fax.dir = translate(substr(ini.i, 1, lastpos('\', ini.i)-1))
		rc = lineout(, " "upd.fax.typ"      BPACK     "upd.fax.dir)
		leave
end

/* find addons and Warp 4 FI products */
say
if stream('addons\read.me', 'c', 'query exists') <> '' then do
			call sysfiletree 'addons\*', 'ini.', 'DO'
			rc = lineout(, ' Found 'ini.0-2' add-on products in 'directory()||'\ADDONS')
end
if stream('fi\fibase.rsp', 'c', 'query exists') <> '' then do
			call sysfiletree 'fi\*', 'ini.', 'DO'
			/* rc = lineout(, ' Found 'ini.0-1' Warp 4 Feature Installer products in 'directory()||'\FI') */
end

/* determining language to use */
ini = w4cd'\os2image\disk_2\syslevel.os2'
if stream(ini, 'c', 'query exists') <> '' then do
	do while lines(ini)
			l=linein(ini)
			if pos('IBM OS/2', l) > 0 then do
				lang = substr(l, pos('XR', l), 3)
				/* say lang */
			end
	end
	rc = lineout(ini)
end
else do
	Say
	Say ' No CD-ROM found! Exiting...'
	rc = lineout(log, 'Error: No CD-ROM found! Exiting...')
	'@del go4it.bsy >nul 2>>&1'
	exit 9
end

select
	when lang = 'XR0' then lang = 'EN (English)'
	when lang = 'XRG' then lang = 'DE (German)'
	when lang = 'XRN' then lang = 'NO (Norwegian)'
	when lang = 'XRV' then lang = 'TW (Thai)'
	when lang = 'XRF' then lang = 'FR (French)'
	when lang = 'XRI' then lang = 'IT (Italian)'
	when lang = 'XRJ' then lang = 'JP (Japanese)'
	when lang = 'XRK' then lang = 'KO (Korean)'
	when lang = 'XRB' then lang = 'BR (Brazilian)'
	when lang = 'XRC' then lang = 'CN (Chinese)'
	when lang = 'XRS' then lang = 'ES (Spanish)'
	when lang = 'XRD' then lang = 'DK (Danish)'
	when lang = 'XRL' then lang = 'FI (Finnish)'
	when lang = 'XRH' then lang = 'NL (Dutch)'
	when lang = 'XRY' then lang = 'HU (Hungarian)'
	when lang = 'XRR' then lang = 'RU (Russian)'
  when lang = 'XRA' then lang = 'AR (Arabic)'
	otherwise lang = 'Unknown (assuming English for universal products)'
end
rc = lineout(, " Detected language: "lang)

say ' Press any key to start the build process or CTRL-C to abort'
'@pause >nul'

/* switch off deldir if set */
ddir = value("DELDIR", , "OS2ENVIRONMENT")
if length(ddir) > 0 then do
	rc = lineout(log, 'Info: Switching off deldir...')
	ddir = value("DELDIR", "", "OS2ENVIRONMENT")
end

'@del 'log' >nul 2>>&1'
rc = lineout(log, 'Info: Searching for fixes and updates...')
rc = lineout(log, 'Info: Found fix 'fpk.os2.typ' OS/2 'fpk.os2.dir)
rc = lineout(log, 'Info: Found fix 'fpk.dd.typ' Driver 'fpk.dd.dir)
rc = lineout(log, 'Info: Found fix 'fpk.per.typ' PEER 'fpk.per.dir)
rc = lineout(log, 'Info: Found fix 'fpk.mpt.typ' MPTS 'fpk.mpt.dir)
rc = lineout(log, 'Info: Found fix 'fpk.tcp.typ' TCP/IP 'fpk.tcp.dir)
rc = lineout(log, 'Info: Found fix 'fpk.nwr.typ' Netware 'fpk.nwr.dir)
rc = lineout(log, 'Info: Found fix 'fpk.pdd.typ' Printer 'fpk.pdd.dir)
rc = lineout(log, 'Info: Found fix 'fpk.jav.typ' JAVA    'fpk.jav.dir)
rc = lineout(log, 'Info: Found update 'upd.mpt.typ' MPTS 'upd.mpt.dir)
rc = lineout(log, 'Info: Found update 'upd.tcp.typ' TCP/IP 'upd.tcp.dir)
rc = lineout(log, 'Info: Found update 'upd.jav.typ' JAVA 'upd.jav.dir)
rc = lineout(log, 'Info: Found update 'upd.fii.typ' FI 'upd.fii.dir)
rc = lineout(log, 'Info: Found update 'upd.nsc.typ' Netscape 'upd.nsc.dir)
rc = lineout(log, 'Info: Found update 'upd.fd1.typ' DISK1 'upd.fd1.dir)
rc = lineout(log, 'Info: Found update 'upd.fd2.typ' DISK2 'upd.fd2.dir)
rc = lineout(log, 'Info: Found update 'upd.fax.typ' PMFAX 'upd.fax.dir)
rc = lineout(log, 'Info: Detected language: 'lang)
rc = lineout(log)
parse var lang w1 w2
lang = space(w1)
if lang = 'HU' | lang = 'RU' | lang = 'AR' | lang = 'Unknown' then lang = 'EN'

/* check if we have at least the base fixes */
if fpk.dd.dir = '' | fpk.os2.dir = '' then do
	Say 'At least the base OS/2 fixes should be present! Exiting...'
	rc = lineout(log, 'Error: At least the base OS/2 fixes should be present! Exiting...')
	'@del go4it.bsy >nul 2>>&1'
	exit 9
end

/**********************/
/* Clean up old image */
/**********************/

'@cls'
say '1B'x || '[2;2HUpdate OS/2 installation CD-ROM, version 'ver
say '1B'x || '[4;2HTarget directory      : 'burn
say '1B'x || '[5;2HSource directory      : 'burn
say '1B'x || '[7;2HCurrent activity      : 'substr('Cleaning up directory: 'burn, 1, 50)
say '1B'x || '[8;2HTarget object         : 'substr('Searching...', 1, 50)
say '1B'x || '[9;2HSource object         : 'substr('Searching...', 1, 50)
say '1B'x || '[11;2HUpdate action         : 'substr('Searching...', 1, 50)
say '1B'x || '[12;2HUpdate return code    : 0'
say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
say '1B'x || '[15;2HNumber of errors      : 'n.errors
say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
say '1B'x || '[17;2HUpdate log            : 'log
say '1B'x || '[19;2H'

/* clean directories */
call execute '@attrib -r -s -h -a * /s'

/* del eadata */
'@del "'burn'\os2image\disk_0\ea data. sf" >nul 2>>&1'
'@del "'burn'\os2image\disk_1\ea data. sf" >nul 2>>&1'
'@del "'burn'\os2image\disk_2\ea data. sf" >nul 2>>&1'

call deldir burn'\fi' 
call deldir burn'\ecs' 
call deldir burn'\bootimgs' 
call deldir burn'\report' 
call deldir burn'\options' 
call deldir burn'\images' 
call deldir burn'\info'
call deldir burn'\books'
call deldir burn'\os2image'
call deldir burn'\ibminst'
call deldir burn'\cid'
call deldir burn'\diskimgs'
call deldir burn'\updcd'
call deldir burn'\warpsrv'
call deldir burn'\GRPWARE'
call deldir burn'\os2'
call deldir burn'\dos'
call deldir burn'\mmpm2'

/* clean our files in root */
rc = SysFileTree(burn'\*', ini., "FSO",,'**---')  
if stream(burn'\readme.1st',  'c', 'query exists') <> '' then call execute '@del 'burn'\readme.1st'
if stream(burn'\OS2SE20.SRC', 'c', 'query exists') <> '' then call execute '@del 'burn'\OS2SE20.SRC'
if stream(burn'\README',      'c', 'query exists') <> '' then call execute '@del 'burn'\README'
if stream(burn'\README.INS',  'c', 'query exists') <> '' then call execute '@del 'burn'\README.INS'
if stream(burn'\RSPINST.EXE', 'c', 'query exists') <> '' then call execute '@del 'burn'\RSPINST.EXE'
if stream(burn'\PRODDSKS.CMD','c', 'query exists') <> '' then call execute '@del 'burn'\PRODDSKS.CMD'
if stream(burn'\INSTALL.CMD', 'c', 'query exists') <> '' then call execute '@del 'burn'\INSTALL.CMD'
if stream(burn'\SAMPLE.RSP',  'c', 'query exists') <> '' then call execute '@del 'burn'\SAMPLE.RSP'
if stream(burn'\CDINST.CMD',  'c', 'query exists') <> '' then call execute '@del 'burn'\CDINST.CMD'
if stream(burn'\CDINST.BAT',  'c', 'query exists') <> '' then call execute '@del 'burn'\CDINST.BAT'
if stream(burn'\DMF_PS2.CMD', 'c', 'query exists') <> '' then call execute '@del 'burn'\DMF_PS2.CMD'
if stream(burn'\VCU.EXE',     'c', 'query exists') <> '' then call execute '@del 'burn'\VCU.EXE'
if stream(burn'\VCU.MSG',     'c', 'query exists') <> '' then call execute '@del 'burn'\VCU.MSG'
if stream(burn'\chkinst.exe', 'c', 'query exists') <> '' then call execute '@del 'burn'\chkinst.exe'
if stream(burn'\readme.txt',  'c', 'query exists') <> '' then call execute '@del 'burn'\readme.txt'
if stream(burn'\runtime.exe', 'c', 'query exists') <> '' then call execute '@del 'burn'\runtime.exe'
if stream(burn'\makedsks.cmd','c', 'query exists') <> '' then call execute '@del 'burn'\makedsks.CMD'

/* create some directories */
'@mkdir 'burn '>nul 2>&1'
call execute '@mkdir 'burn'\updcd'
call execute '@mkdir 'burn'\updcd\bootimg'
call execute '@mkdir 'burn'\updcd\bootimg\DISK_0_1.IMG'
call execute '@mkdir 'burn'\updcd\bootimg\DISK_2.IMG'

/* delete temp stuff from fix */
rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
do i = 1 to ini.0
	call execute '@del 'ini.i
end

/*************************************/
/* Update installation floppy images */
/*************************************/
say '1B'x || '[4;26H'substr(burn, 1, 50)
say '1B'x || '[5;26H'substr(w4cd, 1, 50)
say '1B'x || '[7;26H'substr('Copying CD-ROM files', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
call execute '@mkdir 'burn'\diskimgs'
call execute '@xcopy 'w4cd'\diskimgs\* 'burn'\diskimgs\. /H/O/T/R/V'
call execute '@mkdir 'burn'\diskimgs\os2'
call execute '@mkdir 'burn'\diskimgs\os2\35'
call execute '@copy 'w4cd'\diskimgs\os2\35\disk0.dsk 'burn'\diskimgs\os2\35\.'
call execute '@copy 'w4cd'\diskimgs\os2\35\disk1_cd.dsk 'burn'\diskimgs\os2\35\.'
call execute '@copy 'w4cd'\diskimgs\os2\35\disk2.dsk 'burn'\diskimgs\os2\35\.'

/* first copy the stuff we need to the fix directory */
say '1B'x || '[7;26H'substr('Copying base OS/2 fixes', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
call execute '@xcopy 'fpk.dd.dir'\fix\bdd.1\*  fix\.'
call execute '@xcopy 'fpk.dd.dir'\fix\bdd.4\*  fix\.'
if fpk.dd.num = 1 then call execute '@xcopy 'fpk.dd.dir'\fix\bdd.5\*  fix\.'
call execute '@xcopy 'fpk.os2.dir'\fix\os2.1\* fix\.'
call execute '@xcopy 'fpk.os2.dir'\fix\os2.2\* fix\.'

/* then prepare it */
'@del result.out >nul 2>&1'
'@call prpfp fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) ver log
res = linein('result.out')
rc = lineout('result.out')
parse var res n.errors n.warnings

/* finally run update */
say '1B'x || '[7;26H'substr('Updating installation floppy images', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
'@del result.out >nul'
'@call updif 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver expert add_dani add_dummy upd.fd1.dir upd.fd2.dir 
res = linein('result.out')
rc = lineout('result.out')
parse var res n.errors n.warnings 

/* do the rest */
say '1B'x || '[4;26H'substr(burn, 1, 50)
say '1B'x || '[5;26H'substr(w4cd, 1, 50)
say '1B'x || '[7;26H'substr('Copying CD-ROM files', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
call execute '@xcopy 'w4cd'\* 'burn'\. /H/O/T/R/V'

/* we do not support installation from floppies any more */
rc = SysFileTree(burn'\*', ini., "FSO",,'**---')  
call execute '@attrib -r -s -h -a 'burn'\* /s'
if stream(burn'\MAKEDSKS.BAT', 'c', 'query exists') <> '' then call execute '@del 'burn'\MAKEDSKS.BAT'
if stream(burn'\MAKEDSKS.CMD', 'c', 'query exists') <> '' then call execute '@del 'burn'\MAKEDSKS.CMD'

call execute '@mkdir 'burn'\cid'
call execute '@xcopy 'w4cd'\cid\* 'burn'\cid\. /H/O/T/S/R/V/E'

call execute '@mkdir 'burn'\ibminst'
call execute '@xcopy 'w4cd'\ibminst\* 'burn'\ibminst\. /H/O/T/S/E/R/V'

call execute '@mkdir 'burn'\images'
'@echo Update of installation floppy images is not supported by UpdCD. > 'burn'\images\images.txt'

call execute '@mkdir 'burn'\info'
call execute '@xcopy 'w4cd'\info\* 'burn'\info\. /H/O/T/S/E/R/V'

call execute '@mkdir 'burn'\os2image'
call execute '@xcopy 'w4cd'\os2image\* 'burn'\os2image\. /H/O/T/S/R/V/E'

/* remove RO attribute */
rc = SysFileTree(burn'\*', ini., "FSO",,'**---')  
call execute '@attrib -r -s -h -a 'burn'\* /s'

/* add updated program database */
call execute '@copy newinst\database.txt fix\.'
call execute '@unpack 'w4cd'\os2image\disk_2\bundle fix\. /N:DBTAGS.DAT'
call execute '@PARSEDB fix\DBTAGS.DAT fix\DATABASE.TXT fix\DATABASE.DAT'
call execute '@del fix\dbtags.dat'

/********************************************************************/
/* incorporate OS/2 and Device Driver fixpaks and Feature Installer */
/********************************************************************/

/* copy FI update to fixdir */
if upd.fii.dir <> '' then do
	call execute '@xcopy 'upd.fii.dir'\* fix\.'
	call execute '@del fix\checkasd.exe'
	call execute '@del fix\checkasd.msg'
	call execute '@del fix\fisetmri.dll'
	call execute '@del fix\fisetup.exe '
	call execute '@del fix\readme      '
	call execute '@del fix\rejoinea.exe'

	/* replace truetype.dll with freetype.dll */
	if stream('fix\freetype.dll', 'c', 'query exists') <> '' then do
		call execute '@copy fix\freetype.dll fix\truetype.dll'
		call execute '@del fix\freetype.dll'
	end

	/* move FI plug-in if Netscape is found */
	if upd.nsc.dir <> '' then do
		call execute '@mkdir 'burn'\cid\img\netscape'
		call execute '@copy fix\npfi.dll 'burn'\cid\img\netscape'
		call execute '@del fix\npfi.dll'
	end
end

/* copy sym files from printer driver fixpak */
if fpk.pdd.dir <> '' then do
	call execute '@xcopy 'fpk.pdd.dir'\*.sym fix\.'
end

/* add updated printer list */
if fpk.pdd.dir <> '' then do
	call execute '@copy newinst\PRDESC.LST fix\.'
end

/* delete SMP drivers */
if fpk.dd.num > 1 then do
	call execute '@del fix\106BASE.SYS'
	call execute '@del fix\AXBASE.SYS'
end

/* run update */
'@del result.out >nul'
'@copy basefpk.wp4 basefpk.pin >nul'
'@call updcd 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
res = linein('result.out')
rc = lineout('result.out')
parse var res n.errors n.warnings 

/* and delete temp stuff from fix */
rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
do i = 1 to ini.0
	call execute '@del 'ini.i
end

if expert = 0 then do
	say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
	'@pause >nul'
	say '1B'x || '[19;2H                                            '
end

/*************************************/
/* incorporate printer driver fixpak */
/*************************************/

if fpk.pdd.dir <> '' then do
	/* copy fix */
	say '1B'x || '[7;26H'substr('Copying printer fixpak', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@xcopy 'fpk.pdd.dir'\* fix\.'

	/* remove some files */
	call execute '@del fix\*.sym'
	call execute '@del fix\readme'
	call execute '@del fix\license'

	/* prepare files */
	call execute '@copy fix\*.ea fix\*.ea_'
	call execute '@del fix\*.ea'
	call execute '@del fix\*.fmf' /* have no idea if we need these files */

	/* run update */
	'@del result.out >nul'
	'@call updcd 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
	res = linein('result.out')
	rc = lineout('result.out')
	parse var res n.errors n.warnings 

	/* delete temp stuff from fix */
	rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end

	if expert = 0 then do
		say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
		'@pause >nul'
		say '1B'x || '[19;2H                                            '
	end
end

/******************************************/
/* incorporate MPTS replacement and fixes */
/******************************************/

if upd.mpt.dir <> '' then do
	/* delete old mpts */
	rc = SysFileTree(burn'\cid\img\mpts\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end

	/* copy replacement mpts */
	say '1B'x || '[7;26H'substr('Copying MPTS update', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@xcopy 'upd.mpt.dir'\* 'burn'\cid\img\mpts\. /H/O/T/S/R/V/E'

	/* add mpts fixpak */
	if fpk.mpt.dir <> '' then do
		/* copy fix */
		say '1B'x || '[7;26H'substr('Copying MPTS fixpak', 1, 50)
		say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
		call execute '@xcopy 'fpk.mpt.dir'\fix\MPT.1\* fix\.'
		call execute '@xcopy 'fpk.mpt.dir'\fix\TRP.2\* fix\.'
		call execute '@xcopy 'fpk.mpt.dir'\fix\DHC.3\* fix\.'
		call execute '@xcopy 'fpk.mpt.dir'\fix\SIF.4\* fix\.'
		call execute '@xcopy 'fpk.mpt.dir'\fix\LCU.5\* fix\.'

		/* then prepare it */
		'@del result.out >nul'
		'@call prpfp fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) ver log
		res = linein('result.out')
		rc = lineout('result.out')
		parse var res n.errors n.warnings 

		/* finally run update */
		'@del result.out >nul'
		'@call updcd 'burn'\cid\img\mpts fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
		res = linein('result.out')
		rc = lineout('result.out')
		parse var res n.errors n.warnings 

		/* and delete temp stuff from fix */
		rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
		do i = 1 to ini.0
			call execute '@del 'ini.i
		end
	end

	/* update sniffer */
	if stream(burn'\CID\IMG\MPTS\APPLETS\MPTSAPLT.ZIP', 'c', 'query exists') <> '' then do
		call execute '@unzip -jCo 'burn'\CID\IMG\MPTS\APPLETS\MPTSAPLT.ZIP APPLETS\OS2SNIFF.EXE  -d 'burn'\ibminst\. '
		call execute '@unzip -jCo 'burn'\CID\IMG\MPTS\APPLETS\MPTSAPLT.ZIP APPLETS\NCD.DLL       -d 'burn'\ibminst\. '
		call execute '@unzip -jCo 'burn'\CID\IMG\MPTS\APPLETS\MPTSAPLT.ZIP APPLETS\NCD.MSG       -d 'burn'\ibminst\. '
		call execute '@copy 'burn'\ibminst\os2sniff.exe 'burn'\ibminst\clbsniff.exe'
		call execute '@copy 'burn'\ibminst\ncd.dll 'burn'\ibminst\clbncd.dll'
	end
	else if stream(burn'\CID\IMG\MPTS\UTILITY\APPLETS\MPTSAPLT.ZIP', 'c', 'query exists') <> '' then do
		call execute '@unzip -jCo 'burn'\CID\IMG\MPTS\UTILITY\APPLETS\MPTSAPLT.ZIP APPLETS\OS2SNIFF.EXE  -d 'burn'\ibminst\. '
		call execute '@unzip -jCo 'burn'\CID\IMG\MPTS\UTILITY\APPLETS\MPTSAPLT.ZIP APPLETS\NCD.DLL       -d 'burn'\ibminst\. '
		call execute '@unzip -jCo 'burn'\CID\IMG\MPTS\UTILITY\APPLETS\MPTSAPLT.ZIP APPLETS\NCD.MSG       -d 'burn'\ibminst\. '
		call execute '@copy 'burn'\ibminst\os2sniff.exe 'burn'\ibminst\clbsniff.exe'
		call execute '@copy 'burn'\ibminst\ncd.dll 'burn'\ibminst\clbncd.dll'
	end

	/* Fix: MPTS FP 8424/8425 breaks CID install */
	if (fpk.mpt.num > 8423 | fpk.mpt.num < 8600) then do /* restore good file */
		call execute '@copy 'upd.mpt.dir'\ibmcom\dll\LAPSCID.DLL 'burn'\cid\img\mpts\ibmcom\dll\.'
	end

	/* update files in \cid\nif with updated mpts */
	call deldir burn'\cid\nifs'
	call execute '@mkdir 'burn'\cid\nifs'
	call execute '@mkdir 'burn'\cid\nifs\macs'
	call execute '@mkdir 'burn'\cid\nifs\protocol'
	call execute '@unzip -jo 'burn'\cid\img\mpts\ibmcom\protocol\protocol.zip -d 'burn'\cid\nifs'
	call execute '@unzip -jo 'burn'\cid\img\mpts\ibmcom\protocol\protocol.zip -d 'burn'\cid\nifs\protocol'
	call execute '@unzip -jo 'burn'\cid\img\mpts\ibmcom\macs\macs.zip         -d 'burn'\cid\nifs'
	call execute '@unzip -jo 'burn'\cid\img\mpts\ibmcom\macs\macs.zip         -d 'burn'\cid\nifs\macs'

	if expert = 0 then do
		say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
		'@pause >nul'
		say '1B'x || '[19;2H                                            '
	end
end

/***************************/
/* incorporate PEER fixpak */
/***************************/

if fpk.per.dir <> '' then do
	/* copy fix */
	say '1B'x || '[7;26H'substr('Copying PEER fixpak', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@xcopy 'fpk.per.dir'\fix\REQ.1\* fix\.'
	call execute '@xcopy 'fpk.per.dir'\fix\UPE.2\* fix\.'
	if fpk.per.num < 8412 then call execute '@xcopy 'fpk.per.dir'\fix\UPE.3\* fix\.'
	call execute '@xcopy 'fpk.per.dir'\fix\MUG.3\* fix\.'
	if fpk.per.num < 8412 then call execute '@xcopy 'fpk.per.dir'\fix\MUG.2\* fix\.'

	/* then prepare it */
	'@del result.out >nul'
	'@call prpfp fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) ver log
	res = linein('result.out')
	rc = lineout('result.out')
	parse var res n.errors n.warnings 

	/* finally run update */
	'@del result.out >nul'
	'@copy peerfpk.wp4 peerfpk.pin >nul'
	'@call updcd 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
	res = linein('result.out')
	rc = lineout('result.out')
	parse var res n.errors n.warnings 

	/* and delete temp stuff from fix */
	rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end

	if expert = 0 then do
		say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
		'@pause >nul'
		say '1B'x || '[19;2H                                            '
	end
end

/***************************/
/* incorporate NW REQ 2.12 */
/***************************/
if fpk.nwr.dir <> '' then do
	
	/* copy fixed nwreq */
	say '1B'x || '[7;26H'substr('Copying NETWARE fixpak', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)

	/* copy requester files */
	call execute '@xcopy 'fpk.nwr.dir'\requestr\*     'burn'\cid\img\nwreq\netware\. /H/O/T/S/R/V/E'
	call execute '@xcopy 'fpk.nwr.dir'\login\*        'burn'\cid\img\nwreq\netware\. /H/O/T/R/V/E  '
	call execute '@copy 'fpk.nwr.dir'\os2\ntr2000.sy_ 'burn'\cid\img\nwreq\netware\.'

	/* copy nls files */
	call execute '@xcopy 'fpk.nwr.dir'\login\nls\*    'burn'\cid\img\nwreq\netware\nls\. /H/O/T/R/V/E'

	/* copy language dependent files */
	select
		when lang = 'DE' then do
			call execute '@xcopy 'fpk.nwr.dir'\DEUTSCH\*            'burn'\cid\img\nwreq\netware\nls\DEUTSCH\. /H/O/T/S/R/V/E'
			call execute '@xcopy 'fpk.nwr.dir'\nls\DEUTSCH\*        'burn'\cid\img\nwreq\netware\nls\DEUTSCH\. /H/O/T/S/R/V/E'
			call execute '@xcopy 'fpk.nwr.dir'\login\nls\DEUTSCH\*  'burn'\cid\img\nwreq\netware\nls\DEUTSCH\. /H/O/T/S/R/V/E'
		end
		when lang = 'ES' then do
			call execute '@xcopy 'fpk.nwr.dir'\ESPANOL\*            'burn'\cid\img\nwreq\netware\nls\ESPANOL\. /H/O/T/S/R/V/E'
			call execute '@xcopy 'fpk.nwr.dir'\nls\ESPANOL\*        'burn'\cid\img\nwreq\netware\nls\ESPANOL\. /H/O/T/S/R/V/E'
			call execute '@xcopy 'fpk.nwr.dir'\login\nls\ESPANOL\*  'burn'\cid\img\nwreq\netware\nls\ESPANOL\. /H/O/T/S/R/V/E'
		end
		when lang = 'FR' then do
			call execute '@xcopy 'fpk.nwr.dir'\FRANCAIS\*           'burn'\cid\img\nwreq\netware\nls\FRANCAIS\. /H/O/T/S/R/V/E'
			call execute '@xcopy 'fpk.nwr.dir'\nls\FRANCAIS\*       'burn'\cid\img\nwreq\netware\nls\FRANCAIS\. /H/O/T/S/R/V/E'
			call execute '@xcopy 'fpk.nwr.dir'\login\nls\FRANCAIS\* 'burn'\cid\img\nwreq\netware\nls\FRANCAIS\. /H/O/T/S/R/V/E'
		end
		when lang = 'IT' then do
			call execute '@xcopy 'fpk.nwr.dir'\ITALIANO\*           'burn'\cid\img\nwreq\netware\nls\ITALIANO\. /H/O/T/S/R/V/E'
			call execute '@xcopy 'fpk.nwr.dir'\nls\ITALIANO\*       'burn'\cid\img\nwreq\netware\nls\ITALIANO\. /H/O/T/S/R/V/E'
			call execute '@xcopy 'fpk.nwr.dir'\login\nls\ITALIANO\* 'burn'\cid\img\nwreq\netware\nls\ITALIANO\. /H/O/T/S/R/V/E'
		end
		when lang = 'BR' then do
			call execute '@xcopy 'fpk.nwr.dir'\ENGLISH\*           'burn'\cid\img\nwreq\netware\nls\ENGLISH\. /H/O/T/S/R/V/E'
			call execute '@xcopy 'fpk.nwr.dir'\nls\ENGLISH\*       'burn'\cid\img\nwreq\netware\nls\ENGLISH\. /H/O/T/S/R/V/E'
			call execute '@xcopy 'fpk.nwr.dir'\login\nls\ENGLISH\* 'burn'\cid\img\nwreq\netware\nls\ENGLISH\. /H/O/T/S/R/V/E'
		end
		otherwise do
			call execute '@xcopy 'fpk.nwr.dir'\ENGLISH\*           'burn'\cid\img\nwreq\netware\nls\ENGLISH\. /H/O/T/S/R/V/E'
			call execute '@xcopy 'fpk.nwr.dir'\nls\ENGLISH\*       'burn'\cid\img\nwreq\netware\nls\ENGLISH\. /H/O/T/S/R/V/E'
			call execute '@xcopy 'fpk.nwr.dir'\login\nls\ENGLISH\* 'burn'\cid\img\nwreq\netware\nls\ENGLISH\. /H/O/T/S/R/V/E'
		end
	end /* select */

	/* copy windows files */
	call execute '@xcopy 'fpk.nwr.dir'\windows\* 	'burn'\cid\img\nwreq\system\. /H/O/T/S/R/V/E'

	/* unpack files */
	rc = SysFileTree(burn'\cid\img\nwreq\*.??_', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@'fpk.nwr.dir'\nwunpack.exe 'ini.i filespec('drive', ini.i)||filespec('path', ini.i)'.'
		if rc = 0 then call execute '@del 'ini.i
	end

	/* copy some extra */
	call execute '@copy 'fpk.nwr.dir'\nwcalls.dll     'burn'\cid\img\nwreq\netware\.'
	call execute '@copy 'fpk.nwr.dir'\nwlocale.dll    'burn'\cid\img\nwreq\netware\.'
	call execute '@copy 'fpk.nwr.dir'\install.exe     'burn'\cid\img\nwreq\netware\.'
	call execute '@copy 'fpk.nwr.dir'\os2\drivers.os2 'burn'\cid\img\nwreq\netware\.'
	call execute '@copy 'fpk.nwr.dir'\rpl\mini.ifs    'burn'\cid\img\nwreq\netware\.'

	/* delete stuff from fix */
	rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end

end

/******************************/
/* copy updated CID procedure */
/******************************/
rc = SysFileTree(burn'\ibminst\*', ini., "FSO",,'**---')  
call execute '@copy newinst\addons.cfg   'burn'\ibminst\tables'
call execute '@copy newinst\addon.fil    'burn'\ibminst\tables'
call execute '@copy newinst\lcudrvr.fil  'burn'\ibminst\tables'
call execute '@copy newinst\StTimeV.Cmd  'burn'\ibminst'
call execute '@copy unzip.exe            'burn'\ibminst'
call execute '@copy newinst\mkrsp.cmd    'burn'\ibminst'
call execute '@copy 'burn'\ibminst\npconfig.exe 'burn'\ibminst\npcfg2.exe'
call execute '@copy newinst\npconfig.exe 'burn'\ibminst'
call execute '@copy vrobj.dll            'burn'\ibminst'
call execute '@copy newinst\tunecfg.cmd  'burn'\ibminst'
call execute '@copy newinst\tunecfg.cfg  'burn'\ibminst'

/*****************************/
/* incorporate Netscape 4.61 */
/*****************************/

if upd.nsc.dir <> '' then do
	say '1B'x || '[7;26H'substr('Copying Netscape', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)

	/* copy files we need */
	call execute '@copy newinst\netscape.rsp 'burn'\ibminst\tables'
	/* call execute '@mkdir 'burn'\cid\img\netscape' */
	call execute '@xcopy 'upd.nsc.dir'\* 'burn'\cid\img\netscape /H/O/T/S/R/V/E'
end

/*****************************/
/* incorporate Java run-time */
/*****************************/

if upd.nsc.dir <> '' & upd.jav.dir <> '' then do

	/* create Java dir and copy the files needed */
	say '1B'x || '[7;26H'substr('Copying Java', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@mkdir 'burn'\cid\img\java'

	/* copy java cid.rsp to tabledir */
	call execute '@copy 'upd.jav.dir'\cid.rsp 'burn'\ibminst\tables\javacid.rsp'

	/* copy the rest to image */
	call execute '@xcopy 'upd.jav.dir'\* 'burn'\cid\img\java /H/O/T/R/V/E'
	call execute '@mkdir 'burn'\cid\img\java\package'
	call execute '@xcopy 'upd.jav.dir'\package\* 'burn'\cid\img\java\package /H/O/T/S/R/V/E'
	call execute '@mkdir 'burn'\cid\img\java\en'
	if lang = 'DK' | lang = 'FI' | lang = 'NL' then lang = 'EN' /* there is no java for these languages, use English version */
	call execute '@xcopy 'upd.jav.dir'\'lang'\* 'burn'\cid\img\java\en /H/O/T/S/R/V/E'
	
	/* seems this file should be in the root */
	call execute '@copy 'upd.jav.dir'\'lang'\00000000.EAS 'burn'\cid\img\java'

	/* rename java response file */
	call execute '@copy 'burn'\cid\img\java\en\java*.rsp 'burn'\cid\img\java\en\rspjava.rsp'
	call execute '@del 'burn'\cid\img\java\en\java*.rsp'

	/* remove java 1.0.2 from FI response file */
	if stream('fibase.loc', 'c', 'query exists') <> '' then do

		/* unpack fibase.rsp */
		location.fibase = linein('fibase.loc')
		call lineout 'fibase.loc'
		call execute '@unpack 'location.fibase' . /N:FIBASE.RSP'

		/* set some variables */
		found_java = 0
		create_object = 0
		copy_file = 0
		in  = 'fibase.rsp'
		out = 'fibase.out'
		'@del 'out' >nul 2>>&1'

		/* read fibase */
		do while lines(in)
			l=linein(in)

			/* where are we now? */
			select
				when l='JAVA=(' | l='JAVARUN=(' | l='JAVASMPLS=(' | l='JAVATLKT=(' then found_java = 1
				when found_java = 1 & l='	ObjectCreation=(' then do
					create_object = 1
					iterate
				end
				when found_java = 1 & l='	File=(' then do
					copy_file = 1
					iterate
				end
				when l='	)' & found_java = 1 & (create_object = 1 | copy_file = 1) then do
					create_object = 0
				 	copy_file = 0
					iterate
				end
				when l=')' & found_java = 1 then found_java = 0
				otherwise nop;
			end
		
			/* write out if it is not JAVA 1.0 create object or copy file */
			if found_java = 1 & (create_object = 1 | copy_file = 1) then iterate
			else call lineout out, l
		
		end
		call lineout in
		call lineout out

		/* pack new rsp file */
		call execute '@copy 'out in
		'@pack2 \OS2\INSTALL\FIBASE.RSP 'location.fibase' /R >nul 2>>&1'
		call execute '@pack2 'in location.fibase' /H:\OS2\INSTALL\ /A'

		/* clean up */
		'@del 'in'  >nul 2>>&1'
		'@del 'out' >nul 2>>&1'
		'@del fibase.loc >nul 2>>&1'

	end

end

/************************************/
/* incorporate Java run-time fixpak */
/************************************/

if upd.nsc.dir <> '' & upd.jav.dir <> '' & fpk.jav.dir <> '' then do

	/* copy fix */
	say '1B'x || '[7;26H'substr('Copying JAVA fixpak', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@xcopy 'fpk.jav.dir'\lib\* 					fix\.'
	call execute '@xcopy 'fpk.jav.dir'\lib\security\* fix\.'
	call execute '@xcopy 'fpk.jav.dir'\dll\* 					fix\.'
	call execute '@xcopy 'fpk.jav.dir'\bin\* 					fix\.' 
	call execute '@xcopy 'fpk.jav.dir'\*     					fix\.'

	/* delete some files */
	call execute '@del fix\FIXES.LST'

	/* finally run update */
	'@del result.out >nul'
	'@call updcd 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
	res = linein('result.out')
	rc = lineout('result.out')
	parse var res n.errors n.warnings 

	/* and delete temp stuff from fix */
	rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end

	if expert = 0 then do
		say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
		'@pause >nul'
		say '1B'x || '[19;2H                                            '
	end
	
end

/******************************/
/* incorporate 32-bits TCP/IP */
/******************************/

if upd.nsc.dir <> '' & upd.jav.dir <> '' & upd.tcp.dir <> '' then do
	/* delete old TCP/IP */
	rc = SysFileTree(burn'\cid\img\tcpapps\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end

	/* copy new one */
	say '1B'x || '[7;26H'substr('Copying TCP/IP', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@xcopy 'upd.tcp.dir'\* 'burn'\cid\img\tcpapps /H/O/T/S/R/V/E'

	/* add new response file */
	call execute '@copy newinst\tcpip.rsp 'burn'\ibminst\tables'
end

/*****************************/
/* incorporate TCP/IP fixpak */
/*****************************/

if fpk.tcp.dir <> '' then do

	/* apply 16-bits fixpak on original Warp 4 TCP/IP */
	if upd.tcp.dir = '' then do
		/* copy fix */
		say '1B'x || '[7;26H'substr('Copying TCP/IP fixpak', 1, 50)
		say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
		select
			when lang = 'DK' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.5\* fix\.'
			end
			when lang = 'DE' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.6\* fix\.'
			end
			when lang = 'ES' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.7\* fix\.'
			end
			when lang = 'FI' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.8\* fix\.'
			end
			when lang = 'FR' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.9\* fix\.'
			end
			when lang = 'IT' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.10\* fix\.'
			end
			when lang = 'JP' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.11\* fix\.'
			end
			when lang = 'KO' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.12\* fix\.'
			end
			when lang = 'NL' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.13\* fix\.'
			end
			when lang = 'NO' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.14\* fix\.'
			end
			when lang = 'BR' then do
				call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.15\* fix\.'
			end
			otherwise nop;
		end
		/* TCP.1 is always needed */
		call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.1\* fix\.'
	
		/* do not put English rsp on non-English Warp */
		if lang <> 'EN' then call execute '@del fix\default.rs_'

		/* then prepare it */
		'@del result.out >nul'
		'@call prpfp fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) ver log
		res = linein('result.out')
		rc = lineout('result.out')
		parse var res n.errors n.warnings 
	
		/* finally run update */
		'@del result.out >nul'
		'@copy tcppfpk.wp4 tcppfpk.pin >nul'
		'@call updcd 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
		res = linein('result.out')
		rc = lineout('result.out')
		parse var res n.errors n.warnings 
	
		/* and delete temp stuff from fix */
		rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
		do i = 1 to ini.0
			call execute '@del 'ini.i
		end
	
		/* do some postprocessing for non English TCP/IP */
		
		if lang <> 'EN' then do
			/* copy language dependent DLL's to fix */
			select
				when lang = 'DK' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.5\cnb*.dl_ fix\.'
					path = 'MSG\DADK850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.5\srv_prod.??? fix\.'
				end
				when lang = 'DE' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.6\cnb*.dl_ fix\.'
					path = 'MSG\DEDE850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.6\srv_prod.??? fix\.'
				end
				when lang = 'ES' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.7\cnb*.dl_ fix\.'
					path = 'MSG\ESES850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.7\srv_prod.??? fix\.'
				end
				when lang = 'FI' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.8\cnb*.dl_ fix\.'
					path = 'MSG\FIFI850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.8\srv_prod.??? fix\.'
				end
				when lang = 'FR' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.9\cnb*.dl_ fix\.'
					path = 'MSG\FRFR850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.9\srv_prod.??? fix\.'
				end
				when lang = 'IT' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.10\cnb*.dl_ fix\.'
					path = 'MSG\ITIT850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.10\srv_prod.??? fix\.'
				end
				when lang = 'JP' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.11\cnb*.dl_ fix\.'
					path = 'MSG\JAJP932'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.11\srv_prod.??? fix\.'
				end
				when lang = 'KO' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.12\cnb*.dl_ fix\.'
					path = 'MSG\KOKR949'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.12\srv_prod.??? fix\.'
				end
				when lang = 'NL' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.13\cnb*.dl_ fix\.'
					path = 'MSG\NLNL850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.13\srv_prod.??? fix\.'
				end
				when lang = 'NO' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.14\cnb*.dl_ fix\.'
					path = 'MSG\NONO850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.14\srv_prod.??? fix\.'
				end
				when lang = 'BR' then do
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.15\cnb*.dl_ fix\.'
					path = 'MSG\PTBR850'
					call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.15\srv_prod.??? fix\.'
				end
				otherwise nop;
			end
	
			/* then prepare it */
			'@del result.out >nul'
			'@call prpfp fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) ver log
			res = linein('result.out')
			rc = lineout('result.out')
			parse var res n.errors n.warnings 
		
			/* add them to base3.zip */
			call execute '@mkdir tmp'
			call execute '@unzip -o 'burn'\cid\img\tcpapps\base3.zip -d tmp'
			call execute '@cd tmp'
			call execute '@xcopy ..\fix\* 'path
			call execute '@..\zip.exe -mkr 'burn'\cid\img\tcpapps\base3.zip *'
			call execute '@cd ..'
			call execute '@rmdir tmp'
	
			/* and delete temp stuff from fix */
			rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
			do i = 1 to ini.0
				call execute '@del 'ini.i
			end
		end

	end
	else do /* apply 32-bits fixpak on TCP/IP update */
		/* copy fix */
		say '1B'x || '[7;26H'substr('Copying TCP/IP fixpak', 1, 50)
		say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)	
		call execute '@xcopy 'fpk.tcp.dir'\fix\TCP.1\* fix\.'

		/* delete some files */
		call execute '@del fix\CSINITCP.EXE'

		/* then prepare it */
		'@del result.out >nul'
		'@call prpfp fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) ver log
		res = linein('result.out')
		rc = lineout('result.out')
		parse var res n.errors n.warnings 

		/* finally run update */
		'@del result.out >nul'
		'@call updcd 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
		res = linein('result.out')
		rc = lineout('result.out')
		parse var res n.errors n.warnings 

		/* and delete temp stuff from fix */
		rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
		do i = 1 to ini.0
			call execute '@del 'ini.i
		end
	end
	
	if expert = 0 then do
		say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
		'@pause >nul'
		say '1B'x || '[19;2H                                            '
	end
end

/****************************/
/* incorporate pmfax update */
/****************************/

if upd.fax.dir <> '' then do
	/* copy fix */
	say '1B'x || '[7;26H'substr('Copying PMFax update', 1, 50)
	say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
	call execute '@xcopy 'upd.fax.dir'\*         fix\. /H/O/T/R'

	/* rename/delete some files */
	call execute '@copy  'upd.fax.dir'\pmfax.exe fix\faxworks.exe'
	call execute '@del fix\pmfax.exe'
	call execute '@del fix\readme.htm'

	/* finally run update */
	'@del result.out >nul'
	'@call updcd 'burn' fix 'n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
	res = linein('result.out')
	rc = lineout('result.out')
	parse var res n.errors n.warnings 

	/* and delete temp stuff from fix */
	rc = SysFileTree('fix\*', ini., "FSO",,'**---')  
	do i = 1 to ini.0
		call execute '@del 'ini.i
	end

	/* clean up fix */
	if expert = 0 then do
		say '1B'x || '[19;2HPress any key to continue or CTRL-C to abort'
		'@pause >nul'
		say '1B'x || '[19;2H                                            '
	end
end

/************************/
/* Add fixed getcfg.exe */
/************************/
call execute '@copy 'burn'\os2image\disk_3\getcfg.exe 'burn'\os2image\disk_3\getcfg2.exe'
call execute '@copy newinst\getcfg.exe 'burn'\os2image\disk_3\.'

/************************/
/* add UPDCD info to CD */
/************************/

say '1B'x || '[7;26H'substr('Copying UpdCD and Addon Products', 1, 50)
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
call execute '@mkdir 'burn'\updcd\bin'
call execute '@copy *.cm? 'burn'\updcd\bin\.'
call execute '@copy *.exe 'burn'\updcd\bin\.'
call execute '@copy *.dll 'burn'\updcd\bin\.'
call execute '@copy *.msg 'burn'\updcd\bin\.'
call execute '@copy *.cfg 'burn'\updcd\bin\.'
call execute '@copy cd2boot   'burn'\updcd\bin\.'
call execute '@copy pmfaxlt.* 'burn'\updcd\bin\.'
call execute '@copy basefpk.* 'burn'\updcd\bin\.'
call execute '@copy mptsfpk.* 'burn'\updcd\bin\.'
call execute '@copy tcppfpk.* 'burn'\updcd\bin\.'
call execute '@copy peerfpk.* 'burn'\updcd\bin\.'
call execute '@mkdir 'burn'\updcd\doc'
call execute '@copy *.txt 'burn'\updcd\doc\.'
call execute '@copy readme.* 'burn'\updcd\doc\.'
call execute '@mkdir 'burn'\updcd\addons'
say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
call execute '@xcopy addons\* 'burn'\updcd\addons\. /S/O/T/R/E/H'
call execute '@mkdir 'burn'\updcd\log'
rc = lineout(log, 'Info: Total number of errors  : 'n.errors)
rc = lineout(log, 'Info: Total number of warnings: 'n.warnings)
rc = lineout(log)
'@copy *.log 'burn'\updcd\log\. >nul 2>>&1'

/***********************/
/* clean up and report */
/***********************/
'@del result.out >nul'
'@del go4it.bsy >nul 2>>&1'

/* signal fatal errors */
if n.errors > 0 then 	say '1B'x || '[19;2HThere were one or more errors detected, Check 'log'!'
else do
	say '1B'x || '[19;2HUpdate is completed succesfully!'

	/***********/
	/* burn CD */
	/***********/
	if stream(cdrprg, 'c', 'query exists') <> '' then do
		say '1B'x || '[7;26H'substr('Calling script 'cdrprg' to burn CD.', 1, 50)
		say '1B'x || '[14;26H'trunc(time('E')/60 + n.elapsed, 2)
		say '1B'x || '[19;2H'
		'@call 'cdrprg n.errors n.warnings
	end

end

exit


/* delete directory */
DelDir: procedure expose n. log

	parse arg Directory
	DirSpec = Directory || '\*'

	/* delete subdirectories */
	rc = SysFileTree(DirSpec, Subdirs, 'DO', '*****', '-*---')
	do i = 1 to Subdirs.0
   		call DelDir Subdirs.i
	end

	/* delete files */
	rc = SysFileTree(DirSpec, Files, 'FO', '*****', '-*---')
	do i = 1 to Files.0
      call execute '@del 'Files.i
  end

	/* delete directory */
	cdir = directory()
	d = directory(Directory)
	cdir = directory(cdir)
	if d <> '' then call execute '@rmdir 'Directory

return

/* execute command, display it and write to log */ 
execute: procedure expose log n. iddir

	parse arg comm 
	rcode = 0

	parse upper var comm comm1 comm2 comm3 comm4 rest
	/* do not copy or pack if file does not exist */
	rc = SysFileTree(comm2, tmp., "FSO") 
	if (comm1 <> '@COPY' & comm1 <> '@PACK2' & comm1 <> '@DEL' & comm1 <> '@XCOPY') | (stream(comm2, 'c', 'query exists') <> '') | (tmp.0 > 0) then do
		comm' >nul 2>>&1'
		if rc <> 0 then rcode = rc
	end
	else do /* log warning */
		rc = lineout(log, 'Warning: 'comm2' does not exist!')
		n.warnings = n.warnings + 1
		call report_status
		return
	end
	comm = comm ||' rc='rcode

	if comm1 = '@..\ZIP.EXE' then do	
		say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(comm3), 1, 50))), 1, 50)
		say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(comm4), 1, 50))), 1, 50)
		say '1B'x || '[11;26HZip         '
	end
	else if comm1 = '@MKDIR' | comm1 = '@RMDIR' | comm1 = '@CD' then do	
		nop;
	end
	else if comm1 = '@UNZIP' then do	
		say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(rest), 1, 50))), 1, 50)
		say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(comm3), 1, 50))), 1, 50)
		say '1B'x || '[11;26HUnzip         '
	end
	else do 
		say '1B'x || '[8;26H'substr(space(reverse(substr(reverse(comm3), 1, 50))), 1, 50)
		say '1B'x || '[9;26H'substr(space(reverse(substr(reverse(comm2), 1, 50))), 1, 50)
		say '1B'x || '[11;26H'substr(comm1, 2, 50)
	end
	say '1B'x || '[12;26H'rcode' '

	if rcode <> 0 then do
		rc = lineout(log, 'Error: 'comm)
		rc = lineout(log)
		n.errors = n.errors + 1
	end
	else do
		rc = lineout(log, 'Info: 'comm)
		rc = lineout(log)
	end

	call report_status

return rcode

/* display status */
report_status: procedure expose n. 

	say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
	say '1B'x || '[15;2HNumber of errors      : 'n.errors
	say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
	say '1B'x || '[19;2H'

return

