/* Install Xfree86 applications                                             */
/*                                                                          */
/* Place the applications here which should be installed in the XFree86 dir */
/* The applications should be packed in zip files and should contain the    */
/* Xfree86 directory. The content of this directory will be unzipped to the */
/* drive which contains Xfree86 installed.                                  */
/*                                                                          */
/* You need to repackage (unzip/zip) your application if it is not packed   */
/* this way.                                                                */
/*                                                                          */
/* Created on 05.02.2001                                                    */

parse arg target source

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
product_drv       = value("PRODUCT_DRV"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* exit if package does not exist */
rc = RxFuncAdd('SysFileTree', 'RexxUtil', 'SysFileTree')
rc = SysFileTree(inst_dir'\*.zip', 'zip.', 'FO')
if zip.0 = 0 then exit 9

ziptmp = target'\temp\ziptmp.lst'
do i = 1 to zip.0 
	
	'unzip -l 'zip.i' > 'ziptmp
	do while lines(ziptmp)
		l = linein(ziptmp)
		parse var l w1 w2 w3 w4 w5 w6
		if datatype(w1) = 'NUM' & datatype(w2) = 'NUM' & datatype(w3) = 'NUM' then 
			if pos('XFREE86', translate(l)) > 0 then /* unzip only to xfree86 */
				if w1 > 0 then
					'unzip -o 'zip.i' 'space(w6)' -d 'target'\ >> 'product_log
				else do
					tdir = target'\'translate(space(w6), '\', '/')
					'mkdir 'substr(tdir, 1, lastpos('\', tdir)-1)' >nul 2>>&1'
				end
	end
	call lineout ziptmp
	'del 'ziptmp

end

exit

