/* InnoTek FlashOS2 installation, registration and create icons             */
/* Place npswf2.dll, license.txt and readme.txt here (install flashos2 on a */
/* machine and copy this file).                                             */
/* Do not forget to register: www.innotek.de                                */
/* Last modified 01.24.2001                                                 */

parse arg target source

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")
NS_DIR            = value("NS_DIR"           , ,"OS2ENVIRONMENT")

/* exit if package does not exist */
if stream(inst_dir'\npswf2.dll', 'c', 'query exists') = '' then exit 9

/* Register with REXX API extensions. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* FlashOS2 kopieren, Ordner/Objekte erstellen und registrieren */
'xcopy 'inst_dir'\* 'NS_DIR'\Program\PlugIns /s/e >> 'product_log
'del 'ns_dir'\program\plugins\addonins.cmd >> 'product_log

CreateCollision = 'Replace' 
rc = CreateObject( 'WPFolder',,
    'Macromedia Flash Player for OS/2^by www.innotek.de',,
    '<WP_DESKTOP>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=FLOWED,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'OBJECTID=<INNOTEK_FLASH>',,
    CreateCollision )

rc = CreateObject( 'WPShadow',,
    'readme.txt',,
    '<INNOTEK_FLASH>',,
    'SHADOWID='NS_DIR'\PROGRAM\PLUGINS\readme.txt;'||,
        'OBJECTID=<INNOTEK_FLASH_README>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'InnoTek Flash Website',,
    '<INNOTEK_FLASH>',,
    'NOTDEFAULTICON=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'URL=http://www.innotek.de/flash;'||,
        'OBJECTID=<INNOTEK_FLASH_WEB>',,
    CreateCollision )

rc = CreateObject( 'WPFolder',,
    'Flash Sample Pages',,
    '<INNOTEK_FLASH>',,
    'NOTDEFAULTICON=YES;'||,
        'NOPRINT=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'SELFCLOSE=1;'||,
        'ICONFONT=9.WarpSans;'||,
        'DETAILSFONT=9.WarpSans;'||,
        'TREEFONT=9.WarpSans;'||,
        'ICONVIEW=FLOWED,NORMAL;'||,
        'DETAILSVIEW=MINI;'||,
        'TREEVIEW=LINES,MINI;'||,
        'ALWAYSSORT=YES;'||,
        'OBJECTID=<INNOTEK_FLASH_SAMPLES>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'The Void',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'URL=http://www.thevoid.co.uk;'||,
        'OBJECTID=<INNOTEK_FLASH_SAMPLE_THEVOID>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'Any Given Sunday',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'URL=http://www.anygivensunday.net;'||,
        'OBJECTID=<INNOTEK_FLASH_SAMPLE_ANYGIVENSUNDAY>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'KIMBLE Special Agent',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'URL=http://www.kimble.org/kimmovie/kimble_themovie.swf;'||,
        'OBJECTID=<INNOTEK_FLASH_SAMPLE_KIMBLE>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'Lionhead Studios',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'URL=http://www.lionhead.co.uk;'||,
        'OBJECTID=<INNOTEK_FLASH_SAMPLE_LIONHEAD>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'Varazdin 2000',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'URL=http://www.2000.varazdin.com;'||,
        'OBJECTID=<INNOTEK_FLASH_SAMPLE_VARAZDIN2000>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'Balthaser Studios',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'URL=http://www.balthaser.com;'||,
        'OBJECTID=<INNOTEK_FLASH_SAMPLE_BALTHASER>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'Macromedia',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'URL=http://www.macromedia.com;'||,
        'OBJECTID=<INNOTEK_FLASH_SAMPLE_MACROMEDIA>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'EYE4U active media',,
    '<INNOTEK_FLASH_SAMPLES>',,
    'NOTDEFAULTICON=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'URL=http://www.eye4u.com;'||,
        'OBJECTID=<INNOTEK_FLASH_SAMPLE_EYE4U>',,
    CreateCollision )

rc = CreateObject( 'WPShadow',,
    'license.txt',,
    '<INNOTEK_FLASH>',,
    'SHADOWID='NS_DIR'\PROGRAM\PLUGINS\license.txt;'||,
        'OBJECTID=<INNOTEK_FLASH_LICENSE>',,
    CreateCollision )

rc = CreateObject( 'WPUrl',,
    'OS2.org helpdesk',,
    '<INNOTEK_FLASH>',,
    'NOTDEFAULTICON=YES;'||,
        'DEFAULTVIEW=CONTENTS;'||,
        'URL=http://en.OS2.org/forum/helpdesk/;'||,
        'OBJECTID=<INNOTEK_FLASH_OS2ORGHELPDESK>',,
    CreateCollision )

rc = SysIni( 'USER', 'InnoTek_Flash', 'Blitter', d2c(0) )
rc = SysIni( 'USER', 'InnoTek_Flash', 'Workaround15Bit', d2c(0) )
rc = SysIni( 'USER', 'InnoTek_Flash', 'HighQuality', d2c(1) )
rc = SysIni( 'USER', 'InnoTek_Flash', 'SoundEnabled', d2c(1) )
rc = SysIni( 'USER', 'InnoTek_Flash', 'Volume', d2c(100) )
rc = SysIni( 'USER', 'InnoTek_Flash', 'SoundDevice', d2c(0) )

if rc ='' then
  'echo InnoTek Flash has been added to the OS2.INI. >> 'product_log
else
  'echo InnoTek Flash has not been added to the OS2.INI. >> 'product_log

exit


CreateObject: procedure expose product_log
    Parse Arg Class, Title, Location, Setup, Collision
    'echo Object ['Title'] erzeugt >> 'product_log
    rc = SysCreateObject( Class, Title, Location, Setup, Collision )
    If rc <> 1 Then
        'echo Object ['Title' ^| 'Class'] in ['Location'] nicht erstellt >> 'product_log
return rc
