/* Installation script for USB support                                  */
/* Unpack the distribution files in this directory. You need to unpack  */
/* at least usbbasic.exe. Usbaudio.exe, usbcomm.exe, usbkeybd.exe,      */
/* usbmouse.exe and usbprt??.exe are optional.                          */
/* If there are conflicting files, use the most recent version.         */
/* Last modified on 01.20.2001                                          */

parse arg target source

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* exit if package does not exist */
if stream(inst_dir'\usbd.sys', 'c', 'query exists') = '' then exit 9

Call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
Call RxFuncAdd 'SysIni', 'RexxUtil', 'SysIni'
Call RxFuncAdd 'Syscreateobject', 'RexxUtil', 'Syscreateobject'

/* add new USB .sys files */
call SysFileTree inst_dir'\usb*.sys', 'file.', 'FO'
do i = 1 to file.0
	if build(file.i) >= build(target'\OS2\BOOT\'filespec('name', file.i)) then do
		'echo Updating with 'file.i' >> 'product_log
		'copy 'file.i target'\OS2\BOOT\. >> 'product_log
	end
end

/* add .hlp, .pdr and usbmon.exe */
call SysFileTree inst_dir'\usb*.hlp', 'file.', 'FO'
do i = 1 to file.0
	if build(file.i) >= build(target'\OS2\HELP\'filespec('name', file.i)) then do
		'echo Updating with 'file.i' >> 'product_log
		'copy 'file.i target'\OS2\HELP\. >> 'product_log
	end
end
call SysFileTree inst_dir'\usb*.pdr', 'file.', 'FO'
do i = 1 to file.0
	if build(file.i) >= build(target'\OS2\DLL\'filespec('name', file.i)) then do
		'echo Updating with 'file.i' >> 'product_log
		'copy 'file.i target'\OS2\DLL\. >> 'product_log
	end
end
if stream(target'\OS2\DLL\usbprt.pdr', 'c', 'query exists') <> '' then do
	rc = sysini('SYSTEM', 'PM_PORT_DRIVER', 'USBPRT', target'\OS2\DLL\USBPRT.PDR')
	'echo Added PM_PORT_DRIVER for usbprt.pdr (rc='rc') >> 'product_log
end
do
	file.i = 'usbmon.exe'
	if build(file.i) >= build(target'\OS2\'filespec('name', file.i)) then do
		'echo Updating with 'file.i' >> 'product_log
		'copy 'file.i target'\OS2\. >> 'product_log
	end
end
if stream(target'\OS2\usbmon.exe', 'c', 'query exists') <> '' then do
	rc = SysCreateObject('WPProgram', 'USBMON', '<WP_START>', 'PROGTYPE=WINDOWABLEVIO;MINIMIZED=YES;EXENAME='target'\os2\usbmon.exe;', 'R')
	'echo created object usbmon.exe (rc='rc') >> 'product_log
end

/* load config.sys */
cfgfile = target'\config.sys'
i = 1
do while lines(cfgfile)
	l.i = linein(cfgfile)
	i = i+1
end
rc = lineout(cfgfile)
l.0 = i-1

/* add USB base */
found = 0
do i=1 to l.0
	if translate(l.i) = 'BASEDEV=USBD.SYS /REQ:USBUHCD$' then do
		found = 1
		leave
	end
end
if found = 0 then do
	'echo Adding USB base >> 'product_log
	i = l.0+1
	l.i = ' '
	i = l.0+2
	l.i = 'REM UpdCD'
	i = l.0+3
  l.i = 'BASEDEV=USBUHCD.SYS'
	i = l.0+4
  l.i = 'BASEDEV=USBD.SYS /REQ:USBUHCD$'
	i = l.0+5
  l.i = 'BASEDEV=USBHID.SYS'
	i = l.0+6
  l.i = 'REM Enable this line on IBM 365 systems: BASEDEV=USBUHCD.SYS /FS'
	i = l.0+7
  l.i = 'REM Enable this line with IBM DockStation III: BASEDEV=USBUHCD2.SYS'
	l.0 = l.0 + 7
end

/* add USB mouse */
found = 0
do i=1 to l.0
	if pos('USBMOUSE.SYS', translate(l.i)) > 0 then do
		found = 1
		leave
	end
end
if stream(inst_dir'\USBMOUSE.SYS', 'c', 'query exists') = '' then found = 1
if found = 0 then do
	'echo Adding USB mouse >> 'product_log
	i = l.0+1
  l.i = 'DEVICE='target'\OS2\BOOT\USBMOUSE.SYS'
	l.0 = l.0 + 1
end

/* add USB keyboard */
found = 0
do i=1 to l.0
	if pos('USBKBD.SYS', translate(l.i)) > 0 then do
		found = 1
		leave
	end
end
if stream(inst_dir'\USBKBD.SYS', 'c', 'query exists') = '' then found = 1
if found = 0 then do
	'echo Adding USB keyboard >> 'product_log
	i = l.0+1
  l.i = 'DEVICE='target'\OS2\BOOT\USBKBD.SYS'
	l.0 = l.0 + 1
end

/* add USB Communication */
found = 0
do i=1 to l.0
	if pos('USBCOM.SYS', translate(l.i)) > 0 then do
		found = 1
		leave
	end
end
if stream(inst_dir'\USBCOM.SYS', 'c', 'query exists') = '' then found = 1
if found = 0 then do
	'echo Adding USB comm >> 'product_log
	i = l.0+1
  l.i = 'DEVICE='target'\OS2\BOOT\USBCOM.SYS'
	l.0 = l.0 + 1
end

/* add USB audio */
found = 0
do i=1 to l.0
	if pos('USBAUDIO.SYS', translate(l.i)) > 0 then do
		found = 1
		leave
	end
end
if stream(inst_dir'\USBAUDIO.SYS', 'c', 'query exists') = '' then found = 1
if found = 0 then do
	'echo Adding USB audio >> 'product_log
	i = l.0+1
  l.i = 'DEVICE='target'\OS2\BOOT\USBAUDIO.SYS'
	l.0 = l.0 + 1
end

/* add USB printer */
found = 0
do i=1 to l.0
	if pos('USBPRT.SYS', translate(l.i)) > 0 then do
		found = 1
		leave
	end
end
if stream(inst_dir'\USBPRT.SYS', 'c', 'query exists') = '' then found = 1
if found = 0 then do
	'echo Adding USB printer >> 'product_log
	i = l.0+1
  l.i = 'DEVICE='target'\OS2\BOOT\USBPRT.SYS'
	l.0 = l.0 + 1
end

/* update config.sys */
'copy 'cfgfile target'\os2\install\config.usb >> 'product_log
'del 'cfgfile' >> 'product_log
do i = 1 to l.0
	rc = lineout(cfgfile, l.i)
end
rc = lineout(cfgfile)

exit 


/* returns build levl input file */
build: procedure 
	parse arg file
	tmp = 'buildlvl.$t$'
	'@bldlevel 'file' > 'tmp' 2>>&1'
	do while lines(tmp)
		l=linein(tmp)
		parse var l rev num
		if translate(rev) = 'REVISION:' then leave
	end
	rc=lineout(tmp)
	'@del 'tmp
	num = space(num)
	if datatype(num) <> 'NUM' then num = 0
return num
