/* WatchCat 2.1 installation script                    */
/* Unzip wcat21.zip to this directory                  */
/* You may als place addon dll's, like wkill9.dll here */
/* Last modified on 04.22.2001                         */

parse arg target source

/* get additional parameters from environment */
product_log       = value("PRODUCT_LOG"      , ,"OS2ENVIRONMENT")
product_drv       = value("PRODUCT_DRV"      , ,"OS2ENVIRONMENT")
product_path      = value("PRODUCT_PATH"     , ,"OS2ENVIRONMENT")
inst_dir          = value("INST_DIR"         , ,"OS2ENVIRONMENT")

/* exit if package does not exist */
if stream(inst_dir'\install.exe', 'c', 'query exists') = '' then exit 9

/* copy files */
dest_dir = translate(product_drv'\'product_path)
'copy 'inst_dir'\CLEANWPS.EXE 'dest_dir'\. >> 'product_log' 2>>&1'
'copy 'inst_dir'\INSTALL.EXE  'dest_dir'\. >> 'product_log' 2>>&1'
'copy 'inst_dir'\PMCENTER.ZIP 'dest_dir'\. >> 'product_log' 2>>&1'
'copy 'inst_dir'\README.TXT   'dest_dir'\. >> 'product_log' 2>>&1'
'copy 'inst_dir'\SERIAL.CNF   'dest_dir'\. >> 'product_log' 2>>&1'
'copy 'inst_dir'\STARTPGM.DL_ 'dest_dir'\. >> 'product_log' 2>>&1'
'copy 'inst_dir'\WATCHCAT.EXE 'dest_dir'\. >> 'product_log' 2>>&1'
'copy 'inst_dir'\WATCHCAT.INF 'dest_dir'\. >> 'product_log' 2>>&1'
'copy 'inst_dir'\WATCHCAT.SYS 'dest_dir'\. >> 'product_log' 2>>&1'
'copy 'inst_dir'\WCAPI.ZIP    'dest_dir'\. >> 'product_log' 2>>&1'
'copy 'inst_dir'\WCATDEB.DL_  'dest_dir'\. >> 'product_log' 2>>&1'
'copy 'inst_dir'\WCCAD.EXE    'dest_dir'\. >> 'product_log' 2>>&1'
'copy 'inst_dir'\WCINFO.EXE   'dest_dir'\. >> 'product_log' 2>>&1'
'xcopy 'inst_dir'\*.DLL       'dest_dir'\. >> 'product_log' 2>>&1'


/* update config.sys */
cfgfile = target'\config.sys'
q = 1
do while lines(cfgfile)
	l.q = linein(cfgfile)

	/* libpath */
	if pos('LIBPATH=', translate(l.q)) > 0 & pos(dest_dir, translate(l.q)) = 0 then do
		lpos = length(l.q)
		if substr(l.q, lpos) = ';' then l.q = l.q || dest_dir';'
		else l.q = l.q || ';' || dest_dir';'
	end

	/* path */
	if pos('SET PATH=', translate(l.q)) > 0 & pos(dest_dir, translate(l.q)) = 0 then do
		lpos = length(l.q)
		if substr(l.q, lpos) = ';' then l.q = l.q || dest_dir';'
		else l.q = l.q || ';' || dest_dir';'
	end

	/* bookshelf */
	if pos('SET BOOKSHELF=', translate(l.q)) > 0 & pos(dest_dir, translate(l.q)) = 0 then do
		lpos = length(l.q)
		if substr(l.q, lpos) = ';' then l.q = l.q || dest_dir';'
		else l.q = l.q || ';' || dest_dir';'
	end

	q=q+1
end
rc = lineout(cfgfile)
l.0 = q-1

'copy 'cfgfile target'\os2\install\config.wct >> 'product_log 
'del 'cfgfile' >> 'product_log 
gevonden = 0
do q=1 to l.0
	rc = lineout(cfgfile, l.q)
end
call lineout cfgfile, ' '
call lineout cfgfile, 'REM UpdCD'
call lineout cfgfile, 'REM *** WatchCat 2.1 device driver - REQUIRED'
call lineout cfgfile, 'DEVICE='dest_dir'\WATCHCAT.SYS KEYB:CA-W '
call lineout cfgfile, 'REM *** WatchCat 2.1 main program - REQUIRED'
call lineout cfgfile, 'RUN='dest_dir'\WATCHCAT.EXE'
call lineout cfgfile, 'REM *** WatchCat 2.1 Process Manipluation Center Driver'
call lineout cfgfile, 'REM DEVICE='dest_dir'\KILLER.SYS'
call lineout cfgfile, 'REM *** WatchCat 2.1 CAD Package Virtual Device Driver'
call lineout cfgfile, 'REM DEVICE='dest_dir'\VWCAT.SYS'
call lineout cfgfile, 'REM *** WatchCat 2.1 CAD Package Control Program'
call lineout cfgfile, 'REM RUN='dest_dir'\WCCAD.EXE'
call lineout cfgfile


/* register class and create object */
call RxFuncAdd 'SysRegisterObjectClass', 'RexxUtil', 'SysRegisterObjectClass';
call SysRegisterObjectClass "WPCat", "WPCAT"
call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject';
call SysCreateObject "WPCat", "WatchCat", "<WP_APPSFOLDER>", "OBJECTID=<WP_CAT>"

exit
