/* rexx program to tune the config.sys during phase2 from user macro file  */
/* 04.15.2001: initial release by Jeffrey R Smick (jeff.smick@verizon.net) */
/* 04.30.2001: added to UpdCD version 1.54                                 */

parse arg target

/* remark this line when debugging */
cfgfile = target||'\config.sys'

macroFile = target||"\ibminst\tunecfg.cfg"
comment = ";"

add_top.0 = 0          /* hold all items to be added to top of file */
add_bot.0 = 0          /* hold all items to be added to bottom of file */
update.0 = 0        /* items to be updated in their entirety */
remove.0 = 0        /* items to be removed */
prepend.0 = 0       /* items to be prepended to existing lists of items */
append.0 = 0        /* items to be appended to existing lists of items */

keyIdx = 1
valIdx = 2

basedev.0 = 0         /* store the line numbers of all basedev statements in the config.sys */
call.0 = 0            /* store the line numbers of all call statements in the config.sys */
device.0 = 0          /* store the line numbers of all device statements in the config.sys */
ifs.0 = 0            /* store the line numbers of all ifs statements in the config.sys */
run.0 = 0             /* store the line numbers of all run statements in the config.sys */
set.0 = 0             /* store the line numbers of all set statements in the config.sys */
misc.0 = 0            /* store the line numbers of all the rest of the statements in the config.sys */

cfgAry.0 = 0         /* stores the contents of the config.sys */

scanAryName = ""

/* open the macro file to read it only */
if stream( macroFile, "C", "OPEN READ" ) \== "READY:" then return

bInCmd = 0
bIgnore = 0
pattern = "<"
Do while lines( macroFile )
   /* read next line in to variable */
   theLine = strip( linein( macroFile ) )

   /* check if line is comment or blank - if so ignore and jump back to top of loop */
   If ( theLine == "" | substr( theLine, 1, 1 ) == comment ) Then iterate

   /* test if line is a command beginning or end */
   If pos( pattern, theLine ) > 0 Then Do
      If pattern == "<" Then Do
         cmd = translate( strip( substr( theLine, 2, length( theLine )-2 ) ) )
         bInCmd = 1
         bIgnore = 1
         pattern = "</"    /* start looking for end of command body now */
      End /* Do */
      Else Do
         bInCmd = 0
         pattern = "<"     /* resume looking for beginning of next command body now */
      End /* Do */
   End /* Do */

   If bInCmd Then Do
      If \bIgnore Then Do
         parse var theLine variable "=" definition

         definition = translate( definition, target, "?:" )

         /* add the key and val data to the appropriate task array */
         Select
            When cmd == "UPDATE" Then Do
               num = update.0 + 1
               update.num.keyIdx = variable
               update.num.valIdx = definition
               update.num.0 = 2
               update.0 = num
            End /* Do */
            When cmd == "ADD_BOT" Then Do
               num = add_bot.0 + 1
               add_bot.num.keyIdx = variable
               add_bot.num.valIdx = definition
               add_bot.num.0 = 2
               add_bot.0 = num
            End /* Do */
            When cmd == "APPEND" Then Do
               num = append.0 + 1
               append.num.keyIdx = variable
               append.num.valIdx = definition
               append.num.0 = 2
               append.0 = num
            End /* Do */
            When cmd == "REMOVE" Then Do
               num = remove.0 + 1
               remove.num.keyIdx = variable
               remove.num.valIdx = definition
               remove.num.0 = 2
               remove.0 = num
            End /* Do */
            When cmd == "ADD_TOP" Then Do
               num = add_top.0 + 1
               add_top.num.keyIdx = variable
               add_top.num.valIdx = definition
               add_top.num.0 = 2
               add_top.0 = num
            End /* Do */
            When cmd == "PREPEND" Then Do
               num = prepend.0 + 1
               prepend.num.keyIdx = variable
               prepend.num.valIdx = definition
               prepend.num.0 = 2
               prepend.0 = num
            End /* Do */
            Otherwise NOP
         End  /* Select */
      End /* Do */
      Else bIgnore = 0 /* stop ignoring lines - only ignore the first line */
   End /* Do */
End /* Do */

/* close file now - done with it */
call stream macroFile, "C", "CLOSE"

/* now read config.sys into our array */
if stream( cfgfile, "C", "OPEN" ) \== "READY:" Then exit

currentLine = 0
Do while lines( cfgfile )
   currentLine = currentLine + 1
   theLine = linein( cfgfile )
   parse var theLine variable "=" definition
   upKey = translate( variable )

   /* the point of this select is to save the current line number */
   /* as an element in the array of the type that is indicated by the variable */
   /* that way we can quickly scan only the relevant lines when */
   /* performing the editing ops later on */

   Select
      When word( upKey, 1 ) ==  "REM" | theLine == "" Then NOP  /* no ops on a remarked or blank line */
      When words( variable ) == 2 Then Do   /* it's a set statement if variable is two words instead of one */
         num = set.0 + 1
         set.num = currentLine
         set.0 = num
      End /* Do */
      When upKey == "BASEDEV" Then Do
         num = basedev.0 + 1
         basedev.num = currentLine
         basedev.0 = num
      End /* Do */
      When upKey == "CALL" Then Do
         num = call.0 + 1
         call.num = currentLine
         call.0 = num
      End /* Do */
      When upKey == "DEVICE" Then Do
         num = device.0 + 1
         device.num = currentLine
         device.0 = num
      End /* Do */
      When upKey == "IFS" Then Do
         num = ifs.0 + 1
         ifs.num = currentLine
         ifs.0 = num
      End /* Do */
      When upKey == "RUN" Then Do
         num = run.0 + 1
         run.num = currentLine
         run.0 = num
      End /* Do */
      Otherwise do
         num = misc.0 + 1
         misc.num = currentLine
         misc.0 = num
      End /* Do */
   End  /* Select */

   /* create new array with variable and definition as elements and add to our cfgAry */
   cfgAry.currentLine.keyIdx = variable
   cfgAry.currentLine.valIdx = definition
   cfgAry.currentLine.0 = 2

End /* Do */
cfgAry.0 = currentLine

/* now begin updating the config.sys list by examining appropriate task lists */
/* includes update. remove. append. and prepend. */

Do i = 1 to update.0
   upKey = translate( update.i.keyIdx )
   call setScanAryName

   limit =  value( scanAryName||0 )
   j = 1
   success = 0
   Do while ( j <= limit & \success )
      cfgElementPosition = value( scanAryName||j )

      If translate( cfgAry.cfgElementPosition.keyIdx ) == upKey Then Do
         If ( scanAryName == "basedev." | scanAryName == "device." | scanAryName == "ifs." |,
              scanAryName == "call." | scanAryName == "run." ) Then Do

            test1 = word( translate( cfgAry.cfgElementPosition.valIdx ), 1 )
            test2 = word( translate( update.i.valIdx ), 1 )
            If filespec( "N", test1 ) == filespec( "N", test2 ) Then success = 1
         End /* Do */
         Else success = 1
      End /* Do */

      If success Then
         cfgAry.cfgElementPosition.valIdx = update.i.valIdx

      j = j + 1
   end /* do */
End /* Do */

Do i = 1 to remove.0
   upKey = translate( remove.i.keyIdx )
   call setScanAryName
   limit =  value( scanAryName||0 )
   j = 1
   success = 0
   Do while ( j <= limit & \success )
      cfgElementPosition = value( scanAryName||j )

      If translate( cfgAry.cfgElementPosition.keyIdx ) == upKey Then Do
         If ( scanAryName == "basedev." | scanAryName == "device." | scanAryName == "ifs." |,
              scanAryName == "call." | scanAryName == "run." ) Then Do
            If word( translate( cfgAry.cfgElementPosition.valIdx ), 1 ) == word( translate( remove.i.valIdx ), 1 ) Then success = 1
         End /* Do */
         Else success = 1
      End /* Do */

      If success Then
         cfgAry.cfgElementPosition.keyIdx = "REM "||cfgAry.cfgElementPosition.keyIdx

      j = j + 1
   End /* Do */
End /* Do */

Do i = 1 to append.0
   upKey = translate( append.i.keyIdx )
   call setScanAryName
   limit =  value( scanAryName||0 )
   j = 1
   success = 0
   Do while ( j <= limit & \success )
      elementPosition = value( scanAryName||j )
      If translate( cfgAry.elementPosition.keyIdx ) == upKey Then Do
         success = 1
         /* make sure there is a semi-colon at end of line */
         If right( cfgAry.elementPosition.valIdx, 1 ) \== ";" Then cfgAry.elementPosition.valIdx = cfgAry.elementPosition.valIdx||";"
         /* make sure there is a semi-colon at end of the new value to appended */
         If right( append.i.valIdx, 1 ) \== ";" Then append.i.valIdx = append.i.valIdx||";"
         cfgAry.elementPosition.valIdx = cfgAry.elementPosition.valIdx||append.i.valIdx
      End /* Do */
      j = j + 1
   End /* Do */

End /* Do */

Do i = 1 to prepend.0
   upKey = translate( prepend.i.keyIdx )
   call setScanAryName
   limit =  value( scanAryName||0 )
   j = 1
   success = 0
   Do while ( j <= limit & \success )
      elementPosition = value( scanAryName||j )
      If translate( cfgAry.elementPosition.keyIdx ) == upKey Then Do
         success = 1
         /* make sure there is a semi-colon at end of the new value to appended */
         If right( prepend.i.valIdx, 1 ) \== ";" Then prepend.i.valIdx = prepend.i.valIdx||";"
         cfgAry.elementPosition.valIdx = prepend.i.valIdx||cfgAry.elementPosition.valIdx
      End /* Do */
      j = j + 1
   End /* Do */
End /* Do */

/* reposition the write pointer back to beginning of file for overwriting */
call stream cfgfile, "C", "SEEK =1"

/* write any lines to top of config.sys file */
Do i = 1 to add_top.0
   call printLn add_top.i.keyIdx, add_top.i.valIdx
End /* Do */

/* print out edited contents of cfgAry to file */
Do i = 1 to cfgAry.0
   call printLn cfgAry.i.keyIdx, cfgAry.i.valIdx
End /* Do */

/* write any lines to bottom of config.sys file */
Do i = 1 to add_bot.0
   call printLn add_bot.i.keyIdx, add_bot.i.valIdx
End /* Do */

/* close file now - done with it */
call stream cfgfile, "C", "CLOSE"

exit

/* create a printable string from the elements previously saved in an array */
printLn: procedure expose cfgfile
   parse arg variable, definition

   If definition \== "" Then Do
      variable = variable||"="||definition
   End /* Do */

   call lineout cfgfile, variable
   return

/* this procedure is used to set the value of 'scanAryName' */
setScanAryName: procedure expose scanAryName upKey
   Select
      When words( upKey ) == 2 Then scanAryName = "set."
      When upKey == "BASEDEV" Then scanAryName = "basedev."
      When upKey == "CALL" Then scanAryName = "call."
      When upKey == "DEVICE" Then scanAryName = "device."
      When upKey == "IFS" Then scanAryName = "ifs."
      When upKey == "RUN" Then scanAryName = "run."
      Otherwise scanAryName = "misc."
   End  /* Select */

   return

