/* The REXX procedure to convert the Borland file WIN32.RTF */
cr = d2c(13)
lf = d2c(10)

x = 1
file = 'WIN32'||x||'.rtf'
cntout = 'Win32.cnt2'
cntin = 'Win32.cnt'
cnttemp = 'temp.cnt'

i = 0

say 'Scanning RTF files...'

do while lines(file) = 1

   do while lines(file) = 1
      line = linein(file)

      titlepos = pos('{${\footnote',line)
      idpos = pos('{#{\footnote',line)

      if titlepos > 0 then do
         title = right(line,  length(line)  - (titlepos+12) + 1)
         title = right(title, length(title) - (pos('{$}{',title) + 4) + 1)

         /* titles are chopped on multiple lines?! */
         endpos = pos('}',title)
         total = 0
         do while endpos = 0 & lines(file)
            line = linein(file)
            title = title||line
            endpos = pos('}',title)
         end

         if endpos > 0 then
            title = left(title, endpos-1)

         call charout cnttemp,title  /* AFAIK, titles always appear before ID */
      end

      else if idpos > 0 then do
         i = i + 1
         call charout ,i 'Sections Found' cr

         id = right(line,length(line) - (titlepos+12) + 1)
         id = right(id,  length(id)   - (pos('{#}{',id) + 4) + 1)

         /* id can also be chopped on multiple lines!! */
         endpos = pos('}',id)
         total = 0
         do while endpos = 0 & lines(file)
            line = linein(file)
            id = id||line
            endpos = pos('}',id)
         end

         if endpos > 0 then
            id = left(id, endpos-1)

         call lineout cnttemp,'='id  /* AFAIK, id always after titles */
      end

   end

   call stream file, 'c', 'close'

   x = x + 1
   file = 'WIN32'||x||'.rtf'
end

say 'Merging CNT files...'

i = 0

/* doesn't seem to like to be read from after being written to */
call stream cnttemp, 'c', 'close'

do while lines(cntin)
   line1 = linein(cntin)
   equalpos = pos('=',line1)
   if equalpos > 0 then do

      title = left(line1, equalpos-1)

      found = 0
      try = 0

      /* most of them are in order, so I only rewind if necessary */

      do until try = 2 | found = 1
         try = try + 1
         do while lines(cnttemp)
            line2 = linein(cnttemp)

            if right(title, length(title) - 2) = left(line2, pos('=',line2)-1) then do
               call lineout cntout,title'='right(line2,length(line2) - pos('=',line2))
               found = 1
               leave
            end
         end
         if found = 0 then
            call linein cnttemp,1,0 /* rewind */
      end

      if found = 0 then do
         Say 'Warning: could not find an ID for Section ' title
         call lineout cntout,title
      end
   end
   else
      call lineout cntout,line1

   i = i + 1
   call charout ,i 'Sections from original CNT file Processed' cr
end
