   ---------------------------------------------------
   ---  Date:        16/Jan/94                     ---
   ---  Author:      Graeme Birchall               ---
   ---  Address:     35 River Drive South #1214    ---
   ---               Jersey City NJ 07310          ---
   ---  Ph/Fax:      (201)-963-0071                --- 
   ---  Compuserve   73540,1566                    ---
   ---  Purpose:     DB2/2 Course - Sample DDL     ---
   ---                            - Sample SQL     ---
   ---------------------------------------------------

   CREATE TABLE BASE_TABLE
     (U1     SMALLINT  NOT NULL,
      U2     CHAR(02)  NOT NULL,
      U3     CHAR(02)  NOT NULL,
      D1     SMALLINT  NOT NULL,
      D2     CHAR(01)  NOT NULL,
      DATE1  DATE      NOT NULL);
   COMMIT;

   INSERT INTO BASE_TABLE VALUES (0,'C0','W0',9,'J','0001-01-01');
   INSERT INTO BASE_TABLE VALUES (1,'C1','W1',8,'I','0001-01-01');
   INSERT INTO BASE_TABLE VALUES (2,'C2','W2',7,'H','0001-01-01');
   INSERT INTO BASE_TABLE VALUES (3,'C3','W3',6,'G','0001-01-01');
   INSERT INTO BASE_TABLE VALUES (4,'C4','W4',5,'F','0001-01-01');
   INSERT INTO BASE_TABLE VALUES (5,'C5','W5',4,'E','0001-01-01');
   INSERT INTO BASE_TABLE VALUES (6,'C6','W6',3,'D','0001-01-01');
   INSERT INTO BASE_TABLE VALUES (7,'C7','W7',2,'C','0001-01-01');
   INSERT INTO BASE_TABLE VALUES (8,'C8','W8',1,'B','0001-01-01');
   INSERT INTO BASE_TABLE VALUES (9,'C9','W9',0,'A','0001-01-01');
   COMMIT;

   CREATE TABLE CITY_TABLE
     (CITY_NUM            INTEGER   NOT NULL,
      CITY_RGN            CHAR(04)  NOT NULL,
      CITY_DATA           CHAR(04)  NOT NULL,
      CITY_PADDING        CHAR(80)  NOT NULL);
   COMMIT;

   CREATE UNIQUE INDEX ICITYNUM  ON CITY_TABLE
      (CITY_NUM);
   COMMIT;

   CREATE INDEX ICITYNME  ON CITY_TABLE
      (CITY_RGN);
   COMMIT;

   INSERT INTO CITY_TABLE
   SELECT U1
         ,' '
         ,D2
         ,'CITY'
   FROM BASE_TABLE;
   COMMIT;

   UPDATE CITY_TABLE
   SET    CITY_RGN = 'C0' 
   WHERE  CITY_NUM = CITY_NUM/2 * 2;

   UPDATE CITY_TABLE
   SET    CITY_RGN = 'C1'
   WHERE  CITY_NUM <> CITY_NUM/2 * 2;
   COMMIT;

   CREATE TABLE WHSE_TABLE
     (CITY_NUM            INTEGER   NOT NULL,
      WHSE_NUM            INTEGER   NOT NULL,
      WHSE_NAME           CHAR(04)  NOT NULL,
      WHSE_SIZE           INTEGER   NOT NULL,
      WHSE_PADDING        CHAR(76)  NOT NULL);
   COMMIT;

   CREATE UNIQUE INDEX IWHSENUM  ON WHSE_TABLE
      (CITY_NUM, WHSE_NUM);
   COMMIT;

   CREATE UNIQUE INDEX IWHSENME  ON WHSE_TABLE
      (WHSE_NAME);
   COMMIT;

   INSERT INTO WHSE_TABLE
   SELECT A.U1
         ,100 + B.U1
         ,SUBSTR(CHAR(A.DATE1 + (A.U1*10 + B.U1) YEARS,ISO),1,4)
         ,100 + A.U1
         ,'WHSE'
   FROM  BASE_TABLE A,
         BASE_TABLE B
   WHERE B.U1 < 4;
   COMMIT;

   CREATE TABLE PROD_TABLE
     (PROD_NUM            INTEGER   NOT NULL,
      PROD_NAME           CHAR(04)  NOT NULL,
      PROD_TYPE           CHAR(04)  NOT NULL,
      PROD_COST           INTEGER   NOT NULL,
      PROD_PADDING        CHAR(76)  NOT NULL);
   COMMIT;

   CREATE UNIQUE INDEX IPRODNUM  ON PROD_TABLE
      (PROD_NUM);
   COMMIT;

   CREATE UNIQUE INDEX IPRODNME  ON PROD_TABLE
      (PROD_NAME);
   COMMIT;

   CREATE INDEX IPRODTYP  ON PROD_TABLE
      (PROD_TYPE);
   COMMIT;

   INSERT INTO PROD_TABLE
   SELECT  2000 + A.U1*100 + B.U1*10 + C.U1
          ,SUBSTR(CHAR(A.DATE1 + (A.U1*100 + B.U1*10 + C.U1) YEARS,ISO),1,4)
          ,A.D2
          ,2000 + A.U1*10+B.U1
          ,'PROD'
   FROM  BASE_TABLE A,
         BASE_TABLE B,
         BASE_TABLE C
   WHERE B.U1 < 3;
   COMMIT;

   UPDATE PROD_TABLE
   SET    PROD_PADDING = 'ABC%DEF'
   WHERE  PROD_NUM     =  2000;

   CREATE VIEW PROD_VIEW  (PROD_COST)
       AS   SELECT  AVG(PROD_COST)
       FROM PROD_TABLE;

   CREATE TABLE WP_TABLE
     (CITY_NUM            INTEGER   NOT NULL,
      WHSE_NUM            INTEGER   NOT NULL,
      PROD_NUM            INTEGER   NOT NULL,
      QTY                 INTEGER   NOT NULL,
      WP_PADDING          CHAR(76)  NOT NULL);
   COMMIT;

   CREATE VIEW WP_VIEW
    (CITY_NUM
    ,NMBR_PROD
    ,SUM_QTY
    ,NMBR_ROWS)
   AS
   SELECT   CITY_NUM
           ,COUNT(DISTINCT PROD_NUM)
           ,SUM(QTY)
           ,COUNT(*)
   FROM     WP_TABLE
   GROUP BY CITY_NUM;
   COMMIT;

   INSERT INTO WP_TABLE
   SELECT CITY_NUM
         ,WHSE_NUM
         ,PROD_NUM
         ,WHSE_SIZE + PROD_COST
         ,'WP'
   FROM   WHSE_TABLE,
          PROD_TABLE
   WHERE CITY_NUM IN (0,1);
   COMMIT;

   INSERT INTO WP_TABLE
   SELECT CITY_NUM
         ,WHSE_NUM
         ,PROD_NUM
         ,WHSE_SIZE + PROD_COST
         ,'WP'
   FROM   WHSE_TABLE,
          PROD_TABLE
   WHERE CITY_NUM IN (2,3);
   COMMIT;

   INSERT INTO WP_TABLE
   SELECT CITY_NUM
         ,WHSE_NUM
         ,PROD_NUM
         ,WHSE_SIZE + PROD_COST
         ,'WP'
   FROM   WHSE_TABLE,
          PROD_TABLE
   WHERE CITY_NUM IN (4,5);
   COMMIT;

   INSERT INTO WP_TABLE
   SELECT CITY_NUM
         ,WHSE_NUM
         ,PROD_NUM
         ,WHSE_SIZE + PROD_COST
         ,'WP'
   FROM   WHSE_TABLE,
          PROD_TABLE
   WHERE CITY_NUM IN (6,7);
   COMMIT;

   INSERT INTO WP_TABLE
   SELECT CITY_NUM
         ,WHSE_NUM
         ,PROD_NUM
         ,WHSE_SIZE + PROD_COST
         ,'WP'
   FROM   WHSE_TABLE,
          PROD_TABLE
   WHERE CITY_NUM IN (8,9);
   COMMIT;

   CREATE UNIQUE INDEX IWPWHSE ON WP_TABLE
      (CITY_NUM, WHSE_NUM, PROD_NUM);
   COMMIT;

   CREATE UNIQUE INDEX IWPPROD ON WP_TABLE
      (PROD_NUM, CITY_NUM, WHSE_NUM);
   COMMIT;

   CREATE TABLE SALE_TABLE
     (PROD_NUM        INTEGER       NOT NULL,
      SALE_DATE       DATE                  ,
      SALE_TIME       TIME                  ,
      NUM_SOLD        INTEGER               ,
      ITEM_COST       DECIMAL(7,2)          ,
      CUST_NUM        INTEGER               ,
      SALE_PADDING    CHAR(63)              );
   COMMIT;

   CREATE VIEW SALE_WEEK
     (PROD_NUM       ,SALE_DATE   ,SALE_TIME
     ,NUM_SOLD       ,ITEM_COST   ,CUST_NUM
     ,SALE_PADDING   ,WEEK_DAY)
   AS SELECT
      PROD_NUM       ,SALE_DATE   ,SALE_TIME
     ,NUM_SOLD       ,ITEM_COST   ,CUST_NUM
     ,SALE_PADDING
     ,((DAYS(SALE_DATE) - DAYS('1993-01-17')) -
     (((DAYS(SALE_DATE) - DAYS('1993-01-17'))/7) * 7)) + 1
   FROM SALE_TABLE;
   COMMIT;

   CREATE UNIQUE INDEX ISALENUM  ON SALE_TABLE
      (PROD_NUM
      ,SALE_DATE
      ,SALE_TIME);
   COMMIT;

   CREATE INDEX ISALCUST  ON SALE_TABLE
      (CUST_NUM);
   COMMIT;

   INSERT INTO SALE_TABLE
   SELECT 2000 + A.U1*100 + B.U1*10 + C.U1
         ,DATE('1994-01-01') + B.U1 MONTHS - A.U1 DAYS
         ,TIME('12.00.00')   - D.U1 HOURS  + C.U1 MINUTES
         ,D.U1*10 + A.U1
         ,A.U1*100 + B.U1*10 + D.U1/100
         ,D.U1*1000 + C.U1*100
         ,'SALE'
   FROM  BASE_TABLE A
        ,BASE_TABLE B
        ,BASE_TABLE C
        ,BASE_TABLE D
   WHERE B.U1 = 0
     AND C.U1 BETWEEN 1 AND 8;
   COMMIT;

   INSERT INTO SALE_TABLE
   SELECT 2000 + A.U1*100 + B.U1*10 + C.U1
         ,DATE('1994-01-01') + B.U1 MONTHS - A.U1 DAYS
         ,TIME('12.00.00')   - D.U1 HOURS  + C.U1 MINUTES
         ,D.U1*10 + A.U1
         ,A.U1*100 + B.U1*10 + D.U1/100
         ,D.U1*1000 + C.U1*100
         ,'SALE'
   FROM  BASE_TABLE A
        ,BASE_TABLE B
        ,BASE_TABLE C
        ,BASE_TABLE D
   WHERE B.U1 = 1
     AND C.U1 BETWEEN 1 AND 8;
   COMMIT;

   INSERT INTO SALE_TABLE
   SELECT 2000 + A.U1*100 + B.U1*10 + C.U1
         ,DATE('1994-01-01') + B.U1 MONTHS - A.U1 DAYS
         ,TIME('12.00.00')   - D.U1 HOURS  + C.U1 MINUTES
         ,D.U1*10 + A.U1
         ,A.U1*100 + B.U1*10 + D.U1/100
         ,D.U1*1000 + C.U1*100
         ,'SALE'
   FROM  BASE_TABLE A
        ,BASE_TABLE B
        ,BASE_TABLE C
        ,BASE_TABLE D
   WHERE B.U1 = 2
     AND C.U1 BETWEEN 1 AND 8;
   COMMIT;

   UPDATE SALE_TABLE
   SET    CUST_NUM = NULL
   WHERE  PROD_NUM - (PROD_NUM/10*10) BETWEEN 3 AND 4;
   COMMIT;

   UPDATE SALE_TABLE
   SET    CUST_NUM  = NULL
         ,NUM_SOLD  = NULL
   WHERE  PROD_NUM - (PROD_NUM/10*10) BETWEEN 5 AND 6;
   COMMIT;

   UPDATE SALE_TABLE
   SET    CUST_NUM  = NULL
         ,NUM_SOLD  = NULL
         ,ITEM_COST = NULL
   WHERE  PROD_NUM - (PROD_NUM/10*10) BETWEEN 7 AND 8;
   COMMIT;

   -----------------------------------------------------
   ---  Populate Bufferpool SQL                      ---
   -----------------------------------------------------
   
   SELECT COUNT(*) FROM CITY_TABLE; 
   SELECT COUNT(*) FROM CITY_TABLE WHERE CITY_NUM >= 0;
   SELECT COUNT(*) FROM CITY_TABLE WHERE CITY_RGN = ' ';
   SELECT COUNT(*) FROM CITY_TABLE WHERE CITY_DATA = ' '; 
   
   SELECT COUNT(*) FROM WHSE_TABLE; 
   SELECT COUNT(*) FROM WHSE_TABLE WHERE CITY_NUM >= 0;
   SELECT COUNT(*) FROM WHSE_TABLE WHERE WHSE_NAME = ' '; 
   SELECT COUNT(*) FROM WHSE_TABLE WHERE WHSE_SIZE = 0;
   
   SELECT COUNT(*) FROM PROD_TABLE; 
   SELECT COUNT(*) FROM PROD_TABLE WHERE PROD_NUM >= 2000;
   SELECT COUNT(*) FROM PROD_TABLE WHERE PROD_NAME = ' '; 
   SELECT COUNT(*) FROM PROD_TABLE WHERE PROD_TYPE = ' '; 
   SELECT COUNT(*) FROM PROD_TABLE WHERE PROD_COST = 0;
   
   SELECT COUNT(*) FROM WP_TABLE;
   SELECT COUNT(*) FROM WP_TABLE WHERE CITY_NUM >= 0;
   SELECT COUNT(*) FROM WP_TABLE WHERE PROD_NUM >= 2000;
   SELECT COUNT(*) FROM WP_TABLE WHERE QTY  = 0;
   COMMIT;
   
   -----------------------------------------------------
   ---  Performance Test SQL                         ---
   -----------------------------------------------------
   
   ----------------------------------
   --- Between example            ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50001 CURSOR FOR
   SELECT *
   FROM   WP_TABLE
   WHERE  CITY_NUM >= 4
     AND  CITY_NUM <= 6;

-- EXPLAIN DECLARE C50001 CURSOR FOR
   SELECT *
   FROM   WP_TABLE
   WHERE  CITY_NUM BETWEEN 4 AND 6;

   ----------------------------------
   --- No Transitive Closure #1   ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50101 CURSOR FOR
   SELECT   *
   FROM     PROD_TABLE A,
            WP_TABLE   B 
   WHERE    A.PROD_NUM  = B.PROD_NUM
     AND    B.PROD_NUM  < 2100 
     AND    B.CITY_NUM  = 1
   ORDER BY A.PROD_NUM;
   
-- EXPLAIN DECLARE C50102 CURSOR FOR
   SELECT   *
   FROM     PROD_TABLE A,
            WP_TABLE   B 
   WHERE    A.PROD_NUM  = B.PROD_NUM
     AND    A.PROD_NUM  < 2100 
     AND    B.CITY_NUM  = 1
   ORDER BY A.PROD_NUM;
   
   ----------------------------------
   --- No Transitive Closure #2   ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50151 CURSOR FOR
   SELECT *
   FROM   WP_TABLE A
         ,WP_TABLE B
   WHERE  A.CITY_NUM = B.CITY_NUM
     AND  A.WHSE_NUM = B.WHSE_NUM
     AND  A.PROD_NUM = B.PROD_NUM
     AND  B.CITY_NUM = 1
     AND  A.WHSE_NUM = 100;
   
-- EXPLAIN DECLARE C50152 CURSOR FOR
   SELECT *
   FROM   WP_TABLE A
         ,WP_TABLE B
   WHERE  A.CITY_NUM = B.CITY_NUM
     AND  A.WHSE_NUM = B.WHSE_NUM
     AND  A.PROD_NUM = B.PROD_NUM
     AND  A.CITY_NUM = 1
     AND  A.WHSE_NUM = 100;
   
   ----------------------------------
   --- No Transitive Closure #3   ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50201 CURSOR FOR
   SELECT   A.PROD_NUM, 
            A.CITY_NUM, 
            A.WHSE_NUM
   FROM     WP_TABLE A
   WHERE    EXISTS 
           (SELECT PROD_NUM
            FROM   PROD_TABLE B 
            WHERE  A.PROD_NUM = B.PROD_NUM
              AND  B.PROD_NUM < 2001);
   
-- EXPLAIN DECLARE C50202 CURSOR FOR
   SELECT   A.PROD_NUM, 
            A.CITY_NUM, 
            A.WHSE_NUM
   FROM     WP_TABLE A
   WHERE    A.PROD_NUM   < 2001
     AND    EXISTS 
           (SELECT PROD_NUM
            FROM   PROD_TABLE B 
            WHERE  A.PROD_NUM = B.PROD_NUM); 
   
   ----------------------------------
   --- Repeating Predicates - AND ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50251 CURSOR FOR
   SELECT *
   FROM   WP_TABLE
   WHERE  PROD_NUM < 2070;
   
-- EXPLAIN DECLARE C50252 CURSOR FOR
   SELECT *
   FROM   WP_TABLE
   WHERE  PROD_NUM < 2070
     AND  PROD_NUM < 2070;
   
   ----------------------------------
   --- Using Expression           ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50001 CURSOR FOR
   SELECT *
   FROM   WP_TABLE
   WHERE  CITY_NUM = 1
     AND  WHSE_NUM = 100
     AND  PROD_NUM < 2001;

-- EXPLAIN DECLARE C50001 CURSOR FOR
   SELECT *
   FROM   WP_TABLE
   WHERE  CITY_NUM = 1
     AND  WHSE_NUM = 100
     AND  PROD_NUM < 2001 * 1;

-- EXPLAIN DECLARE C50001 CURSOR FOR
   SELECT MIN(CITY_NUM)
   FROM   WP_TABLE
   WHERE  CITY_NUM < 1;

-- EXPLAIN DECLARE C50001 CURSOR FOR
   SELECT MIN(CITY_NUM)
   FROM   WP_TABLE
   WHERE  CITY_NUM < 1 * 1;

   ----------------------------------
   --- Moving outside of OR       ---
   ----------------------------------
   
-- EXPLAIN DECLARE C30301 CURSOR FOR
   SELECT QTY
   FROM   WP_TABLE 
   WHERE (CITY_NUM  = 0 
     AND  WHSE_NUM <= 100
     AND  PROD_NUM  < 2005)
      OR (CITY_NUM  = 0 
     AND  WHSE_NUM <= 100
     AND  PROD_NUM  > 2925);
   
-- EXPLAIN DECLARE C50302 CURSOR FOR
   SELECT QTY
   FROM   WP_TABLE 
   WHERE  CITY_NUM  = 0 
     AND  WHSE_NUM <= 100
     AND (PROD_NUM  < 2005 
      OR  PROD_NUM  > 2925);
   
   ----------------------------------
   --- Redundant Sorting          ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50351 CURSOR FOR
   SELECT   DISTINCT 
            PROD_NUM,
            WHSE_NUM
   FROM     WP_TABLE
   WHERE    PROD_NUM = 2000
   UNION
   SELECT   DISTINCT 
            PROD_NUM,
            WHSE_NUM
   FROM     WP_TABLE
   WHERE    PROD_NUM = 2001;
   
-- EXPLAIN DECLARE C50352 CURSOR FOR
   SELECT   PROD_NUM,
            WHSE_NUM
   FROM     WP_TABLE
   WHERE    PROD_NUM = 2000
   UNION
   SELECT   PROD_NUM,
            WHSE_NUM
   FROM     WP_TABLE
   WHERE    PROD_NUM = 2001;

   ----------------------------------
   --- Resolving Rows Before Join ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50401 CURSOR FOR
   SELECT   CITY_NUM,
            SUM(WHSE_SIZE),
            AVG(PROD_COST) 
   FROM     WHSE_TABLE,
            PROD_TABLE
   WHERE    WHSE_NUM = 100 
   GROUP BY CITY_NUM;
   
-- EXPLAIN DECLARE C50402 CURSOR FOR
   SELECT   CITY_NUM,
            SUM(WHSE_SIZE),
            AVG(PROD_COST) 
   FROM     WHSE_TABLE,
            PROD_VIEW 
   WHERE    WHSE_NUM = 100 
   GROUP BY CITY_NUM;
   
   ----------------------------------
   --- View Materialization       ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50421 CURSOR FOR
   SELECT   *
   FROM     WP_VIEW 
   WHERE    CITY_NUM < 2;

-- EXPLAIN DECLARE C50422 CURSOR FOR
   SELECT   CITY_NUM
           ,COUNT(DISTINCT PROD_NUM)
           ,SUM(QTY)
           ,COUNT(*)
   FROM     WP_TABLE
   WHERE    CITY_NUM < 2
   GROUP BY CITY_NUM;
  
   ----------------------------------
   --- Smaller Work Files         ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50451 CURSOR FOR
   SELECT *
   FROM   WP_TABLE A
   WHERE  A.CITY_NUM = 1
     AND  A.PROD_NUM NOT IN
         (SELECT PROD_NUM
          FROM   PROD_TABLE B 
          WHERE  PROD_NUM >= 2010);
   
-- EXPLAIN DECLARE C50452 CURSOR FOR
   SELECT *
   FROM   WP_TABLE A
   WHERE  A.CITY_NUM = 1
     AND  A.PROD_NUM IN
         (SELECT PROD_NUM
          FROM   PROD_TABLE B 
          WHERE  PROD_NUM < 2010);
   
   ----------------------------------
   --- Ordering Work Files        ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50501 CURSOR FOR
   SELECT PROD_NUM
   FROM   WP_TABLE
   WHERE  PROD_NUM <  2005 
     AND  PROD_NUM IN
         (SELECT PROD_NUM
          FROM   PROD_TABLE);
   
-- EXPLAIN DECLARE C50502 CURSOR FOR
   SELECT PROD_NUM 
   FROM   WP_TABLE  
   WHERE  PROD_NUM <  2005 
     AND  PROD_NUM * -1 IN 
         (SELECT PROD_NUM * -1
          FROM   PROD_TABLE);
   
   ----------------------------------
   --- Join v.s Sub-query         ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50551 CURSOR FOR
   SELECT   DISTINCT 
            A.PROD_NUM
   FROM     PROD_TABLE A,
            WP_TABLE B
   WHERE    A.PROD_NUM = B.PROD_NUM
     AND    A.PROD_NUM < 2020;
   
-- EXPLAIN DECLARE C50552 CURSOR FOR
   SELECT   DISTINCT 
            A.PROD_NUM
   FROM     PROD_TABLE A 
   WHERE    A.PROD_NUM < 2020 
     AND    EXISTS 
           (SELECT PROD_NUM
            FROM   WP_TABLE B 
            WHERE  A.PROD_NUM = B.PROD_NUM);
   
   ----------------------------------
   --- Join vs. Sub-query         ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50601 CURSOR FOR
   SELECT   A.PROD_NUM, 
            A.CITY_NUM, 
            A.WHSE_NUM
   FROM     WP_TABLE A
   WHERE    EXISTS 
           (SELECT PROD_NUM
            FROM   PROD_TABLE B 
            WHERE  A.PROD_NUM = B.PROD_NUM
              AND  B.PROD_NUM < 2001);
   
-- EXPLAIN DECLARE C50602 CURSOR FOR
   SELECT   A.PROD_NUM, 
            A.CITY_NUM, 
            A.WHSE_NUM
   FROM     WP_TABLE A,
            PROD_TABLE B 
   WHERE    A.PROD_NUM = B.PROD_NUM
     AND    B.PROD_NUM < 2001;
   
   ----------------------------------
   --- Corr. vs. Unc. Sub-query   ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50651 CURSOR FOR
   SELECT   PROD_NUM, PROD_COST
   FROM     PROD_TABLE A
   WHERE    PROD_NUM  < 2100
     AND    PROD_NUM IN 
           (SELECT  PROD_NUM
            FROM    WP_TABLE B);
   
-- EXPLAIN DECLARE C50652 CURSOR FOR
   SELECT   PROD_NUM, PROD_COST
   FROM     PROD_TABLE A 
   WHERE    PROD_NUM  < 2100
     AND    EXISTS 
           (SELECT  *
            FROM    WP_TABLE B
            WHERE   A.PROD_NUM = B.PROD_NUM);
   
   ----------------------------------
   --- Corr. vs. Unc. Sub-query   ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50701 CURSOR FOR
   SELECT   PROD_NUM, PROD_COST
   FROM     PROD_TABLE A  
   WHERE    EXISTS 
           (SELECT  *
            FROM    PROD_TABLE B
            WHERE   A.PROD_NUM = B.PROD_COST);
   
-- EXPLAIN DECLARE C50702 CURSOR FOR
   SELECT   PROD_NUM, PROD_COST
   FROM     PROD_TABLE A  
   WHERE    A.PROD_NUM IN 
           (SELECT  B.PROD_COST
            FROM    PROD_TABLE B);
   
   ----------------------------------
   --- Use MIN to minimize SubQ.  ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50751 CURSOR FOR
   SELECT *
   FROM   WHSE_TABLE A
   WHERE  A.CITY_NUM > ANY
         (SELECT B.CITY_NUM
          FROM   WP_TABLE B);
   
-- EXPLAIN DECLARE C50752 CURSOR FOR
   SELECT *
   FROM   WHSE_TABLE A
   WHERE  A.CITY_NUM > ANY
         (SELECT MIN(B.CITY_NUM)
          FROM   WP_TABLE B);

   ----------------------------------
   --- Do Sub-query First         ---
   ----------------------------------
   
-- EXPLAIN DECLARE C50801 CURSOR FOR
   SELECT   *
   FROM     WHSE_TABLE A,
            WP_TABLE   B
   WHERE    A.CITY_NUM = B.CITY_NUM
     AND    A.WHSE_NUM = B.WHSE_NUM
     AND    A.WHSE_NUM = 100
     AND    EXISTS
           (SELECT *
            FROM   CITY_TABLE C
            WHERE  C.CITY_DATA = 'J'
              AND  C.CITY_NUM  = B.CITY_NUM);

-- EXPLAIN DECLARE C50802 CURSOR FOR
   SELECT   *
   FROM     WHSE_TABLE A,
            WP_TABLE   B
   WHERE    A.CITY_NUM = B.CITY_NUM
     AND    A.WHSE_NUM = B.WHSE_NUM
     AND    A.WHSE_NUM = 100
     AND    EXISTS
           (SELECT *
            FROM   CITY_TABLE C
            WHERE  C.CITY_DATA = 'J'
              AND  C.CITY_NUM  = A.CITY_NUM);
